/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.Dimension;
import java.awt.Insets;
import javax.swing.JComponent;
import org.netbeans.swing.tabcontrol.TabDataModel;
import org.netbeans.swing.tabcontrol.plaf.TabLayoutModel;

final class ViewTabLayoutModel
implements TabLayoutModel {
    private TabDataModel model;
    private JComponent renderTarget;

    public ViewTabLayoutModel(TabDataModel tabDataModel, JComponent jComponent) {
        this.model = tabDataModel;
        this.renderTarget = jComponent;
    }

    @Override
    public int getH(int n) {
        this.checkIndex(n);
        Insets insets = this.renderTarget.getInsets();
        return this.renderTarget.getHeight() - (insets.bottom + insets.top);
    }

    @Override
    public int getW(int n) {
        int n2;
        this.checkIndex(n);
        int n3 = this.computeX(n);
        if (n < this.model.size() - 1) {
            n2 = this.computeX(n + 1);
        } else {
            Insets insets = this.renderTarget.getInsets();
            n2 = this.renderTarget.getWidth() - insets.right;
        }
        return n2 - n3;
    }

    @Override
    public int getX(int n) {
        this.checkIndex(n);
        return this.computeX(n);
    }

    @Override
    public int getY(int n) {
        this.checkIndex(n);
        return this.renderTarget.getInsets().top;
    }

    @Override
    public int indexOfPoint(int n, int n2) {
        Insets insets = this.renderTarget.getInsets();
        int n3 = this.renderTarget.getWidth() - (insets.left + insets.right);
        int n4 = this.renderTarget.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.model.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = n - this.computeX(i);
            if (n6 < 0 || n6 >= this.getW(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int dropIndexOfPoint(int n, int n2) {
        Insets insets = this.renderTarget.getInsets();
        int n3 = this.renderTarget.getWidth() - (insets.left + insets.right);
        int n4 = this.renderTarget.getHeight() - (insets.bottom + insets.top);
        if (n2 < insets.top || n2 > n4 || n < insets.left || n > n3) {
            return -1;
        }
        int n5 = this.model.size();
        float f = (float)n3 / (float)n5;
        n = n - insets.left + (int)f / 2;
        int n6 = (int)((float)n / f);
        return Math.min(n6, this.model.size());
    }

    @Override
    public void setPadding(Dimension dimension) {
    }

    private void checkIndex(int n) {
        int n2 = this.model.size();
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException("Index out of valid scope 0.." + (n2 - 1) + ": " + n);
        }
    }

    private int computeX(int n) {
        Insets insets = this.renderTarget.getInsets();
        int n2 = this.renderTarget.getWidth() - (insets.left + insets.right);
        return n2 * n / this.model.size() + insets.left;
    }
}

