/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.modules.profiler.api.ProfilerIDESettings;
import org.netbeans.modules.profiler.v2.ProfilerFeature;
import org.netbeans.modules.profiler.v2.ProfilerSession;
import org.netbeans.modules.profiler.v2.SessionStorage;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

final class ProfilerFeatures {
    private static final String FLAG_SINGLE_FEATURE = "SINGLE_FEATURE";
    private static final String FLAG_ACTIVATED_FEATURES = "ACTIVATED_FEATURES";
    private static final String FLAG_PROFILING_POINTS = "PROFILING_POINTS";
    private static final Boolean SINGLE_FEATURE_DEFAULT = Boolean.TRUE;
    private static final Boolean PROFILING_POINTS_DEFAULT = Boolean.TRUE;
    private static final Comparator<ProfilerFeature> FEATURES_COMPARATOR = new Comparator<ProfilerFeature>(){

        @Override
        public int compare(ProfilerFeature profilerFeature, ProfilerFeature profilerFeature2) {
            return Integer.compare(profilerFeature.getPosition(), profilerFeature2.getPosition());
        }
    };
    private final ProfilerSession session;
    private final Set<ProfilerFeature> features;
    private final Set<ProfilerFeature> activated;
    private final Set<Listener> listeners;
    private final ChangeListener listener = new ChangeListener(){

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            ProfilerFeatures.this.fireSettingsChanged();
        }
    };
    private boolean singleFeatured;
    private boolean ppoints;
    private volatile boolean loading;

    ProfilerFeatures(ProfilerSession profilerSession) {
        this.session = profilerSession;
        SessionStorage sessionStorage = profilerSession.getStorage();
        this.singleFeatured = Boolean.parseBoolean(sessionStorage.readFlag(FLAG_SINGLE_FEATURE, SINGLE_FEATURE_DEFAULT.toString()));
        this.ppoints = Boolean.parseBoolean(sessionStorage.readFlag(FLAG_PROFILING_POINTS, PROFILING_POINTS_DEFAULT.toString()));
        this.features = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        this.activated = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        this.listeners = new HashSet<Listener>();
        for (ProfilerFeature.Provider provider : ProfilerFeature.Registry.getProviders()) {
            ProfilerFeature profilerFeature = provider.getFeature(profilerSession);
            if (profilerFeature == null) continue;
            this.features.add(profilerFeature);
        }
        this.loadActivatedFeatures();
    }

    Set<ProfilerFeature> getAvailable() {
        return this.features;
    }

    Set<ProfilerFeature> getActivated() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.activated;
    }

    static Set<ProfilerFeature> getCompatible(Set<ProfilerFeature> set, Lookup lookup) {
        TreeSet<ProfilerFeature> treeSet = new TreeSet<ProfilerFeature>(FEATURES_COMPARATOR);
        for (ProfilerFeature profilerFeature : set) {
            if (!profilerFeature.supportsConfiguration(lookup)) continue;
            treeSet.add(profilerFeature);
        }
        return treeSet;
    }

    void activateFeature(ProfilerFeature profilerFeature) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.singleFeatured) {
            if (this.activated.size() == 1 && this.activated.contains(profilerFeature)) {
                return;
            }
            for (ProfilerFeature profilerFeature2 : this.activated) {
                profilerFeature2.deactivatedInSession();
                profilerFeature2.removeChangeListener(this.listener);
            }
            this.activated.clear();
            this.activated.add(profilerFeature);
            profilerFeature.addChangeListener(this.listener);
            profilerFeature.activatedInSession();
            this.fireFeaturesChanged(profilerFeature);
            this.saveActivatedFeatures();
        } else if (this.activated.add(profilerFeature)) {
            ProfilingSettings profilingSettings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
            profilerFeature.configureSettings(profilingSettings);
            Iterator<ProfilerFeature> iterator = this.activated.iterator();
            while (iterator.hasNext()) {
                ProfilerFeature profilerFeature3 = iterator.next();
                if (profilerFeature3 == profilerFeature || profilerFeature3.supportsSettings(profilingSettings)) continue;
                iterator.remove();
                profilerFeature3.deactivatedInSession();
                profilerFeature3.removeChangeListener(this.listener);
            }
            profilerFeature.addChangeListener(this.listener);
            profilerFeature.activatedInSession();
            this.fireFeaturesChanged(profilerFeature);
            this.saveActivatedFeatures();
        }
    }

    void deactivateFeature(ProfilerFeature profilerFeature) {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activated.size() == 1 && this.activated.contains(profilerFeature) && this.session.inProgress()) {
            return;
        }
        if (this.activated.remove(profilerFeature)) {
            profilerFeature.deactivatedInSession();
            profilerFeature.removeChangeListener(this.listener);
            this.fireFeaturesChanged(profilerFeature);
            this.saveActivatedFeatures();
        }
    }

    void toggleActivated(ProfilerFeature profilerFeature) {
        if (this.activated.contains(profilerFeature)) {
            this.deactivateFeature(profilerFeature);
        } else {
            this.activateFeature(profilerFeature);
        }
    }

    private void loadActivatedFeatures() {
        this.loading = true;
        final String string = this.session.getStorage().readFlag(FLAG_ACTIVATED_FEATURES, "");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (ProfilerFeature profilerFeature : ProfilerFeatures.this.features) {
                    if (!string.contains(ProfilerFeatures.getFeatureID(profilerFeature))) continue;
                    ProfilerFeatures.this.activateFeature(profilerFeature);
                }
                ProfilerFeatures.this.loading = false;
            }
        });
    }

    private void saveActivatedFeatures() {
        if (this.loading) {
            return;
        }
        final HashSet<ProfilerFeature> hashSet = new HashSet<ProfilerFeature>(this.activated);
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                SessionStorage sessionStorage = ProfilerFeatures.this.session.getStorage();
                if (hashSet.isEmpty()) {
                    sessionStorage.storeFlag(ProfilerFeatures.FLAG_ACTIVATED_FEATURES, null);
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (ProfilerFeature profilerFeature : hashSet) {
                        stringBuilder.append(ProfilerFeatures.getFeatureID(profilerFeature));
                    }
                    sessionStorage.storeFlag(ProfilerFeatures.FLAG_ACTIVATED_FEATURES, stringBuilder.toString());
                }
            }
        });
    }

    private static String getFeatureID(ProfilerFeature profilerFeature) {
        return "#" + profilerFeature.getClass().getName() + "@";
    }

    void setSingleFeatured(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.singleFeatured = bl;
        if (this.singleFeatured && !this.activated.isEmpty()) {
            this.activateFeature(this.activated.iterator().next());
        }
        this.session.getStorage().storeFlag(FLAG_SINGLE_FEATURE, SINGLE_FEATURE_DEFAULT.equals(bl) ? null : Boolean.toString(this.singleFeatured));
    }

    boolean isSingleFeatured() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.singleFeatured;
    }

    void setUseProfilingPoints(boolean bl) {
        assert (SwingUtilities.isEventDispatchThread());
        this.ppoints = bl;
        this.session.getStorage().storeFlag(FLAG_PROFILING_POINTS, PROFILING_POINTS_DEFAULT.equals(bl) ? null : Boolean.toString(bl));
    }

    boolean getUseProfilingPoints() {
        assert (SwingUtilities.isEventDispatchThread());
        return this.ppoints;
    }

    boolean settingsValid() {
        assert (SwingUtilities.isEventDispatchThread());
        if (this.activated.isEmpty()) {
            return false;
        }
        for (ProfilerFeature profilerFeature : this.activated) {
            if (profilerFeature.currentSettingsValid()) continue;
            return false;
        }
        return true;
    }

    ProfilingSettings getSettings() {
        assert (SwingUtilities.isEventDispatchThread());
        this.session.persistStorage(false);
        if (this.activated.isEmpty()) {
            return null;
        }
        ProfilingSettings profilingSettings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        for (ProfilerFeature profilerFeature : this.activated) {
            profilerFeature.configureSettings(profilingSettings);
        }
        profilingSettings.setUseProfilingPoints(this.ppoints);
        return profilingSettings;
    }

    void sessionFinished() {
        UIUtils.runInEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (ProfilerFeature profilerFeature : ProfilerFeatures.this.getActivated()) {
                    profilerFeature.deactivatedInSession();
                }
            }
        });
    }

    void addListener(Listener listener) {
        assert (SwingUtilities.isEventDispatchThread());
        this.listeners.add(listener);
    }

    void removeListener(Listener listener) {
        assert (SwingUtilities.isEventDispatchThread());
        this.listeners.remove(listener);
    }

    private void fireFeaturesChanged(ProfilerFeature profilerFeature) {
        boolean bl = this.settingsValid();
        for (Listener listener : this.listeners) {
            listener.featuresChanged(profilerFeature);
            listener.settingsChanged(bl);
        }
    }

    private void fireSettingsChanged() {
        boolean bl = this.settingsValid();
        for (Listener listener : this.listeners) {
            listener.settingsChanged(bl);
        }
    }

    static abstract class Listener {
        Listener() {
        }

        abstract void featuresChanged(ProfilerFeature var1);

        abstract void settingsChanged(boolean var1);
    }
}

