/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.snaptracer.impl.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public final class ColorIcon
implements Icon {
    private static int WIDTH = 8;
    private static int HEIGHT = 8;
    private static Color BACKGROUND_COLOR = Color.WHITE;
    private static Color FOREGROUND_COLOR = Color.BLACK;
    public static final ColorIcon BOTTOM_SHADOW = new ColorIcon(null, true);
    private final boolean shadow;
    private final Color color;
    private static final Map<Color, ColorIcon> icons = new HashMap<Color, ColorIcon>();

    private ColorIcon(Color color) {
        this(color, false);
    }

    private ColorIcon(Color color, boolean bl) {
        this.color = color;
        this.shadow = bl;
    }

    public static void setup(int n, int n2, Color color, Color color2) {
        WIDTH = n;
        HEIGHT = n2;
        BACKGROUND_COLOR = color2;
        FOREGROUND_COLOR = color;
        icons.clear();
    }

    public static ColorIcon fromColor(Color color) {
        ColorIcon colorIcon = icons.get(color);
        if (colorIcon == null) {
            colorIcon = new ColorIcon(color);
            icons.put(color, colorIcon);
        }
        return colorIcon;
    }

    @Override
    public int getIconWidth() {
        return WIDTH;
    }

    @Override
    public int getIconHeight() {
        return HEIGHT;
    }

    @Override
    public void paintIcon(Component component, Graphics graphics, int n, int n2) {
        if (this.shadow) {
            graphics.setColor(BACKGROUND_COLOR);
            graphics.drawLine(n, n2 + HEIGHT + 1, n + WIDTH - 1, n2 + HEIGHT + 1);
        } else {
            graphics.setColor(this.color);
            graphics.fillRect(n, n2, WIDTH, HEIGHT);
            graphics.setColor(FOREGROUND_COLOR);
            graphics.drawRect(n, n2, WIDTH - 1, HEIGHT - 1);
        }
    }
}

