/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.lib.profiler.heap.GCRoot;
import org.netbeans.lib.profiler.heap.HprofGCRoot;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.JavaFrameHprofGCRoot;
import org.netbeans.lib.profiler.heap.TagBounds;
import org.netbeans.lib.profiler.heap.ThreadObjectGCRoot;
import org.netbeans.lib.profiler.heap.ThreadObjectHprofGCRoot;

class HprofGCRoots {
    final HprofHeap heap;
    private ThreadObjectHprofGCRoot lastThreadObjGC;
    private final Object lastThreadObjGCLock = new Object();
    private Map gcRoots;
    private final Object gcRootLock = new Object();
    private List gcRootsList;

    HprofGCRoots(HprofHeap hprofHeap) {
        this.heap = hprofHeap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getGCRoots() {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.gcRoots = this.computeGCRootsFor(this.heap.getHeapTagBound(255));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(1)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(2)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(3)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(4)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(5)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(6)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(7)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(8)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(137)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(138)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(139)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(140)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(141)));
                this.gcRoots.putAll(this.computeGCRootsFor(this.heap.getHeapTagBound(142)));
                ArrayList arrayList = new ArrayList(this.gcRoots.values());
                Collections.sort(arrayList, new Comparator(){

                    public int compare(Object object, Object object2) {
                        HprofGCRoot hprofGCRoot = (HprofGCRoot)object;
                        HprofGCRoot hprofGCRoot2 = (HprofGCRoot)object2;
                        int n = hprofGCRoot.getKind().compareTo(hprofGCRoot2.getKind());
                        if (n != 0) {
                            return n;
                        }
                        return Long.compare(hprofGCRoot.getInstanceId(), hprofGCRoot2.getInstanceId());
                    }
                });
                this.gcRootsList = Collections.unmodifiableList(arrayList);
            }
            return this.gcRootsList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GCRoot getGCRoot(Long l) {
        Object object = this.gcRootLock;
        synchronized (object) {
            if (this.gcRoots == null) {
                this.heap.getGCRoots();
            }
            return (GCRoot)this.gcRoots.get(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ThreadObjectGCRoot getThreadGCRoot(int n) {
        Object object = this.lastThreadObjGCLock;
        synchronized (object) {
            if (this.lastThreadObjGC != null && n == this.lastThreadObjGC.getThreadSerialNumber()) {
                return this.lastThreadObjGC;
            }
            for (Object e : this.heap.getGCRoots()) {
                ThreadObjectHprofGCRoot threadObjectHprofGCRoot;
                if (!(e instanceof ThreadObjectHprofGCRoot) || n != (threadObjectHprofGCRoot = (ThreadObjectHprofGCRoot)e).getThreadSerialNumber()) continue;
                this.lastThreadObjGC = threadObjectHprofGCRoot;
                return threadObjectHprofGCRoot;
            }
            return null;
        }
    }

    private Map computeGCRootsFor(TagBounds tagBounds) {
        HashMap<Long, ThreadObjectHprofGCRoot> hashMap = new HashMap<Long, ThreadObjectHprofGCRoot>();
        if (tagBounds != null) {
            int n = tagBounds.tag;
            long[] lArray = new long[]{tagBounds.startOffset};
            while (lArray[0] < tagBounds.endOffset) {
                long l = lArray[0];
                if (this.heap.readDumpTag(lArray) != n) continue;
                HprofGCRoot hprofGCRoot = n == 8 ? new ThreadObjectHprofGCRoot(this, l) : (n == 3 ? new JavaFrameHprofGCRoot(this, l) : new HprofGCRoot(this, l));
                hashMap.put(hprofGCRoot.getInstanceId(), (ThreadObjectHprofGCRoot)hprofGCRoot);
            }
        }
        return hashMap;
    }
}

