/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.marker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.marker.Mark;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.results.cpu.marking.MarkMapping;

public class ClassMarker
implements Marker {
    private static Logger LOGGER = Logger.getLogger(ClassMarker.class.getName());
    private Map markMap = new HashMap();

    @Override
    public MarkMapping[] getMappings() {
        ArrayList<MarkMapping> arrayList = new ArrayList<MarkMapping>();
        for (String string : this.markMap.keySet()) {
            ClientUtils.SourceCodeSelection sourceCodeSelection = new ClientUtils.SourceCodeSelection(string, "*", "");
            sourceCodeSelection.setMarkerMethod(true);
            arrayList.add(new MarkMapping(sourceCodeSelection, (Mark)this.markMap.get(string)));
        }
        return arrayList.toArray(new MarkMapping[0]);
    }

    @Override
    public Mark[] getMarks() {
        return new HashSet(this.markMap.values()).toArray(new Mark[0]);
    }

    public void addClassMark(String string, Mark mark) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Marking class " + string + " with " + mark.getId());
        }
        this.markMap.put(string, mark);
    }

    public void removeClassMark(String string) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking class " + string);
        }
        this.markMap.remove(string);
    }

    public void resetClassMarks() {
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Unmarking all classes");
        }
        this.markMap.clear();
    }
}

