/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.locks;

import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import org.netbeans.lib.profiler.results.locks.LockCCTNode;
import org.netbeans.lib.profiler.results.locks.MonitorInfo;

class MonitorCCTNode
extends LockCCTNode {
    private static final String WAIT_THREADS_LBL;
    private static final String WAIT_THREADS_OWNER_LBL;
    private static final String OWNER_THREADS_LBL;
    private static final String OWNER_THREADS_WAIT_LBL;
    private final MonitorInfo monitor;
    private final List<MonitorInfo.ThreadDetail> waitThreads;
    private final List<MonitorInfo.ThreadDetail> ownerThreads;
    private ThreadsCCTNode waitNode;
    private long allTime;
    private long allCount;

    MonitorCCTNode(LockCCTNode lockCCTNode, MonitorInfo monitorInfo, List<List<MonitorInfo.ThreadDetail>> list) {
        super(lockCCTNode);
        assert (list.size() == 2);
        this.monitor = monitorInfo;
        this.waitThreads = list.get(0);
        this.ownerThreads = list.get(1);
    }

    @Override
    public String getNodeName() {
        return this.monitor.getName();
    }

    @Override
    public long getTime() {
        if (this.allTime == 0L) {
            this.summarize();
        }
        return this.allTime;
    }

    @Override
    public long getWaits() {
        if (this.allCount == 0L) {
            this.summarize();
        }
        return this.allCount;
    }

    @Override
    public boolean isMonitorNode() {
        return true;
    }

    public int hashCode() {
        return this.monitor.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof MonitorCCTNode) {
            return this.monitor.equals(((MonitorCCTNode)object).monitor);
        }
        return false;
    }

    private void summarize() {
        this.getChildren();
        if (this.waitNode != null) {
            this.allTime = this.waitNode.getTime();
            this.allCount = this.waitNode.getWaits();
        }
    }

    @Override
    void computeChildren() {
        super.computeChildren();
        if (!this.waitThreads.isEmpty()) {
            this.waitNode = new ThreadsCCTNode(this, WAIT_THREADS_LBL, WAIT_THREADS_OWNER_LBL, this.waitThreads);
            this.addChild(this.waitNode);
        }
        if (!this.ownerThreads.isEmpty()) {
            this.addChild(new ThreadsCCTNode(this, OWNER_THREADS_LBL, OWNER_THREADS_WAIT_LBL, this.ownerThreads));
        }
    }

    static {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org.netbeans.lib.profiler.results.locks.Bundle");
        WAIT_THREADS_LBL = resourceBundle.getString("MonitorCCTNode_WaitThreads");
        WAIT_THREADS_OWNER_LBL = resourceBundle.getString("MonitorCCTNode_WaitThreadsOwner");
        OWNER_THREADS_LBL = resourceBundle.getString("MonitorCCTNode_OwnerThreads");
        OWNER_THREADS_WAIT_LBL = resourceBundle.getString("MonitorCCTNode_OwnerThreadsWait");
    }

    static class ThreadDetailLockCCTNode
    extends LockCCTNode {
        private final MonitorInfo.ThreadDetail threadDetail;
        private final String threadNameFormat;
        private final boolean useFormat;

        ThreadDetailLockCCTNode(LockCCTNode lockCCTNode, String string, boolean bl, MonitorInfo.ThreadDetail threadDetail) {
            super(lockCCTNode);
            this.threadDetail = threadDetail;
            this.threadNameFormat = string;
            this.useFormat = bl;
        }

        ThreadDetailLockCCTNode(LockCCTNode lockCCTNode, String string, MonitorInfo.ThreadDetail threadDetail) {
            this(lockCCTNode, string, true, threadDetail);
        }

        @Override
        public boolean isThreadLockNode() {
            return true;
        }

        @Override
        public String getNodeName() {
            String string = this.threadDetail.threadInfo.getName();
            if (this.threadNameFormat != null && this.useFormat) {
                string = MessageFormat.format(this.threadNameFormat, string);
            }
            return string;
        }

        @Override
        public long getTime() {
            return this.threadDetail.waitTime;
        }

        @Override
        public long getWaits() {
            return this.threadDetail.count;
        }

        public int hashCode() {
            return this.threadDetail.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ThreadDetailLockCCTNode) {
                ThreadDetailLockCCTNode threadDetailLockCCTNode = (ThreadDetailLockCCTNode)object;
                return this.threadDetail.threadInfo.equals(threadDetailLockCCTNode.threadDetail.threadInfo) && this.getParent().equals(threadDetailLockCCTNode.getParent());
            }
            return false;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail threadDetail : this.threadDetail.cloneThreadDetails()) {
                this.addChild(new ThreadDetailLockCCTNode(this, this.threadNameFormat, threadDetail));
            }
        }
    }

    static class ThreadsCCTNode
    extends LockCCTNode {
        private final List<MonitorInfo.ThreadDetail> threads;
        private final String name;
        private final String threadNameFormat;
        private long allTime;
        private long allCount;

        ThreadsCCTNode(MonitorCCTNode monitorCCTNode, String string, String string2, List<MonitorInfo.ThreadDetail> list) {
            super(monitorCCTNode);
            this.name = string;
            this.threadNameFormat = string2;
            this.threads = list;
        }

        @Override
        public String getNodeName() {
            return this.name;
        }

        @Override
        public long getTime() {
            if (this.allTime == 0L) {
                this.summarize();
            }
            return this.allTime;
        }

        @Override
        public long getWaits() {
            if (this.allCount == 0L) {
                this.summarize();
            }
            return this.allCount;
        }

        @Override
        void computeChildren() {
            super.computeChildren();
            for (MonitorInfo.ThreadDetail threadDetail : this.threads) {
                this.addChild(new ThreadDetailLockCCTNode(this, this.threadNameFormat, false, threadDetail));
            }
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (object instanceof ThreadsCCTNode) {
                ThreadsCCTNode threadsCCTNode = (ThreadsCCTNode)object;
                return this.name.equals(threadsCCTNode.name) && this.getParent().equals(threadsCCTNode.getParent());
            }
            return false;
        }

        private void summarize() {
            for (MonitorInfo.ThreadDetail threadDetail : this.threads) {
                this.allTime += threadDetail.waitTime;
                this.allCount += threadDetail.count;
            }
        }
    }
}

