/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.lookup.implspi.SharedClassObjectBridge;

public abstract class SharedClassObject
implements Externalizable {
    private static final long serialVersionUID = 4527891234589143259L;
    private static final Object PROP_SUPPORT;
    private static final Map<Class, DataEntry> values;
    private static final Map<String, Integer> instancesBeingCreated;
    private static final Set<String> alreadyWarnedAboutDupes;
    private static final Logger err;
    private final DataEntry dataEntry;
    private Object lock;
    private final SharedClassObject first;
    private Throwable firstTrace = null;
    private boolean systemOption = false;
    private boolean waitingOnSystemOption = false;
    private IllegalStateException prematureSystemOptionMutation = null;
    private boolean inReadExternal = false;
    private boolean addNotifySuper;
    private boolean removeNotifySuper;
    private boolean initializeSuper;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SharedClassObject() {
        Object object = this.getLock();
        synchronized (object) {
            DataEntry dataEntry = values.get(this.getClass());
            if (dataEntry == null) {
                dataEntry = new DataEntry();
                values.put(this.getClass(), dataEntry);
            }
            this.dataEntry = dataEntry;
            dataEntry.increase();
            this.first = dataEntry.first(this);
        }
        if (this.first != null) {
            if (this.first == this) {
                if (err.isLoggable(Level.FINE)) {
                    object = new Throwable("First instance created here");
                    ((Throwable)object).fillInStackTrace();
                    this.first.firstTrace = object;
                }
            } else {
                boolean bl;
                object = this.getClass().getName();
                Object object2 = instancesBeingCreated;
                synchronized (object2) {
                    bl = instancesBeingCreated.containsKey(object);
                }
                if (!bl && !alreadyWarnedAboutDupes.contains(object)) {
                    alreadyWarnedAboutDupes.add((String)object);
                    object2 = new IllegalStateException("Warning: multiple instances of shared class " + (String)object + " created.");
                    if (this.first.firstTrace != null) {
                        err.log(Level.WARNING, "First stack trace", this.first.firstTrace);
                    } else {
                        err.warning("(Run with -J-Dorg.openide.util.SharedClassObject.level=0 for more details.)");
                    }
                    err.log(Level.WARNING, null, (Throwable)object2);
                }
            }
        }
    }

    protected final void finalize() throws Throwable {
        this.referenceLost();
    }

    protected boolean clearSharedData() {
        return true;
    }

    public final boolean equals(Object object) {
        return object instanceof SharedClassObject && this.getClass().equals(object.getClass());
    }

    public final int hashCode() {
        return this.getClass().hashCode();
    }

    protected final Object getLock() {
        if (this.lock == null) {
            this.lock = this.getClass().getName().intern();
        }
        return this.lock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void referenceLost() {
        Object object = this.getLock();
        synchronized (object) {
            if ((this.dataEntry == null || this.dataEntry.decrease() == 0) && this.clearSharedData()) {
                values.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object putProperty(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("Tried to pass null key (value=" + object2 + ") to putProperty");
        }
        Object object3 = this.getLock();
        synchronized (object3) {
            if (this.waitingOnSystemOption && object != PROP_SUPPORT && this.prematureSystemOptionMutation == null && !this.dataEntry.isInInitialize() && !this.inReadExternal) {
                this.prematureSystemOptionMutation = new IllegalStateException("...setting property here...");
            }
            return this.dataEntry.getMap(this).put(object, object2);
        }
    }

    protected final Object putProperty(String string, Object object, boolean bl) {
        Object object2 = this.putProperty(string, object);
        if (bl) {
            this.firePropertyChange(string, object2, object);
        }
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final Object getProperty(Object object) {
        Object object2 = this.getLock();
        synchronized (object2) {
            if ("org.openide.util.SharedClassObject.initialize".equals(object)) {
                return this.dataEntry.isInInitialize() ? Boolean.TRUE : null;
            }
            return this.dataEntry.get(this, object);
        }
    }

    protected void initialize() {
        this.initializeSuper = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (propertyChangeSupport == null) {
                propertyChangeSupport = new PropertyChangeSupport(this);
                this.putProperty(PROP_SUPPORT, propertyChangeSupport);
            }
            bl = !propertyChangeSupport.hasListeners(null);
            propertyChangeSupport.addPropertyChangeListener(propertyChangeListener);
        }
        if (bl) {
            this.addNotifySuper = false;
            this.addNotify();
            if (!this.addNotifySuper) {
                object = "You must call super.addNotify() from " + this.getClass().getName() + ".addNotify()";
                err.warning((String)object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        boolean bl;
        Object object = this.getLock();
        synchronized (object) {
            PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
            if (propertyChangeSupport == null) {
                return;
            }
            boolean bl2 = propertyChangeSupport.hasListeners(null);
            propertyChangeSupport.removePropertyChangeListener(propertyChangeListener);
            bl = bl2 && !propertyChangeSupport.hasListeners(null);
        }
        if (bl) {
            this.putProperty(PROP_SUPPORT, null);
            this.removeNotifySuper = false;
            this.removeNotify();
            if (!this.removeNotifySuper) {
                object = "You must call super.removeNotify() from " + this.getClass().getName() + ".removeNotify()";
                err.warning((String)object);
            }
        }
    }

    protected void addNotify() {
        this.addNotifySuper = true;
    }

    protected void removeNotify() {
        this.removeNotifySuper = true;
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        PropertyChangeSupport propertyChangeSupport = (PropertyChangeSupport)this.getProperty(PROP_SUPPORT);
        if (propertyChangeSupport != null) {
            propertyChangeSupport.firePropertyChange(string, object, object2);
        }
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    protected Object writeReplace() {
        return new WriteReplace(this);
    }

    public static <T extends SharedClassObject> T findObject(Class<T> clazz) {
        return SharedClassObject.findObject(clazz, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends SharedClassObject> T findObject(Class<T> clazz, boolean bl) {
        String string = clazz.getName().intern();
        synchronized (string) {
            Object object;
            DataEntry dataEntry = values.get(clazz);
            SharedClassObject sharedClassObject = dataEntry == null ? null : dataEntry.get();
            boolean bl2 = false;
            if (sharedClassObject == null && bl) {
                object = new SetAccessibleAction(clazz);
                try {
                    sharedClassObject = AccessController.doPrivileged(object);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException(exception.toString());
                    illegalArgumentException.initCause(exception);
                    throw illegalArgumentException;
                }
                bl2 = true;
            }
            if ((dataEntry = values.get(clazz)) != null) {
                object = dataEntry.get();
                if (sharedClassObject != null && sharedClassObject != object) {
                    if (object == null && bl) {
                        throw new IllegalStateException("Inconsistent state: " + clazz);
                    }
                    return (T)((SharedClassObject)clazz.cast(object));
                }
            }
            if (bl2 && sharedClassObject.isSystemOption() && (object = Lookup.getDefault().lookup(new Lookup.Template(clazz))).allInstances().isEmpty()) {
                sharedClassObject.waitingOnSystemOption = true;
                SharedClassObject sharedClassObject2 = sharedClassObject;
                IllegalStateException illegalStateException = new IllegalStateException("Making a SystemOption here that is not in lookup...");
                class SOLoader
                implements LookupListener {
                    final /* synthetic */ Lookup.Result val$r;
                    final /* synthetic */ SharedClassObject val$_obj;
                    final /* synthetic */ IllegalStateException val$start;

                    SOLoader() {
                        this.val$r = result;
                        this.val$_obj = sharedClassObject;
                        this.val$start = illegalStateException;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void resultChanged(LookupEvent lookupEvent) {
                        if (!this.val$r.allInstances().isEmpty()) {
                            this.val$r.removeLookupListener((LookupListener)this);
                            Object object = this.val$_obj.getLock();
                            synchronized (object) {
                                this.val$_obj.waitingOnSystemOption = false;
                                if (this.val$_obj.prematureSystemOptionMutation != null) {
                                    SharedClassObject.warn(this.val$start);
                                    SharedClassObject.warn(this.val$_obj.prematureSystemOptionMutation);
                                    SharedClassObject.warn(new IllegalStateException("...and maybe getting clobbered here, see #17711."));
                                    this.val$_obj.prematureSystemOptionMutation = null;
                                }
                            }
                        }
                    }
                }
                object.addLookupListener((LookupListener)new SOLoader());
            }
            if (sharedClassObject == null && bl) {
                throw new IllegalStateException("Inconsistent state: " + clazz);
            }
            return (T)((SharedClassObject)clazz.cast(sharedClassObject));
        }
    }

    private boolean isSystemOption() {
        for (Class<?> clazz = this.getClass(); clazz != SharedClassObject.class; clazz = clazz.getSuperclass()) {
            if (!"org.openide.options.SystemOption".equals(clazz.getName())) continue;
            return true;
        }
        return false;
    }

    private static void warn(Throwable throwable) {
        err.log(Level.WARNING, null, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SharedClassObject createInstancePrivileged(Class<? extends SharedClassObject> clazz) throws Exception {
        Object object;
        Constructor<? extends SharedClassObject> constructor = clazz.getDeclaredConstructor(new Class[0]);
        constructor.setAccessible(true);
        String string = clazz.getName();
        assert (instancesBeingCreated != null);
        Object object2 = instancesBeingCreated;
        synchronized (object2) {
            object = instancesBeingCreated.get(string);
            instancesBeingCreated.put(string, object == null ? new Integer(1) : new Integer((Integer)object + 1));
        }
        try {
            object2 = constructor.newInstance(new Object[0]);
            return object2;
        }
        finally {
            object = instancesBeingCreated;
            synchronized (object) {
                Integer n = instancesBeingCreated.get(string);
                if (n == 1) {
                    instancesBeingCreated.remove(string);
                } else {
                    instancesBeingCreated.put(string, new Integer(n - 1));
                }
            }
            constructor.setAccessible(false);
        }
    }

    protected void reset() {
    }

    static {
        SharedClassObjectBridge.setInstance((SharedClassObjectBridge)new SharedClassObjectBridge(){

            protected <T> T findObject(Class<T> clazz) throws InstantiationException, IllegalAccessException {
                if (SharedClassObject.class.isAssignableFrom(clazz)) {
                    return clazz.cast(SharedClassObject.findObject(clazz.asSubclass(SharedClassObject.class), true));
                }
                return null;
            }
        });
        PROP_SUPPORT = new Object();
        values = new WeakHashMap<Class, DataEntry>(37);
        instancesBeingCreated = new HashMap<String, Integer>(7);
        alreadyWarnedAboutDupes = new HashSet<String>();
        err = Logger.getLogger("org.openide.util.SharedClassObject");
    }

    static final class SetAccessibleAction
    implements PrivilegedExceptionAction<SharedClassObject> {
        Class<? extends SharedClassObject> klass;

        SetAccessibleAction(Class<? extends SharedClassObject> clazz) {
            this.klass = clazz;
        }

        @Override
        public SharedClassObject run() throws Exception {
            return SharedClassObject.createInstancePrivileged(this.klass);
        }
    }

    static final class DataEntry {
        private HashMap<Object, Object> map;
        private int count = 0;
        private WeakReference<SharedClassObject> ref = new WeakReference<Object>(null);
        private boolean initialized = false;
        private boolean initializeInProgress = false;
        private Throwable invalid = null;

        DataEntry() {
        }

        public String toString() {
            return "SCO.DataEntry[ref=" + this.ref.get() + ",count=" + this.count + ",initialized=" + this.initialized + ",invalid=" + this.invalid + ",map=" + this.map + "]";
        }

        boolean isInInitialize() {
            return this.initializeInProgress;
        }

        Map<Object, Object> getMap(SharedClassObject sharedClassObject) {
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
            }
            if (!this.initialized) {
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
            }
            return this.map;
        }

        Object get(SharedClassObject sharedClassObject, Object object) {
            Object object2;
            this.ensureValid(sharedClassObject);
            if (this.map == null) {
                this.map = new HashMap();
                object2 = null;
            } else {
                object2 = this.map.get(object);
            }
            if (object2 == null && !this.initialized) {
                if (object == PROP_SUPPORT) {
                    return null;
                }
                this.initialized = true;
                this.tryToInitialize(sharedClassObject);
                object2 = this.map.get(object);
            }
            return object2;
        }

        Map getMap() {
            this.ensureValid(this.get());
            if (this.map == null) {
                this.map = new HashMap();
            }
            return this.map;
        }

        private void ensureValid(SharedClassObject sharedClassObject) throws IllegalStateException {
            if (this.invalid != null) {
                String string = sharedClassObject != null ? sharedClassObject.toString() : "<unknown object>";
                throw (IllegalStateException)new IllegalStateException(string).initCause(this.invalid);
            }
        }

        private void tryToInitialize(SharedClassObject sharedClassObject) throws IllegalStateException {
            this.initializeInProgress = true;
            sharedClassObject.initializeSuper = false;
            try {
                sharedClassObject.initialize();
            }
            catch (Exception exception) {
                this.invalid = exception;
                throw (IllegalStateException)new IllegalStateException(this.invalid.toString() + " from " + sharedClassObject).initCause(this.invalid);
            }
            catch (LinkageError linkageError) {
                this.invalid = linkageError;
                throw (IllegalStateException)new IllegalStateException(this.invalid.toString() + " from " + sharedClassObject).initCause(this.invalid);
            }
            finally {
                this.initializeInProgress = false;
            }
            if (!sharedClassObject.initializeSuper) {
                String string = "You must call super.initialize() from " + sharedClassObject.getClass().getName() + ".initialize()";
                err.warning(string);
            }
        }

        int increase() {
            return ++this.count;
        }

        int decrease() {
            return --this.count;
        }

        SharedClassObject first(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = (SharedClassObject)this.ref.get();
            if (sharedClassObject2 == null) {
                this.ref = new WeakReference<SharedClassObject>(sharedClassObject);
                return sharedClassObject;
            }
            return sharedClassObject2;
        }

        public SharedClassObject get() {
            return (SharedClassObject)this.ref.get();
        }

        public void reset(SharedClassObject sharedClassObject) {
            SharedClassObject sharedClassObject2 = this.get();
            if (sharedClassObject2 != null && sharedClassObject2 != sharedClassObject) {
                return;
            }
            this.invalid = null;
            this.getMap().clear();
            this.initialized = true;
            this.tryToInitialize(sharedClassObject);
        }
    }

    static final class WriteReplace
    implements Serializable {
        static final long serialVersionUID = 1327893248974327640L;
        private Class<? extends SharedClassObject> clazz;
        private String name;
        private transient SharedClassObject object;

        public WriteReplace(SharedClassObject sharedClassObject) {
            this.object = sharedClassObject;
            this.clazz = sharedClassObject.getClass();
            this.name = this.clazz.getName();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            this.object.writeExternal(objectOutputStream);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            objectInputStream.defaultReadObject();
            if (this.clazz == null) {
                if (this.name != null) {
                    throw new ClassNotFoundException(this.name);
                }
                throw new ClassNotFoundException();
            }
            this.object = SharedClassObject.findObject(this.clazz, true);
            this.object.inReadExternal = true;
            try {
                this.object.readExternal(objectInputStream);
            }
            finally {
                this.object.inReadExternal = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object readResolve() throws ObjectStreamException {
            SharedClassObject sharedClassObject = this.object;
            Method method = WriteReplace.findReadResolveMethod(this.object.getClass());
            if (method != null) {
                try {
                    method.setAccessible(true);
                    Object object = method.invoke((Object)this.object, new Object[0]);
                    return object;
                }
                catch (Exception exception) {
                    String string = "Skipping " + this.object.getClass() + " resolution:";
                    err.log(Level.WARNING, string, exception);
                }
                finally {
                    method.setAccessible(false);
                }
            }
            return sharedClassObject;
        }

        private static Method findReadResolveMethod(Class clazz) {
            Method method = null;
            for (Class clazz2 = clazz; clazz2 != null; clazz2 = clazz2.getSuperclass()) {
                try {
                    method = WriteReplace.accept(clazz2.getDeclaredMethod("readResolve", new Class[0]));
                    if (method == null) continue;
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            return method;
        }

        private static Method accept(Method method) {
            Class<?>[] classArray;
            if (method != null && (classArray = method.getExceptionTypes()).length == 1 && ObjectStreamException.class.equals(classArray[0]) && Object.class.equals(method.getReturnType())) {
                return method;
            }
            return null;
        }
    }
}

