/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.attach;

import com.sun.tools.attach.VirtualMachine;
import com.sun.tools.visualvm.application.Application;
import com.sun.tools.visualvm.attach.HeapHistogramImpl;
import com.sun.tools.visualvm.tools.attach.AttachModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.tools.attach.HotSpotVirtualMachine;

class AttachModelImpl
extends AttachModel {
    static final String LIVE_OBJECTS_OPTION = "-live";
    static final String ALL_OBJECTS_OPTION = "-all";
    static final Logger LOGGER = Logger.getLogger(AttachModelImpl.class.getName());
    String pid;
    HotSpotVirtualMachine vm;

    AttachModelImpl(Application app) {
        this.pid = Integer.toString(app.getPid());
    }

    public synchronized Properties getSystemProperties() {
        try {
            return this.getVirtualMachine().getSystemProperties();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "getSystemProperties", ex);
            return null;
        }
    }

    public synchronized boolean takeHeapDump(String fileName) {
        try {
            InputStream in = this.getVirtualMachine().dumpHeap(fileName, LIVE_OBJECTS_OPTION);
            String out = this.readToEOF(in);
            if (out.length() > 0) {
                LOGGER.log(Level.INFO, "takeHeapDump", out);
            }
            return true;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapDump", ex);
            return false;
        }
    }

    public synchronized String takeThreadDump() {
        try {
            InputStream in = this.getVirtualMachine().remoteDataDump("-l");
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeThreadDump", ex);
            return null;
        }
    }

    public synchronized String printFlag(String name) {
        try {
            InputStream in = this.getVirtualMachine().printFlag(name);
            return this.readToEOF(in);
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "printFlag", ex);
            return null;
        }
    }

    public synchronized void setFlag(String name, String value) {
        try {
            InputStream in = this.getVirtualMachine().setFlag(name, value);
            String out = this.readToEOF(in);
            if (out.length() > 0) {
                LOGGER.log(Level.INFO, "setFlag", out);
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "setFlag", ex);
        }
    }

    public synchronized HeapHistogramImpl takeHeapHistogram() {
        try {
            InputStream in = this.getVirtualMachine().heapHisto(ALL_OBJECTS_OPTION);
            HeapHistogramImpl h = new HeapHistogramImpl(in);
            in.close();
            return h;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "takeHeapHistogram", ex);
            return null;
        }
    }

    HotSpotVirtualMachine getVirtualMachine() throws IOException {
        if (this.vm == null) {
            try {
                this.vm = (HotSpotVirtualMachine)VirtualMachine.attach(this.pid);
            }
            catch (Exception x) {
                throw new IOException(x.getLocalizedMessage(), x);
            }
        }
        return this.vm;
    }

    private String readToEOF(InputStream in) throws IOException {
        int n;
        StringBuffer buffer = new StringBuffer(1024);
        byte[] b = new byte[256];
        do {
            if ((n = in.read(b)) <= 0) continue;
            String s = new String(b, 0, n, "UTF-8");
            buffer.append(s);
        } while (n > 0);
        in.close();
        return buffer.toString();
    }

    protected void finalize() throws Throwable {
        if (this.vm != null) {
            this.vm.detach();
        }
        super.finalize();
    }
}

