/*
 * Decompiled with CFR 0.152.
 */
package org.openide.windows;

import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.windows.CloneableOpenSupport;

public abstract class CloneableOpenSupportRedirector {
    private static final Lookup.Result<CloneableOpenSupportRedirector> lkp = Lookup.getDefault().lookup(new Lookup.Template(CloneableOpenSupportRedirector.class));
    private static final AtomicReference<Collection<? extends CloneableOpenSupportRedirector>> redirectors = new AtomicReference();
    private static final LookupListener listener = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            redirectors.set(lkp.allInstances());
        }
    };

    protected abstract CloneableOpenSupport redirect(CloneableOpenSupport.Env var1);

    protected abstract void opened(CloneableOpenSupport.Env var1);

    protected abstract void closed(CloneableOpenSupport.Env var1);

    static CloneableOpenSupport findRedirect(CloneableOpenSupport cloneableOpenSupport) {
        CloneableOpenSupport.Env env = cloneableOpenSupport.env;
        Collection<? extends CloneableOpenSupportRedirector> collection = redirectors.get();
        if (collection != null) {
            for (CloneableOpenSupportRedirector cloneableOpenSupportRedirector : collection) {
                CloneableOpenSupport cloneableOpenSupport2 = cloneableOpenSupportRedirector.redirect(env);
                if (cloneableOpenSupport2 == null || cloneableOpenSupport2 == cloneableOpenSupport) continue;
                return cloneableOpenSupport2;
            }
        }
        return null;
    }

    static void notifyOpened(CloneableOpenSupport cloneableOpenSupport) {
        CloneableOpenSupport.Env env = cloneableOpenSupport.env;
        Collection<? extends CloneableOpenSupportRedirector> collection = redirectors.get();
        if (collection != null) {
            for (CloneableOpenSupportRedirector cloneableOpenSupportRedirector : collection) {
                cloneableOpenSupportRedirector.opened(env);
            }
        }
    }

    static void notifyClosed(CloneableOpenSupport cloneableOpenSupport) {
        CloneableOpenSupport.Env env = cloneableOpenSupport.env;
        Collection<? extends CloneableOpenSupportRedirector> collection = redirectors.get();
        if (collection != null) {
            for (CloneableOpenSupportRedirector cloneableOpenSupportRedirector : collection) {
                cloneableOpenSupportRedirector.closed(env);
            }
        }
    }

    static {
        lkp.addLookupListener(listener);
        listener.resultChanged(null);
    }
}

