/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Color;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class CellContext
implements Serializable {
    protected static Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    private static final Border SAFE_NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    protected transient JComponent component;
    protected transient Object value;
    protected transient int row;
    protected transient int column;
    protected transient boolean selected;
    protected transient boolean focused;
    protected transient boolean expanded;
    protected transient boolean leaf;
    protected transient boolean dropOn;

    private static Border getNoFocusBorder() {
        if (System.getSecurityManager() != null) {
            return SAFE_NO_FOCUS_BORDER;
        }
        return noFocusBorder;
    }

    protected void installState(Object value, int row, int column, boolean selected, boolean focused, boolean expanded, boolean leaf) {
        this.value = value;
        this.row = row;
        this.column = column;
        this.selected = selected;
        this.focused = focused;
        this.expanded = expanded;
        this.leaf = leaf;
    }

    public Object replaceValue(Object value) {
        Object old = this.getValue();
        this.value = value;
        return old;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public Object getValue() {
        return this.value;
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.column;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public boolean isLeaf() {
        return this.leaf;
    }

    public boolean isEditable() {
        return false;
    }

    public Icon getIcon() {
        return null;
    }

    protected boolean isDropOn() {
        return this.dropOn;
    }

    protected Color getForeground() {
        if (this.isDropOn()) {
            return this.getSelectionForeground();
        }
        return this.getComponent() != null ? this.getComponent().getForeground() : null;
    }

    protected Color getBackground() {
        if (this.isDropOn()) {
            return this.getSelectionBackground();
        }
        return this.getComponent() != null ? this.getComponent().getBackground() : null;
    }

    protected Color getSelectionBackground() {
        return null;
    }

    protected Color getSelectionForeground() {
        return null;
    }

    protected Border getFocusBorder() {
        Border border = null;
        if (this.isSelected()) {
            border = UIManager.getBorder(this.getUIKey("focusSelectedCellHighlightBorder"));
        }
        if (border == null) {
            border = UIManager.getBorder(this.getUIKey("focusCellHighlightBorder"));
        }
        return border;
    }

    protected Border getBorder() {
        if (this.isFocused()) {
            return this.getFocusBorder();
        }
        Border border = UIManager.getBorder(this.getUIKey("cellNoFocusBorder"));
        return border != null ? border : CellContext.getNoFocusBorder();
    }

    protected Color getFocusForeground() {
        return UIManager.getColor(this.getUIKey("focusCellForeground"));
    }

    protected Color getFocusBackground() {
        return UIManager.getColor(this.getUIKey("focusCellBackground"));
    }

    protected Color getDropCellForeground() {
        return UIManager.getColor(this.getUIKey("dropCellForeground"));
    }

    protected Color getDropCellBackground() {
        return UIManager.getColor(this.getUIKey("dropCellBackground"));
    }

    protected String getUIKey(String key) {
        return this.getUIPrefix() + key;
    }

    protected String getUIPrefix() {
        return "";
    }
}

