/*
 * Decompiled with CFR 0.152.
 */
package esmska.update;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingWorker;
import org.apache.commons.io.IOUtils;

public class HttpDownloader
extends SwingWorker<Object, Void> {
    private static final Logger logger = Logger.getLogger(HttpDownloader.class.getName());
    private String url;
    private boolean binary;
    private String textContent;
    private byte[] binaryContent;
    private boolean finishedOk;

    public HttpDownloader(String url, boolean binary) {
        this.url = url;
        this.binary = binary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected Object doInBackground() {
        Object object;
        InputStream in = null;
        try {
            URL link = new URL(this.url);
            HttpURLConnection con = (HttpURLConnection)link.openConnection();
            if (con.getResponseCode() != 200) {
                throw new IOException("Downloading of file '" + this.url + "' not succeeded, server responded: " + con.getResponseCode() + " " + con.getResponseMessage());
            }
            in = con.getInputStream();
            if (this.binary) {
                this.binaryContent = IOUtils.toByteArray(in);
            } else {
                this.textContent = IOUtils.toString(in, "UTF-8");
            }
            con.disconnect();
            this.finishedOk = true;
            object = this.binary ? this.binaryContent : (Object)this.textContent;
        }
        catch (Throwable t) {
            try {
                logger.log(Level.WARNING, "Could not download file: " + this.url, t);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            return null;
        }
        IOUtils.closeQuietly(in);
        return object;
    }

    public String getTextContent() {
        return this.textContent;
    }

    public byte[] getBinaryContent() {
        return this.binaryContent;
    }

    public boolean isFinishedOk() {
        return this.finishedOk;
    }
}

