/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.load.babel;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tim.prune.I18nManager;
import tim.prune.gui.DecimalNumberField;
import tim.prune.gui.WholeNumberField;
import tim.prune.load.babel.AddFilterDialog;
import tim.prune.load.babel.FilterDefinition;

public class DistanceFilter
extends FilterDefinition {
    private DecimalNumberField _distField = null;
    private JComboBox<String> _distUnitsCombo = null;
    private WholeNumberField _secondsField = null;

    public DistanceFilter(AddFilterDialog addFilterDialog) {
        super(addFilterDialog);
        this.makePanelContents();
    }

    @Override
    protected String getFilterName() {
        return "position";
    }

    @Override
    protected void makePanelContents() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        this.add((Component)jPanel, "North");
        JLabel jLabel = new JLabel(I18nManager.getText("dialog.gpsbabel.filter.distance.intro"));
        jLabel.setAlignmentX(0.0f);
        jPanel.add(jLabel);
        jPanel.add(Box.createVerticalStrut(18));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(0, 3, 4, 4));
        jPanel2.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.distance.distance")));
        this._distField = new DecimalNumberField();
        this._distField.addKeyListener(this._paramChangeListener);
        jPanel2.add(this._distField);
        this._distUnitsCombo = new JComboBox<String>(new String[]{I18nManager.getText("units.metres"), I18nManager.getText("units.feet")});
        jPanel2.add(this._distUnitsCombo);
        jPanel2.add(new JLabel(I18nManager.getText("dialog.gpsbabel.filter.distance.time")));
        this._secondsField = new WholeNumberField(4);
        this._secondsField.addKeyListener(this._paramChangeListener);
        jPanel2.add(this._secondsField);
        jPanel2.add(new JLabel(I18nManager.getText("units.seconds")));
        jPanel2.setAlignmentX(0.0f);
        jPanel.add(jPanel2);
    }

    @Override
    public boolean isFilterValid() {
        boolean bl;
        if (this._distField.getText() == null || this._distField.getText().trim().equals("")) {
            return false;
        }
        boolean bl2 = bl = this._secondsField.getText() != null && this._secondsField.getText().trim().length() > 0;
        if (bl && this._secondsField.getValue() <= 1) {
            return false;
        }
        return this._distField.getValue() > 0.001;
    }

    @Override
    protected String getParameters() {
        boolean bl;
        if (!this.isFilterValid()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        double d = this._distField.getValue();
        stringBuilder.append(",distance=").append(d);
        stringBuilder.append(this._distUnitsCombo.getSelectedIndex() == 0 ? "m" : "f");
        boolean bl2 = bl = this._secondsField.getText() != null && this._secondsField.getText().trim().length() > 0;
        if (bl) {
            stringBuilder.append(",time=").append(this._secondsField.getValue());
        }
        return stringBuilder.toString();
    }
}

