/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.Writer;
import java.util.Properties;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.testng.reporters.Buffer;
import org.testng.reporters.IBuffer;
import org.testng.reporters.Tag;
import org.testng.reporters.XMLUtils;

public class XMLStringBuffer {
    public static final String EOL = System.getProperty("line.separator", "\n");
    private static final String DEFAULT_INDENT_INCREMENT = "  ";
    private IBuffer m_buffer;
    private final Stack<Tag> m_tagStack = new Stack();
    private String m_currentIndent = "";
    private String defaultComment = null;
    private static final Pattern INVALID_XML_CHARS = Pattern.compile("[^\\u0009\\u000A\\u000D\\u0020-\\uD7FF\\uE000-\\uFFFD\ud800\udc00-\udbff\udfff]");

    public XMLStringBuffer() {
        this.init(Buffer.create(), "", "1.0", "UTF-8");
    }

    public XMLStringBuffer(String string) {
        this.init(Buffer.create(), string);
    }

    public XMLStringBuffer(IBuffer iBuffer, String string) {
        this.init(iBuffer, string);
    }

    private void init(IBuffer iBuffer, String string) {
        this.init(iBuffer, string, null, null);
    }

    private void init(IBuffer iBuffer, String string, @Nullable String string2, @Nullable String string3) {
        this.m_buffer = iBuffer;
        this.m_currentIndent = string;
        if (string2 != null) {
            this.setXmlDetails(string2, string3);
        }
    }

    public void setXmlDetails(String string, String string2) {
        if (this.m_buffer.toString().length() != 0) {
            throw new IllegalStateException("Buffer should be empty: '" + this.m_buffer.toString() + "'");
        }
        this.m_buffer.append("<?xml version=\"" + string + "\" encoding=\"" + string2 + "\"?>").append(EOL);
    }

    public void setDocType(String string) {
        this.m_buffer.append("<!DOCTYPE " + string + ">" + EOL);
    }

    public void push(String string, @Nullable String string2, @Nullable Properties properties) {
        XMLUtils.xmlOpen(this.m_buffer, this.m_currentIndent, string + string2, properties);
        this.m_tagStack.push(new Tag(this.m_currentIndent, string, properties));
        this.m_currentIndent = this.m_currentIndent + DEFAULT_INDENT_INCREMENT;
    }

    public void push(String string, @Nullable String string2) {
        this.push(string, string2, (Properties)null);
    }

    public void push(String string, @Nullable Properties properties) {
        this.push(string, "", properties);
    }

    public void push(String string, String ... stringArray) {
        this.push(string, this.createProperties(stringArray));
    }

    private Properties createProperties(String[] stringArray) {
        Properties properties = new Properties();
        if (stringArray == null) {
            return properties;
        }
        if (stringArray.length % 2 != 0) {
            throw new IllegalArgumentException("Arguments 'attributes' length must be even. Actual: " + stringArray.length);
        }
        for (int i = 0; i < stringArray.length; i += 2) {
            properties.put(stringArray[i], stringArray[i + 1]);
        }
        return properties;
    }

    public void push(String string) {
        this.push(string, "");
    }

    public void pop() {
        this.pop(null);
    }

    public void pop(String string) {
        this.m_currentIndent = this.m_currentIndent.substring(DEFAULT_INDENT_INCREMENT.length());
        Tag tag = this.m_tagStack.pop();
        if (null != string && !string.equals(tag.tagName)) {
            throw new AssertionError((Object)("Popping the wrong tag: " + tag.tagName + " but expected " + string));
        }
        String string2 = this.defaultComment;
        if (string2 == null) {
            string2 = XMLUtils.extractComment(string, tag.properties);
        }
        XMLUtils.xmlClose(this.m_buffer, this.m_currentIndent, tag.tagName, string2);
    }

    public void addRequired(String string, @Nullable String string2) {
        this.addRequired(string, string2, (Properties)null);
    }

    public void addRequired(String string, @Nullable String string2, @Nullable Properties properties) {
        XMLUtils.xmlRequired(this.m_buffer, this.m_currentIndent, string, string2, properties);
    }

    public void addRequired(String string, @Nullable String string2, String ... stringArray) {
        this.addRequired(string, string2, this.createProperties(stringArray));
    }

    public void addOptional(String string, @Nullable String string2, @Nullable Properties properties) {
        if (string2 != null) {
            XMLUtils.xmlOptional(this.m_buffer, this.m_currentIndent, string, string2, properties);
        }
    }

    public void addOptional(String string, @Nullable String string2, String ... stringArray) {
        if (string2 != null) {
            XMLUtils.xmlOptional(this.m_buffer, this.m_currentIndent, string, string2, this.createProperties(stringArray));
        }
    }

    public void addOptional(String string, @Nullable String string2) {
        this.addOptional(string, string2, (Properties)null);
    }

    public void addOptional(String string, @Nullable Boolean bl, @Nullable Properties properties) {
        if (null != bl) {
            XMLUtils.xmlOptional(this.m_buffer, this.m_currentIndent, string, bl.toString(), properties);
        }
    }

    public void addOptional(String string, @Nullable Boolean bl) {
        this.addOptional(string, bl, null);
    }

    public void addEmptyElement(String string) {
        this.addEmptyElement(string, (Properties)null);
    }

    public void addEmptyElement(String string, @Nullable Properties properties) {
        this.m_buffer.append(this.m_currentIndent).append("<").append(string);
        XMLUtils.appendAttributes(this.m_buffer, properties);
        this.m_buffer.append("/>").append(EOL);
    }

    public void addEmptyElement(String string, String ... stringArray) {
        this.addEmptyElement(string, this.createProperties(stringArray));
    }

    public void addComment(String string) {
        this.m_buffer.append(this.m_currentIndent).append("<!-- " + string.replaceAll("[-]{2,}", "-") + " -->\n");
    }

    public void addString(String string) {
        this.m_buffer.append(string);
    }

    public void setDefaultComment(String string) {
        this.defaultComment = string;
    }

    public void addCDATA(String string) {
        if (string != null) {
            string = string.replaceAll("\\p{Cc}", "");
        }
        this.m_buffer.append(this.m_currentIndent);
        if (string == null) {
            this.m_buffer.append("<![CDATA[null]]>");
        } else if (!string.contains("]]>")) {
            this.m_buffer.append("<![CDATA[").append(string).append("]]>");
        } else if ("]]>".equals(string)) {
            this.m_buffer.append("<![CDATA[]]]]><![CDATA[>]]>");
        } else {
            String[] stringArray = string.split("]]>");
            this.m_buffer.append("<![CDATA[").append(stringArray[0]).append("]]]]>");
            for (int i = 1; i < stringArray.length - 1; ++i) {
                this.m_buffer.append("<![CDATA[>").append(stringArray[i]).append("]]]]>");
            }
            this.m_buffer.append("<![CDATA[>").append(stringArray[stringArray.length - 1]).append("]]>");
            if (string.endsWith("]]>")) {
                this.m_buffer.append("<![CDATA[]]]]>").append("<![CDATA[>]]>");
            }
        }
        this.m_buffer.append(EOL);
    }

    public IBuffer getStringBuffer() {
        return this.m_buffer;
    }

    public String toXML() {
        return INVALID_XML_CHARS.matcher(this.m_buffer.toString()).replaceAll("");
    }

    public String getCurrentIndent() {
        return this.m_currentIndent;
    }

    public void toWriter(Writer writer) {
        this.m_buffer.toWriter(writer);
    }
}

