/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.nodes.FieldReplaceAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.FixAccessModifiers;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.ProcessAnonymous;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JadxVisitor(name="ClassModifier", desc="Remove synthetic classes, methods and fields", runAfter={ModVisitor.class, FixAccessModifiers.class, ProcessAnonymous.class})
public class ClassModifier
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        if (ClassModifier.isEmptySyntheticClass(cls)) {
            cls.add(AFlag.DONT_GENERATE);
            return false;
        }
        ClassModifier.removeSyntheticFields(cls);
        cls.getMethods().forEach(ClassModifier::removeSyntheticMethods);
        cls.getMethods().forEach(ClassModifier::removeEmptyMethods);
        cls.getMethods().forEach(ClassModifier::cleanInsnsInAnonymousConstructor);
        return false;
    }

    private static boolean isEmptySyntheticClass(ClassNode cls) {
        return cls.getAccessFlags().isSynthetic() && cls.getFields().isEmpty() && cls.getMethods().isEmpty() && cls.getInnerClasses().isEmpty();
    }

    private static void removeSyntheticFields(ClassNode cls) {
        if (cls.getAccessFlags().isStatic()) {
            return;
        }
        boolean inline = cls.isAnonymous();
        if (inline || cls.getClassInfo().isInner()) {
            for (FieldNode field : cls.getFields()) {
                if (!field.getAccessFlags().isSynthetic() || !field.getType().isObject()) continue;
                ClassInfo clsInfo = ClassInfo.fromType(cls.root(), field.getType());
                ClassNode fieldsCls = cls.root().resolveClass(clsInfo);
                ClassInfo parentClass = cls.getClassInfo().getParentClass();
                if (fieldsCls == null || !inline && !parentClass.equals(fieldsCls.getClassInfo())) continue;
                int found = 0;
                for (MethodNode mth : cls.getMethods()) {
                    if (!ClassModifier.removeFieldUsageFromConstructor(mth, field, fieldsCls)) continue;
                    ++found;
                }
                if (found == 0) continue;
                field.addAttr(new FieldReplaceAttr(fieldsCls.getClassInfo()));
                field.add(AFlag.DONT_GENERATE);
            }
        }
    }

    private static boolean removeFieldUsageFromConstructor(MethodNode mth, FieldNode field, ClassNode fieldsCls) {
        if (mth.isNoCode() || !mth.getAccessFlags().isConstructor()) {
            return false;
        }
        List<RegisterArg> args = mth.getArgRegs();
        if (args.isEmpty() || mth.contains(AFlag.SKIP_FIRST_ARG)) {
            return false;
        }
        RegisterArg arg = args.get(0);
        if (!arg.getType().equals(fieldsCls.getClassInfo().getType())) {
            return false;
        }
        BlockNode block = mth.getBasicBlocks().get(0);
        List<InsnNode> instructions = block.getInstructions();
        if (instructions.isEmpty()) {
            return false;
        }
        InsnNode insn = instructions.get(0);
        if (insn.getType() != InsnType.IPUT) {
            return false;
        }
        IndexInsnNode putInsn = (IndexInsnNode)insn;
        FieldInfo fieldInfo = (FieldInfo)putInsn.getIndex();
        if (!fieldInfo.equals(field.getFieldInfo()) || !putInsn.getArg(0).equals(arg)) {
            return false;
        }
        mth.skipFirstArgument();
        InsnRemover.remove(mth, block, insn);
        if (arg.getSVar().getUseCount() != 0) {
            IndexInsnNode iget = new IndexInsnNode(InsnType.IGET, fieldInfo, 1);
            iget.addArg(insn.getArg(1));
            for (InsnArg insnArg : new ArrayList<RegisterArg>(arg.getSVar().getUseList())) {
                insnArg.wrapInstruction(mth, iget);
            }
        }
        return true;
    }

    private static void removeSyntheticMethods(MethodNode mth) {
        List<RegisterArg> args;
        if (mth.isNoCode()) {
            return;
        }
        AccessInfo af = mth.getAccessFlags();
        if (!af.isSynthetic()) {
            return;
        }
        ClassNode cls = mth.getParentClass();
        if (ClassModifier.removeBridgeMethod(cls, mth)) {
            mth.add(AFlag.DONT_GENERATE);
            return;
        }
        if (af.isConstructor() && mth.getBasicBlocks().size() == 2 && ClassModifier.isRemovedClassInArgs(cls, args = mth.getArgRegs())) {
            ClassModifier.modifySyntheticMethod(cls, mth, args);
        }
    }

    private static boolean isRemovedClassInArgs(ClassNode cls, List<RegisterArg> mthArgs) {
        for (RegisterArg arg : mthArgs) {
            ClassInfo argClsInfo;
            ClassNode argCls;
            ArgType argType = arg.getType();
            if (!argType.isObject() || !((argCls = cls.root().resolveClass(argType)) == null ? (argClsInfo = ClassInfo.fromType(cls.root(), argType)).isInner() && cls.getFullName().startsWith(argClsInfo.getParentClass().getFullName()) : argCls.contains(AFlag.DONT_GENERATE) || ClassModifier.isEmptySyntheticClass(argCls))) continue;
            return true;
        }
        return false;
    }

    private static void modifySyntheticMethod(ClassNode cls, MethodNode mth, List<RegisterArg> args) {
        ConstructorInsn constr;
        List<InsnNode> insns = mth.getBasicBlocks().get(0).getInstructions();
        if (insns.size() == 1 && insns.get(0).getType() == InsnType.CONSTRUCTOR && (constr = (ConstructorInsn)insns.get(0)).isThis() && !args.isEmpty()) {
            RegisterArg firstArg = args.get(0);
            if (firstArg.getType().equals(cls.getParentClass().getClassInfo().getType())) {
                SkipMethodArgsAttr.skipArg(mth, 0);
            }
            int argsCount = args.size();
            for (int i = 0; i < argsCount; ++i) {
                RegisterArg arg = args.get(i);
                SSAVar sVar = arg.getSVar();
                if (sVar == null || sVar.getUseCount() != 0) continue;
                SkipMethodArgsAttr.skipArg(mth, i);
            }
            mth.add(AFlag.DONT_GENERATE);
        }
    }

    private static boolean removeBridgeMethod(ClassNode cls, MethodNode mth) {
        List<InsnNode> allInsns;
        if (cls.root().getArgs().isRenameValid() && (allInsns = BlockUtils.collectAllInsns(mth.getBasicBlocks())).size() == 1) {
            InsnArg arg;
            InsnNode wrappedInsn = allInsns.get(0);
            if (wrappedInsn.getType() == InsnType.RETURN && (arg = wrappedInsn.getArg(0)).isInsnWrap()) {
                wrappedInsn = ((InsnWrapArg)arg).getWrapInsn();
            }
            if (ClassModifier.checkSyntheticWrapper(mth, wrappedInsn)) {
                return true;
            }
        }
        return !ClassModifier.isMethodUnique(cls, mth);
    }

    private static boolean checkSyntheticWrapper(MethodNode mth, InsnNode insn) {
        InsnType insnType = insn.getType();
        if (insnType != InsnType.INVOKE) {
            return false;
        }
        InvokeNode invokeInsn = (InvokeNode)insn;
        if (invokeInsn.getInvokeType() == InvokeType.SUPER) {
            return false;
        }
        MethodInfo callMth = invokeInsn.getCallMth();
        MethodNode wrappedMth = mth.root().deepResolveMethod(callMth);
        if (wrappedMth == null) {
            return false;
        }
        AccessInfo wrappedAccFlags = wrappedMth.getAccessFlags();
        if (wrappedAccFlags.isStatic()) {
            return false;
        }
        if (callMth.getArgsCount() != mth.getMethodInfo().getArgsCount()) {
            return false;
        }
        if (!mth.getParentClass().equals(wrappedMth.getParentClass())) {
            return false;
        }
        for (InsnArg arg : insn.getArguments()) {
            if (ClassModifier.registersAndCastsOnly(arg)) continue;
            return false;
        }
        if (!wrappedAccFlags.isPublic()) {
            FixAccessModifiers.changeVisibility(wrappedMth, 1);
        }
        String alias = mth.getAlias();
        if (!Objects.equals(wrappedMth.getAlias(), alias)) {
            wrappedMth.getMethodInfo().setAlias(alias);
        }
        return true;
    }

    private static boolean registersAndCastsOnly(InsnArg arg) {
        InsnNode wrapInsn;
        if (arg.isRegister()) {
            return true;
        }
        if (arg.isInsnWrap() && (wrapInsn = ((InsnWrapArg)arg).getWrapInsn()).getType() == InsnType.CHECK_CAST) {
            return ClassModifier.registersAndCastsOnly(wrapInsn.getArg(0));
        }
        return false;
    }

    private static boolean isMethodUnique(ClassNode cls, MethodNode mth) {
        MethodInfo mi = mth.getMethodInfo();
        for (MethodNode otherMth : cls.getMethods()) {
            MethodInfo omi;
            if (otherMth == mth || !(omi = otherMth.getMethodInfo()).getName().equals(mi.getName()) || !Objects.equals(omi.getArgumentsTypes(), mi.getArgumentsTypes())) continue;
            return false;
        }
        return true;
    }

    private static void removeEmptyMethods(MethodNode mth) {
        List<BlockNode> bb;
        AccessInfo af = mth.getAccessFlags();
        if (af.isConstructor() && (af.isPublic() || af.isStatic()) && mth.getArgRegs().isEmpty() && ((bb = mth.getBasicBlocks()) == null || bb.isEmpty() || BlockUtils.isAllBlocksEmpty(bb))) {
            if (af.isStatic() && mth.getMethodInfo().isClassInit()) {
                mth.add(AFlag.DONT_GENERATE);
            } else if (mth.isDefaultConstructor() && !ClassModifier.isNonDefaultConstructorExists(mth)) {
                mth.add(AFlag.DONT_GENERATE);
            }
        }
    }

    private static void cleanInsnsInAnonymousConstructor(MethodNode mth) {
        if (!mth.contains(AFlag.ANONYMOUS_CONSTRUCTOR)) {
            return;
        }
        for (BlockNode block : mth.getBasicBlocks()) {
            for (InsnNode insn : block.getInstructions()) {
                InsnType type = insn.getType();
                if (type == InsnType.CONSTRUCTOR) {
                    ConstructorInsn ctorInsn = (ConstructorInsn)insn;
                    if (!ctorInsn.isSuper()) continue;
                    ctorInsn.add(AFlag.DONT_GENERATE);
                    continue;
                }
                if (type != InsnType.IPUT) continue;
                FieldInfo fldInfo = (FieldInfo)((IndexInsnNode)insn).getIndex();
                FieldNode fieldNode = mth.root().resolveField(fldInfo);
                if (fieldNode == null || !fieldNode.contains(AFlag.DONT_GENERATE)) continue;
                insn.add(AFlag.DONT_GENERATE);
            }
        }
    }

    private static boolean isNonDefaultConstructorExists(MethodNode defCtor) {
        ClassNode parentClass = defCtor.getParentClass();
        for (MethodNode mth : parentClass.getMethods()) {
            if (mth == defCtor || !mth.isConstructor() || mth.isDefaultConstructor()) continue;
            return true;
        }
        return false;
    }
}

