/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.jsampler.CC;
import org.jsampler.HF;
import org.jsampler.view.JSMainFrame;
import org.jsampler.view.JSProgress;
import org.jsampler.view.JSViewConfig;

public class JSViews {
    private static Vector<ViewEntry> viewEntries = new Vector();
    private static String currentView = null;
    private static String defaultView = null;

    private JSViews() {
    }

    public static String[] getAvailableViews() {
        String[] stringArray = new String[viewEntries.size()];
        for (int i = 0; i < viewEntries.size(); ++i) {
            stringArray[i] = JSViews.viewEntries.get((int)i).name;
        }
        return stringArray;
    }

    public static String getCurrentView() {
        return currentView;
    }

    public static String getDefaultView() {
        return defaultView;
    }

    public static void setView(String string) {
        if (string == null) {
            CC.getLogger().info("viewName is null!");
            return;
        }
        ViewEntry viewEntry = null;
        for (ViewEntry viewEntry2 : viewEntries) {
            if (!string.equals(viewEntry2.name)) continue;
            viewEntry = viewEntry2;
            break;
        }
        if (viewEntry == null) {
            CC.getLogger().info("Missing view: " + string);
            return;
        }
        if (CC.getMainFrame() != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CC.getMainFrame().setVisible(false);
                }
            });
        }
        try {
            CC.setViewConfig((JSViewConfig)Class.forName(viewEntry.viewConfig).newInstance());
        }
        catch (Exception exception) {
            CC.getLogger().info(HF.getErrorMessage(exception));
            return;
        }
        final ViewEntry viewEntry3 = viewEntry;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JSViews.setView0(viewEntry3);
            }
        });
    }

    private static void setView0(ViewEntry viewEntry) {
        try {
            CC.setMainFrame((JSMainFrame)Class.forName(viewEntry.mainFrame).newInstance());
            CC.setProgressIndicator((JSProgress)Class.forName(viewEntry.progressIndicator).newInstance());
            CC.getMainFrame().setVisible(true);
            currentView = viewEntry.name;
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
            return;
        }
    }

    public static void parseManifest() {
        viewEntries.removeAllElements();
        try {
            Attributes attributes;
            Manifest manifest = new Manifest(JSViews.class.getResourceAsStream("views.mf"));
            String string = manifest.getMainAttributes().getValue("JS-Views");
            if (string == null) {
                CC.getLogger().warning("Missing manifest attribute: JS-Views");
                return;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                string = stringTokenizer.nextToken();
                attributes = manifest.getAttributes(string);
                if (attributes == null) {
                    CC.getLogger().warning("Missing manifest entry: " + string);
                    continue;
                }
                ViewEntry viewEntry = new ViewEntry();
                viewEntry.name = attributes.getValue("View-Name");
                viewEntry.viewConfig = attributes.getValue("View-Config");
                viewEntry.mainFrame = attributes.getValue("Main-Frame");
                viewEntry.progressIndicator = attributes.getValue("Progress-Indicator");
                viewEntries.addElement(viewEntry);
            }
            string = manifest.getMainAttributes().getValue("JS-Default-View");
            attributes = manifest.getAttributes(string);
            if (attributes != null) {
                defaultView = attributes.getValue("View-Name");
            }
        }
        catch (Exception exception) {
            CC.getLogger().log(Level.INFO, HF.getErrorMessage(exception), exception);
        }
    }

    private static class ViewEntry {
        String name;
        String viewConfig;
        String mainFrame;
        String progressIndicator;

        private ViewEntry() {
        }
    }
}

