/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;

public class StreamCopyThread
extends Thread {
    private static final int BUFFER_SIZE = 1024;
    private final InputStream src;
    private final OutputStream dst;
    private volatile boolean done;
    private final Object writeLock;

    public StreamCopyThread(InputStream i, OutputStream o) {
        this.setName(Thread.currentThread().getName() + "-StreamCopy");
        this.src = i;
        this.dst = o;
        this.writeLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void flush() {
        Object object = this.writeLock;
        synchronized (object) {
            this.interrupt();
        }
    }

    public void halt() throws InterruptedException {
        while (true) {
            this.join(250L);
            if (!this.isAlive()) break;
            this.done = true;
            this.interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            byte[] buf = new byte[1024];
            boolean readInterrupted = false;
            try {
                while (true) {
                    int n;
                    if (readInterrupted) {
                        Object object = this.writeLock;
                        synchronized (object) {
                            boolean interruptedAgain = Thread.interrupted();
                            this.dst.flush();
                            if (interruptedAgain) {
                                this.interrupt();
                            }
                        }
                        readInterrupted = false;
                    }
                    if (this.done) {
                        return;
                    }
                    try {
                        n = this.src.read(buf);
                    }
                    catch (InterruptedIOException wakey) {
                        readInterrupted = true;
                        continue;
                    }
                    if (n < 0) {
                        return;
                    }
                    Object object = this.writeLock;
                    synchronized (object) {
                        boolean writeInterrupted = Thread.interrupted();
                        this.dst.write(buf, 0, n);
                        if (writeInterrupted) {
                            this.interrupt();
                        }
                    }
                }
            }
            catch (IOException e) {
                // empty catch block
                return;
            }
        }
        finally {
            try {
                this.src.close();
            }
            catch (IOException iOException) {}
            try {
                this.dst.close();
            }
            catch (IOException iOException) {}
        }
    }
}

