/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.NotificationsManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsNotifier {
    public static final NotificationGroup NOTIFICATION_GROUP_ID = NotificationGroup.toolWindowGroup((String)"Vcs Messages", (String)"Version Control");
    public static final NotificationGroup IMPORTANT_ERROR_NOTIFICATION = new NotificationGroup("Vcs Important Messages", NotificationDisplayType.STICKY_BALLOON, true);
    public static final NotificationGroup STANDARD_NOTIFICATION = new NotificationGroup("Vcs Notifications", NotificationDisplayType.BALLOON, true);
    public static final NotificationGroup SILENT_NOTIFICATION = new NotificationGroup("Vcs Silent Notifications", NotificationDisplayType.NONE, true);
    @NotNull
    private final Project myProject;

    public static VcsNotifier getInstance(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(0);
        }
        return (VcsNotifier)ServiceManager.getService((Project)project, VcsNotifier.class);
    }

    public VcsNotifier(@NotNull Project project) {
        if (project == null) {
            VcsNotifier.$$$reportNull$$$0(1);
        }
        this.myProject = project;
    }

    @NotNull
    public Notification notify(@NotNull Notification notification) {
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(2);
        }
        notification.notify(this.myProject);
        Notification notification2 = notification;
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(3);
        }
        return notification2;
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(4);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(5);
        }
        Notification notification = this.notifyError(title2, message, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(6);
        }
        return notification;
    }

    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, boolean showDetailsAction) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(7);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(8);
        }
        if (showDetailsAction && ProjectLevelVcsManager.getInstance((Project)this.myProject).isConsoleVisible()) {
            return this.notifyError(title2, message, this.createShowDetailsAction());
        }
        return this.notifyError(title2, message);
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(9);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(10);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.ERROR, listener2);
    }

    @NotNull
    public Notification notifyError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(11);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(12);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.ERROR, actions);
    }

    @NotNull
    public Notification notifyWeakError(@NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(13);
        }
        Notification notification = this.notifyWeakError("", message);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(14);
        }
        return notification;
    }

    @NotNull
    public Notification notifyWeakError(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(15);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(16);
        }
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.ERROR, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(17);
        }
        Notification notification = this.notifySuccess("", message);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(18);
        }
        return notification;
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(19);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(20);
        }
        Notification notification = this.notifySuccess(title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(21);
        }
        return notification;
    }

    @NotNull
    public Notification notifySuccess(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(22);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(23);
        }
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(24);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(25);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(26);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(27);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationContent @NotNull String message) {
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(28);
        }
        Notification notification = this.notifyInfo("", message);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(29);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(30);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(31);
        }
        Notification notification = this.notifyInfo(title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(32);
        }
        return notification;
    }

    @NotNull
    public Notification notifyInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(33);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(34);
        }
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(35);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(36);
        }
        Notification notification = this.notifyMinorWarning(title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(37);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(38);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(39);
        }
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(40);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(41);
        }
        Notification notification = this.notifyWarning(title2, message, null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(42);
        }
        return notification;
    }

    @NotNull
    public Notification notifyWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(43);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(44);
        }
        return this.notify(NOTIFICATION_GROUP_ID, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(45);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(46);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, new NotificationAction[0]);
    }

    @NotNull
    public Notification notifyImportantWarning(@Nls @NotNull String title2, @Nls @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(47);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(48);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, actions);
    }

    @NotNull
    public Notification notifyImportantWarning(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(49);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(50);
        }
        return this.notify(IMPORTANT_ERROR_NOTIFICATION, title2, message, NotificationType.WARNING, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(51);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(52);
        }
        Notification notification = this.notifyMinorInfo(title2, message, (NotificationListener)null);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(53);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @Nullable NotificationListener listener2) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(54);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(55);
        }
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.INFORMATION, listener2);
    }

    @NotNull
    public Notification notifyMinorInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(56);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(57);
        }
        return this.notify(STANDARD_NOTIFICATION, title2, message, NotificationType.INFORMATION, actions);
    }

    @NotNull
    public Notification notifyMinorInfo(boolean sticky, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(58);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(59);
        }
        Notification notification = this.notifyMinorInfo(sticky, null, title2, message, actions);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(60);
        }
        return notification;
    }

    @NotNull
    public Notification notifyMinorInfo(boolean sticky, @NonNls @Nullable String notificationDisplayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, NotificationAction ... actions) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(61);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(62);
        }
        return this.notify(sticky ? IMPORTANT_ERROR_NOTIFICATION : STANDARD_NOTIFICATION, notificationDisplayId, title2, message, NotificationType.INFORMATION, actions);
    }

    public Notification logInfo(@NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message) {
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(63);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(64);
        }
        return this.notify(SILENT_NOTIFICATION, title2, message, NotificationType.INFORMATION, new NotificationAction[0]);
    }

    public void showNotificationAndHideExisting(@NotNull Notification notificationToShow, @NotNull Class<? extends Notification> klass) {
        if (notificationToShow == null) {
            VcsNotifier.$$$reportNull$$$0(65);
        }
        if (klass == null) {
            VcsNotifier.$$$reportNull$$$0(66);
        }
        this.hideAllNotificationsByType(klass);
        notificationToShow.notify(this.myProject);
    }

    public void hideAllNotificationsByType(@NotNull Class<? extends Notification> klass) {
        if (klass == null) {
            VcsNotifier.$$$reportNull$$$0(67);
        }
        NotificationsManager notificationsManager = NotificationsManager.getNotificationsManager();
        for (Notification notification : notificationsManager.getNotificationsOfType(klass, this.myProject)) {
            notification.expire();
        }
    }

    @NotNull
    private static Notification createNotification(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2, @Nullable String notificationDisplayId) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(68);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(69);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(70);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(71);
        }
        if (StringUtil.isEmptyOrSpaces((String)message)) {
            message = title2;
            title2 = "";
        }
        Notification notification = notificationGroup.createNotification(title2, message, type, listener2, notificationDisplayId);
        if (notification == null) {
            VcsNotifier.$$$reportNull$$$0(72);
        }
        return notification;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, @Nullable NotificationListener listener2) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(73);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(74);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(75);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(76);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, title2, message, type, listener2, null);
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(77);
        }
        return notification2;
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(78);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(79);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(80);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(81);
        }
        return this.notify(notificationGroup, null, title2, message, type, actions);
    }

    @NotNull
    private Notification notify(@NotNull NotificationGroup notificationGroup, @NonNls @Nullable String notificationDisplayId, @NlsContexts.NotificationTitle @NotNull String title2, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType type, NotificationAction ... actions) {
        if (notificationGroup == null) {
            VcsNotifier.$$$reportNull$$$0(82);
        }
        if (title2 == null) {
            VcsNotifier.$$$reportNull$$$0(83);
        }
        if (message == null) {
            VcsNotifier.$$$reportNull$$$0(84);
        }
        if (type == null) {
            VcsNotifier.$$$reportNull$$$0(85);
        }
        Notification notification = VcsNotifier.createNotification(notificationGroup, title2, message, type, null, notificationDisplayId);
        for (NotificationAction action : actions) {
            notification.addAction((AnAction)action);
        }
        Notification notification2 = this.notify(notification);
        if (notification2 == null) {
            VcsNotifier.$$$reportNull$$$0(86);
        }
        return notification2;
    }

    @NotNull
    private NotificationAction createShowDetailsAction() {
        NotificationAction notificationAction = NotificationAction.createSimple((String)VcsBundle.message((String)"notification.showDetailsInConsole", (Object[])new Object[0]), () -> {
            ProjectLevelVcsManager vcsManager2 = ProjectLevelVcsManager.getInstance((Project)this.myProject);
            vcsManager2.showConsole(() -> ((ProjectLevelVcsManager)vcsManager2).scrollConsoleToTheEnd());
        });
        if (notificationAction == null) {
            VcsNotifier.$$$reportNull$$$0(87);
        }
        return notificationAction;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 53: 
            case 60: 
            case 72: 
            case 77: 
            case 86: 
            case 87: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 53: 
            case 60: 
            case 72: 
            case 77: 
            case 86: 
            case 87: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 53: 
            case 60: 
            case 72: 
            case 77: 
            case 86: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 4: 
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 19: 
            case 22: 
            case 24: 
            case 26: 
            case 30: 
            case 33: 
            case 35: 
            case 38: 
            case 40: 
            case 43: 
            case 45: 
            case 47: 
            case 49: 
            case 51: 
            case 54: 
            case 56: 
            case 58: 
            case 61: 
            case 63: 
            case 69: 
            case 74: 
            case 79: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 17: 
            case 20: 
            case 23: 
            case 25: 
            case 27: 
            case 28: 
            case 31: 
            case 34: 
            case 36: 
            case 39: 
            case 41: 
            case 44: 
            case 46: 
            case 48: 
            case 50: 
            case 52: 
            case 55: 
            case 57: 
            case 59: 
            case 62: 
            case 64: 
            case 70: 
            case 75: 
            case 80: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationToShow";
                break;
            }
            case 66: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 68: 
            case 73: 
            case 78: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroup";
                break;
            }
            case 71: 
            case 76: 
            case 81: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsNotifier";
                break;
            }
            case 3: 
            case 77: 
            case 86: {
                objectArray = objectArray2;
                objectArray2[1] = "notify";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyError";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyWeakError";
                break;
            }
            case 18: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "notifySuccess";
                break;
            }
            case 29: 
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyInfo";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorWarning";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyWarning";
                break;
            }
            case 53: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "notifyMinorInfo";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createNotification";
                break;
            }
            case 87: {
                objectArray = objectArray2;
                objectArray2[1] = "createShowDetailsAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "notify";
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 53: 
            case 60: 
            case 72: 
            case 77: 
            case 86: 
            case 87: {
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "notifyError";
                break;
            }
            case 13: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "notifyWeakError";
                break;
            }
            case 17: 
            case 19: 
            case 20: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifySuccess";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantInfo";
                break;
            }
            case 28: 
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "notifyInfo";
                break;
            }
            case 35: 
            case 36: 
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorWarning";
                break;
            }
            case 40: 
            case 41: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "notifyWarning";
                break;
            }
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "notifyImportantWarning";
                break;
            }
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "notifyMinorInfo";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "logInfo";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "showNotificationAndHideExisting";
                break;
            }
            case 67: {
                objectArray = objectArray;
                objectArray[2] = "hideAllNotificationsByType";
                break;
            }
            case 68: 
            case 69: 
            case 70: 
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "createNotification";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 29: 
            case 32: 
            case 37: 
            case 42: 
            case 53: 
            case 60: 
            case 72: 
            case 77: 
            case 86: 
            case 87: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

