/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.statistics;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventFactoryKt;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.internal.statistic.service.fus.collectors.UsageDescriptorKeyValidator;
import com.intellij.internal.statistic.utils.PluginInfoDetectorKt;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogApplicationSettings;
import com.intellij.vcs.log.impl.VcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogUiPropertiesImpl;
import com.intellij.vcs.log.impl.VcsProjectLog;
import com.intellij.vcs.log.ui.VcsLogUiImpl;
import com.intellij.vcs.log.ui.highlighters.VcsLogHighlighterFactory;
import com.intellij.vcs.log.ui.table.VcsLogColumn;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class VcsLogFeaturesCollector
extends ProjectUsagesCollector {
    @NotNull
    public Set<MetricEvent> getMetrics(@NotNull Project project) {
        VcsLogUiImpl ui2;
        VcsProjectLog projectLog;
        if (project == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(0);
        }
        if ((projectLog = VcsProjectLog.getInstance(project)) != null && (ui2 = projectLog.getMainLogUi()) != null) {
            MainVcsLogUiProperties properties = ui2.getProperties();
            VcsLogUiProperties defaultProperties = VcsLogFeaturesCollector.createDefaultPropertiesInstance();
            HashSet metricEvents = ContainerUtil.newHashSet((Object[])new MetricEvent[]{new MetricEvent("uiInitialized")});
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DETAILS), (String)"details");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_DIFF_PREVIEW), (String)"diffPreview");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.DIFF_PREVIEW_VERTICAL_SPLIT), (String)"diffPreviewOnTheBottom");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_CHANGES_FROM_PARENTS), (String)"parentChanges");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_ONLY_AFFECTED_CHANGES), (String)"onlyAffectedChanges");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_LONG_EDGES), (String)"long.edges");
            MetricEventUtilKt.addIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.BEK_SORT_TYPE), (String)"sort");
            if (ui2.getColorManager().hasMultiplePaths()) {
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(CommonUiProperties.SHOW_ROOT_NAMES), (String)"roots");
            }
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.COMPACT_REFERENCES_VIEW), (String)"labels.compact");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.SHOW_TAG_NAMES), (String)"labels.showTagNames");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.LABELS_LEFT_ALIGNED), (String)"labels.onTheLeft");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_REGEX), (String)"textFilter.regex");
            MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.TEXT_FILTER_MATCH_CASE), (String)"textFilter.matchCase");
            for (VcsLogHighlighterFactory factory : VcsLogUiImpl.LOG_HIGHLIGHTER_FACTORY_EP.getExtensionList()) {
                if (!factory.showMenuItem()) continue;
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, (Object)properties, (Object)defaultProperties, VcsLogFeaturesCollector.getter(MainVcsLogUiProperties.VcsLogHighlighterProperty.get(factory.getId())), (String)"highlighter", (FeatureUsageData)new FeatureUsageData().addData("id", VcsLogFeaturesCollector.getFactoryIdSafe(factory)));
            }
            for (VcsLogFilterCollection.FilterKey key : VcsLogFilterCollection.STANDARD_KEYS) {
                if (properties.getFilterValues(key.getName()) == null) continue;
                metricEvents.add(MetricEventFactoryKt.newBooleanMetric((String)"filter", (boolean)true, (FeatureUsageData)new FeatureUsageData().addData("name", key.getName())));
            }
            HashSet currentColumns = new HashSet(properties.get(CommonUiProperties.COLUMN_ORDER));
            HashSet defaultColumns = new HashSet(defaultProperties.get(CommonUiProperties.COLUMN_ORDER));
            for (VcsLogColumn column : VcsLogColumn.DYNAMIC_COLUMNS) {
                String columnName = column.getStableName();
                MetricEventUtilKt.addBoolIfDiffers((Set)metricEvents, currentColumns, defaultColumns, p -> p.contains(column.ordinal()), (String)"column", (FeatureUsageData)new FeatureUsageData().addData("name", columnName));
            }
            Collection<String> tabs = projectLog.getTabsManager().getTabs();
            metricEvents.add(MetricEventFactoryKt.newCounterMetric((String)"additionalTabs", (int)tabs.size()));
            HashSet hashSet = metricEvents;
            if (hashSet == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(1);
            }
            return hashSet;
        }
        Set<MetricEvent> set = Collections.emptySet();
        if (set == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @NotNull
    private static String getFactoryIdSafe(@NotNull VcsLogHighlighterFactory factory) {
        if (factory == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(3);
        }
        if (PluginInfoDetectorKt.getPluginInfo(factory.getClass()).isDevelopedByJetBrains()) {
            String string = UsageDescriptorKeyValidator.ensureProperKey((String)factory.getId());
            if (string == null) {
                VcsLogFeaturesCollector.$$$reportNull$$$0(4);
            }
            return string;
        }
        return "THIRD_PARTY";
    }

    @NotNull
    private static <T> Function1<VcsLogUiProperties, T> getter(@NotNull VcsLogUiProperties.VcsLogUiProperty<? extends T> property) {
        if (property == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(5);
        }
        Function1 function1 = p -> {
            if (!p.exists(property)) {
                return null;
            }
            return p.get(property);
        };
        if (function1 == null) {
            VcsLogFeaturesCollector.$$$reportNull$$$0(6);
        }
        return function1;
    }

    @NotNull
    private static VcsLogUiProperties createDefaultPropertiesInstance() {
        return new VcsLogUiPropertiesImpl<VcsLogUiPropertiesImpl.State>(new VcsLogApplicationSettings()){
            @NotNull
            private final VcsLogUiPropertiesImpl.State myState = new VcsLogUiPropertiesImpl.State();

            @Override
            @NotNull
            public VcsLogUiPropertiesImpl.State getState() {
                VcsLogUiPropertiesImpl.State state = this.myState;
                if (state == null) {
                    1.$$$reportNull$$$0(0);
                }
                return state;
            }

            @Override
            public void addRecentlyFilteredGroup(@NotNull String filterName, @NotNull Collection<String> values) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (values == null) {
                    1.$$$reportNull$$$0(2);
                }
                throw new UnsupportedOperationException();
            }

            @Override
            @NotNull
            public List<List<String>> getRecentlyFilteredGroups(@NotNull String filterName) {
                if (filterName == null) {
                    1.$$$reportNull$$$0(3);
                }
                throw new UnsupportedOperationException();
            }

            public void loadState(@NotNull VcsLogUiPropertiesImpl.State state) {
                if (state == null) {
                    1.$$$reportNull$$$0(4);
                }
                throw new UnsupportedOperationException();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                    case 1: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "filterName";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "values";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "state";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getState";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "addRecentlyFilteredGroup";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "getRecentlyFilteredGroups";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "loadState";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    @NotNull
    public String getGroupId() {
        return "vcs.log.ui";
    }

    public int getVersion() {
        return 2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/statistics/VcsLogFeaturesCollector";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMetrics";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getFactoryIdSafe";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMetrics";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getFactoryIdSafe";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getter";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

