/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.DependentNSReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.URLReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class URIReferenceProvider
extends PsiReferenceProvider {
    public static final ElementFilter ELEMENT_FILTER = new ElementFilter(){

        public boolean isAcceptable(Object element, PsiElement context) {
            PsiElement parent = context.getParent();
            if (parent instanceof XmlAttribute) {
                XmlAttribute attribute = (XmlAttribute)parent;
                return attribute.isNamespaceDeclaration();
            }
            return false;
        }

        public boolean isClassAcceptable(Class hintClass) {
            return true;
        }
    };
    @NonNls
    private static final String NAMESPACE_ATTR_NAME = "namespace";

    public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            URIReferenceProvider.$$$reportNull$$$0(0);
        }
        if (context == null) {
            URIReferenceProvider.$$$reportNull$$$0(1);
        }
        String text = element.getText();
        String s = StringUtil.unquoteString((String)text);
        PsiElement parent = element.getParent();
        if (parent instanceof XmlAttribute && "schemaLocation".equals(((XmlAttribute)parent).getLocalName()) && "http://www.w3.org/2001/XMLSchema-instance".equals(((XmlAttribute)parent).getNamespace())) {
            ArrayList<Object> refs = new ArrayList<Object>(2);
            StringTokenizer tokenizer = new StringTokenizer(s);
            while (tokenizer.hasMoreElements()) {
                String namespace = tokenizer.nextToken();
                int offset = text.indexOf(namespace);
                TextRange range = new TextRange(offset, offset + namespace.length());
                URLReference urlReference = new URLReference(element, range, true){

                    @Override
                    public boolean isSchemaLocation() {
                        return true;
                    }
                };
                refs.add(urlReference);
                if (!tokenizer.hasMoreElements()) break;
                String url = tokenizer.nextToken();
                offset = text.indexOf(url);
                refs.add(new DependentNSReference(element, new TextRange(offset, offset + url.length()), urlReference));
                if (XmlUtil.isUrlText(url, element.getProject())) continue;
                ContainerUtil.addAll(refs, (Object[])new FileReferenceSet(url, element, offset, (PsiReferenceProvider)this, false).getAllReferences());
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                URIReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }
        PsiReference reference = URIReferenceProvider.getUrlReference(element, s);
        if (reference != null) {
            PsiReference[] psiReferenceArray = new PsiReference[]{reference};
            if (psiReferenceArray == null) {
                URIReferenceProvider.$$$reportNull$$$0(3);
            }
            return psiReferenceArray;
        }
        s = s.substring(XmlUtil.getPrefixLength(s));
        FileReference[] fileReferenceArray = new FileReferenceSet(s, element, text.indexOf(s), (PsiReferenceProvider)this, true).getAllReferences();
        if (fileReferenceArray == null) {
            URIReferenceProvider.$$$reportNull$$$0(4);
        }
        return fileReferenceArray;
    }

    static PsiReference getUrlReference(PsiElement element, String s) {
        PsiElement parent = element.getParent();
        if ((XmlUtil.isUrlText(s, element.getProject()) || parent instanceof XmlAttribute && (((XmlAttribute)parent).isNamespaceDeclaration() || NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()))) && !s.startsWith("urn:jsptagdir:")) {
            boolean namespaceSoftRef;
            boolean bl = namespaceSoftRef = parent instanceof XmlAttribute && NAMESPACE_ATTR_NAME.equals(((XmlAttribute)parent).getName()) && ((XmlAttribute)parent).getParent().getAttributeValue("schemaLocation") != null;
            if (!namespaceSoftRef && parent instanceof XmlAttribute && ((XmlAttribute)parent).isNamespaceDeclaration()) {
                namespaceSoftRef = parent.getContainingFile().getContext() != null;
            }
            return new URLReference(element, null, namespaceSoftRef);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/source/resolve/reference/impl/providers/URIReferenceProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReferencesByElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getReferencesByElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

