/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkout;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.ui.DvcsBundle;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CheckoutProviderEx;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.ui.VcsCloneComponent;
import com.intellij.openapi.vcs.ui.cloneDialog.VcsCloneDialogComponentStateListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.checkout.GitCloneDialog;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.ui.GitCloneDialogComponent;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GitCheckoutProvider
extends CheckoutProviderEx {
    public String getVcsName() {
        return "_Git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener, @Nullable String predefinedRepositoryUrl) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(0);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        GitCloneDialog dialog2 = new GitCloneDialog(project, predefinedRepositoryUrl);
        if (!dialog2.showAndGet()) {
            return;
        }
        dialog2.rememberSettings();
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        File parent = new File(dialog2.getParentDirectory());
        VirtualFile destinationParent = lfs.findFileByIoFile(parent);
        if (destinationParent == null) {
            destinationParent = lfs.refreshAndFindFileByIoFile(parent);
        }
        if (destinationParent == null) {
            return;
        }
        String sourceRepositoryURL = dialog2.getSourceRepositoryURL();
        String directoryName = dialog2.getDirectoryName();
        String parentDirectory = dialog2.getParentDirectory();
        GitCheckoutProvider.clone(project, Git.getInstance(), listener, destinationParent, sourceRepositoryURL, directoryName, parentDirectory);
    }

    public static void clone(final Project project, final @NotNull Git git, final CheckoutProvider.Listener listener, final VirtualFile destinationParent, final String sourceRepositoryURL, final String directoryName, final String parentDirectory) {
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(1);
        }
        final AtomicBoolean cloneResult = new AtomicBoolean();
        new Task.Backgroundable(project, DvcsBundle.message((String)"cloning.repository", (Object[])new Object[]{sourceRepositoryURL})){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                cloneResult.set(GitCheckoutProvider.doClone(project, git, directoryName, parentDirectory, sourceRepositoryURL));
            }

            public void onSuccess() {
                if (!cloneResult.get()) {
                    return;
                }
                DvcsUtil.addMappingIfSubRoot((Project)project, (String)FileUtil.join((String[])new String[]{parentDirectory, directoryName}), (String)"Git");
                destinationParent.refresh(true, true, () -> {
                    if (project.isOpen() && !project.isDisposed() && !project.isDefault()) {
                        VcsDirtyScopeManager.getInstance((Project)project).fileDirty(destinationParent);
                    }
                });
                listener.directoryCheckedOut(new File(parentDirectory, directoryName), GitVcs.getKey());
                listener.checkoutCompleted();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/checkout/GitCheckoutProvider$1", "run"));
            }
        }.queue();
    }

    public static boolean doClone(@NotNull Project project, @NotNull Git git, @NotNull String directoryName, @NotNull String parentDirectory, @NotNull String sourceRepositoryURL) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(2);
        }
        if (git == null) {
            GitCheckoutProvider.$$$reportNull$$$0(3);
        }
        if (directoryName == null) {
            GitCheckoutProvider.$$$reportNull$$$0(4);
        }
        if (parentDirectory == null) {
            GitCheckoutProvider.$$$reportNull$$$0(5);
        }
        if (sourceRepositoryURL == null) {
            GitCheckoutProvider.$$$reportNull$$$0(6);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        indicator.setIndeterminate(false);
        GitLineHandlerListener progressListener = GitStandardProgressAnalyzer.createListener(indicator);
        GitCommandResult result2 = git.clone(project, new File(parentDirectory), sourceRepositoryURL, directoryName, progressListener);
        if (result2.success()) {
            return true;
        }
        String description = result2.getErrorOutput().stream().filter(msg -> !StringUtil.startsWithIgnoreCase((String)msg, (String)"Cloning into") && !StringUtil.startsWithIgnoreCase((String)msg, (String)"remote:") && !StringUtil.startsWithIgnoreCase((String)msg, (String)"submodule")).map(msg -> GitUtil.cleanupErrorPrefixes(msg)).collect(Collectors.joining("<br/>"));
        VcsNotifier.getInstance((Project)project).notifyError("Clone failed", StringUtil.capitalize((String)description), true);
        return false;
    }

    @NotNull
    public String getVcsId() {
        return "git";
    }

    public void doCheckout(@NotNull Project project, @Nullable CheckoutProvider.Listener listener) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(7);
        }
        this.doCheckout(project, listener, null);
    }

    @NotNull
    public VcsCloneComponent buildVcsCloneComponent(@NotNull Project project, @NotNull ModalityState modalityState, @NotNull VcsCloneDialogComponentStateListener dialogStateListener) {
        if (project == null) {
            GitCheckoutProvider.$$$reportNull$$$0(8);
        }
        if (modalityState == null) {
            GitCheckoutProvider.$$$reportNull$$$0(9);
        }
        if (dialogStateListener == null) {
            GitCheckoutProvider.$$$reportNull$$$0(10);
        }
        return new GitCloneDialogComponent(project, modalityState, dialogStateListener);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDirectory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceRepositoryURL";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modalityState";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dialogStateListener";
                break;
            }
        }
        objectArray2[1] = "git4idea/checkout/GitCheckoutProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doCheckout";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "clone";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "doClone";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "buildVcsCloneComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

