/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.diff.merge.MergeCallback;
import com.intellij.diff.merge.MergeResult;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.merge.MergeData;
import com.intellij.openapi.vcs.merge.MergeDialogCustomizer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.status.GitStagingAreaHolder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitMergeHandler {
    private static final Logger LOG = Logger.getInstance(GitMergeHandler.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final MergeDialogCustomizer myDialogCustomizer;

    public GitMergeHandler(@NotNull Project project, @NotNull MergeDialogCustomizer mergeDialogCustomizer) {
        if (project == null) {
            GitMergeHandler.$$$reportNull$$$0(0);
        }
        if (mergeDialogCustomizer == null) {
            GitMergeHandler.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myDialogCustomizer = mergeDialogCustomizer;
    }

    @NotNull
    public String loadMergeDescription() {
        String string = this.myDialogCustomizer.getMultipleFileMergeDescription(Collections.emptyList());
        if (string == null) {
            GitMergeHandler.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean canResolveConflict(@NotNull GitConflict conflict) {
        VirtualFile file;
        if (conflict == null) {
            GitMergeHandler.$$$reportNull$$$0(3);
        }
        if ((file = conflict.getFilePath().getVirtualFile()) == null) {
            return false;
        }
        if (file.isDirectory()) {
            return false;
        }
        return conflict.getStatus(GitConflict.ConflictSide.OURS) != GitConflict.Status.DELETED || conflict.getStatus(GitConflict.ConflictSide.THEIRS) != GitConflict.Status.DELETED;
    }

    @NotNull
    public Resolver resolveConflict(@NotNull GitConflict conflict, @NotNull VirtualFile file, boolean isReversed) throws VcsException {
        if (conflict == null) {
            GitMergeHandler.$$$reportNull$$$0(4);
        }
        if (file == null) {
            GitMergeHandler.$$$reportNull$$$0(5);
        }
        VirtualFile root = conflict.getRoot();
        FilePath path = conflict.getFilePath();
        MergeData mergeData = GitMergeUtil.loadMergeData(this.myProject, root, path, isReversed);
        String windowTitle = this.myDialogCustomizer.getMergeWindowTitle(file);
        String leftTitle = this.myDialogCustomizer.getLeftPanelTitle(file);
        String centerTitle = this.myDialogCustomizer.getCenterPanelTitle(file);
        String rightTitle = this.myDialogCustomizer.getRightPanelTitle(file, mergeData.LAST_REVISION_NUMBER);
        MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList = this.myDialogCustomizer.getTitleCustomizerList(path);
        return new Resolver(this.myProject, conflict, isReversed, file, mergeData, windowTitle, Arrays.asList(leftTitle, centerTitle, rightTitle), titleCustomizerList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acceptOneVersion(@NotNull Collection<? extends GitConflict> conflicts, @NotNull Collection<? extends VirtualFile> reversedRoots, boolean takeTheirs) throws VcsException {
        if (conflicts == null) {
            GitMergeHandler.$$$reportNull$$$0(6);
        }
        if (reversedRoots == null) {
            GitMergeHandler.$$$reportNull$$$0(7);
        }
        try {
            MultiMap<VirtualFile, GitConflict> byRoot = GitMergeHandler.groupConflictsByRoot(conflicts);
            for (VirtualFile root : byRoot.keySet()) {
                Collection rootConflicts = byRoot.get((Object)root);
                boolean isReversed = reversedRoots.contains(root);
                GitConflict.ConflictSide side = isReversed == takeTheirs ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                GitMergeUtil.acceptOneVersion(this.myProject, root, rootConflicts, side);
                GitMergeUtil.markConflictResolved(this.myProject, root, rootConflicts, side);
            }
        }
        finally {
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filePathsDirty((Collection)ContainerUtil.map(conflicts, GitConflict::getFilePath), null);
        }
    }

    @NotNull
    public static MultiMap<VirtualFile, GitConflict> groupConflictsByRoot(@NotNull Collection<? extends GitConflict> conflicts) {
        if (conflicts == null) {
            GitMergeHandler.$$$reportNull$$$0(8);
        }
        MultiMap byRoot = MultiMap.create();
        for (GitConflict gitConflict : conflicts) {
            byRoot.putValue((Object)gitConflict.getRoot(), (Object)gitConflict);
        }
        MultiMap multiMap = byRoot;
        if (multiMap == null) {
            GitMergeHandler.$$$reportNull$$$0(9);
        }
        return multiMap;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergeDialogCustomizer";
                break;
            }
            case 2: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/conflicts/GitMergeHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflict";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicts";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reversedRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/conflicts/GitMergeHandler";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "loadMergeDescription";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "groupConflictsByRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 9: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canResolveConflict";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflict";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptOneVersion";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "groupConflictsByRoot";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Resolver {
        @NotNull
        private final Project myProject;
        @NotNull
        private final GitConflict myConflict;
        private final boolean myIsReversed;
        @NotNull
        private final MergeData myMergeData;
        @NotNull
        private final VirtualFile myFile;
        @NotNull
        private final String myWindowTitle;
        @NotNull
        private final List<String> myContentTitles;
        @NotNull
        private final MergeDialogCustomizer.DiffEditorTitleCustomizerList myTitleCustomizerList;
        private volatile boolean myIsValid;

        private Resolver(@NotNull Project project, @NotNull GitConflict conflict, boolean isReversed, @NotNull VirtualFile file, @NotNull MergeData mergeData, @NotNull String windowTitle, @NotNull List<String> contentTitles, @NotNull MergeDialogCustomizer.DiffEditorTitleCustomizerList titleCustomizerList) {
            if (project == null) {
                Resolver.$$$reportNull$$$0(0);
            }
            if (conflict == null) {
                Resolver.$$$reportNull$$$0(1);
            }
            if (file == null) {
                Resolver.$$$reportNull$$$0(2);
            }
            if (mergeData == null) {
                Resolver.$$$reportNull$$$0(3);
            }
            if (windowTitle == null) {
                Resolver.$$$reportNull$$$0(4);
            }
            if (contentTitles == null) {
                Resolver.$$$reportNull$$$0(5);
            }
            if (titleCustomizerList == null) {
                Resolver.$$$reportNull$$$0(6);
            }
            this.myIsValid = true;
            this.myProject = project;
            this.myConflict = conflict;
            this.myIsReversed = isReversed;
            this.myMergeData = mergeData;
            this.myFile = file;
            this.myWindowTitle = windowTitle;
            this.myContentTitles = contentTitles;
            this.myTitleCustomizerList = titleCustomizerList;
        }

        @NotNull
        public Project getProject() {
            Project project = this.myProject;
            if (project == null) {
                Resolver.$$$reportNull$$$0(7);
            }
            return project;
        }

        @NotNull
        public VirtualFile getVirtualFile() {
            VirtualFile virtualFile = this.myFile;
            if (virtualFile == null) {
                Resolver.$$$reportNull$$$0(8);
            }
            return virtualFile;
        }

        @NotNull
        public MergeData getMergeData() {
            MergeData mergeData = this.myMergeData;
            if (mergeData == null) {
                Resolver.$$$reportNull$$$0(9);
            }
            return mergeData;
        }

        public void onConflictResolved(@NotNull MergeResult result2) {
            if (result2 == null) {
                Resolver.$$$reportNull$$$0(10);
            }
            if (result2 != MergeResult.CANCEL) {
                try {
                    GitMergeUtil.markConflictResolved(this.myProject, this.myConflict.getRoot(), Collections.singletonList(this.myConflict), this.getResolutionSide(result2));
                }
                catch (VcsException e) {
                    LOG.error(String.format("Unexpected exception during the git operation: file - %s)", this.myConflict.getFilePath()), (Throwable)e);
                }
            }
            VcsDirtyScopeManager.getInstance((Project)this.myProject).filesDirty(Collections.singletonList(this.myFile), Collections.emptyList());
        }

        @Nullable
        private GitConflict.ConflictSide getResolutionSide(@NotNull MergeResult result2) {
            if (result2 == null) {
                Resolver.$$$reportNull$$$0(11);
            }
            switch (result2) {
                case LEFT: {
                    return !this.myIsReversed ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                }
                case RIGHT: {
                    return this.myIsReversed ? GitConflict.ConflictSide.OURS : GitConflict.ConflictSide.THEIRS;
                }
            }
            return null;
        }

        @NotNull
        public String getWindowTitle() {
            String string = this.myWindowTitle;
            if (string == null) {
                Resolver.$$$reportNull$$$0(12);
            }
            return string;
        }

        @NotNull
        public List<String> getContentTitles() {
            List<String> list = this.myContentTitles;
            if (list == null) {
                Resolver.$$$reportNull$$$0(13);
            }
            return list;
        }

        @NotNull
        public MergeDialogCustomizer.DiffEditorTitleCustomizerList getTitleCustomizerList() {
            MergeDialogCustomizer.DiffEditorTitleCustomizerList diffEditorTitleCustomizerList = this.myTitleCustomizerList;
            if (diffEditorTitleCustomizerList == null) {
                Resolver.$$$reportNull$$$0(14);
            }
            return diffEditorTitleCustomizerList;
        }

        public boolean checkIsValid() {
            if (this.myIsValid) {
                GitRepository repository = (GitRepository)GitRepositoryManager.getInstance(this.myProject).getRepositoryForRootQuick(this.myConflict.getRoot());
                if (repository == null) {
                    return true;
                }
                this.myIsValid = repository.getStagingAreaHolder().findConflict(this.myConflict.getFilePath()) != null;
            }
            return this.myIsValid;
        }

        public void addListener(@NotNull MergeCallback.Listener listener, @NotNull Disposable disposable) {
            if (listener == null) {
                Resolver.$$$reportNull$$$0(15);
            }
            if (disposable == null) {
                Resolver.$$$reportNull$$$0(16);
            }
            this.myProject.getMessageBus().connect(disposable).subscribe(GitStagingAreaHolder.TOPIC, repo -> {
                if (this.myIsValid && this.myConflict.getRoot().equals(repo.getRoot()) && !this.checkIsValid()) {
                    listener.fireConflictInvalid();
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "conflict";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "mergeData";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "windowTitle";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentTitles";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "titleCustomizerList";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/conflicts/GitMergeHandler$Resolver";
                    break;
                }
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "result";
                    break;
                }
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "listener";
                    break;
                }
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "disposable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/conflicts/GitMergeHandler$Resolver";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProject";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVirtualFile";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMergeData";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getWindowTitle";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContentTitles";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTitleCustomizerList";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "onConflictResolved";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getResolutionSide";
                    break;
                }
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addListener";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 7: 
                case 8: 
                case 9: 
                case 12: 
                case 13: 
                case 14: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

