/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScreenUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.TimerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.DefaultMenuLayout;
import org.jetbrains.annotations.NotNull;

public class JBPopupMenu
extends JPopupMenu {
    private static final Logger LOG = Logger.getInstance(JBPopupMenu.class);
    private final MyLayout myLayout;

    public JBPopupMenu() {
        this(null);
    }

    public JBPopupMenu(String label) {
        super(label);
        this.enableEvents(131088L);
        this.myLayout = new MyLayout(this);
        this.setLayout(this.myLayout);
        this.setLightWeightPopupEnabled(false);
    }

    @Override
    public void processMouseWheelEvent(MouseWheelEvent e) {
        if (!this.isShowing()) {
            return;
        }
        int rotation = e.getWheelRotation();
        if (rotation == 0) {
            return;
        }
        if (e.getComponent() != this) {
            e = (MouseWheelEvent)SwingUtilities.convertMouseEvent(e.getComponent(), e, this);
        }
        Point p = e.getPoint();
        SwingUtilities.convertPointToScreen(p, this);
        Point tPoint = this.getLocationOnScreen();
        if (p.x >= tPoint.x && p.x <= tPoint.x + this.getWidth() && p.y >= tPoint.y && p.y <= tPoint.y + this.getHeight()) {
            this.myLayout.updateShift(rotation * 10);
        }
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (!(mgr instanceof MyLayout)) {
            return;
        }
        super.setLayout(mgr);
    }

    @Override
    public void paint(Graphics g) {
        GraphicsUtil.setupAntialiasing((Graphics)g);
        super.paint(g);
        LayoutManager layout = this.getLayout();
        if (layout instanceof MyLayout) {
            ((MyLayout)layout).paintIfNeeded(g);
        }
    }

    public static void showAbove(@NotNull Component component, @NotNull JPopupMenu menu) {
        if (component == null) {
            JBPopupMenu.$$$reportNull$$$0(0);
        }
        if (menu == null) {
            JBPopupMenu.$$$reportNull$$$0(1);
        }
        menu.show(component, 0, 0);
        UiNotifyConnector.doWhenFirstShown(menu, () -> {
            Window window = UIUtil.getWindow((Component)menu);
            if (window == null) {
                LOG.error("Cannot find window for menu popup " + menu + ", " + menu.isShowing());
            } else {
                Point diff = SwingUtilities.convertPoint(component, 0, 0, window);
                window.setLocation(window.getX(), window.getY() + diff.y - window.getHeight());
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "component";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "menu";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/ui/JBPopupMenu";
        objectArray[2] = "showAbove";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLayout
    extends DefaultMenuLayout
    implements ActionListener {
        private final JPopupMenu myTarget;
        int myShift = 0;
        int myScrollDirection = 0;
        Timer myTimer;
        private final Color[] dim = new Color[]{JBColor.background(), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.9), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.8), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.7), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.6), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.5), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.4), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.3), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.2), ColorUtil.withAlpha((Color)JBColor.background(), (double)0.1)};

        MyLayout(final JPopupMenu target) {
            super(target, 3);
            this.myTarget = target;
            this.myTimer = TimerUtil.createNamedTimer((String)"PopupTimer", (int)40, (ActionListener)this);
            this.myTarget.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    this.switchTimer(true);
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    this.switchTimer(false);
                    JRootPane rootPane = SwingUtilities.getRootPane(target);
                    if (rootPane != null) {
                        rootPane.putClientProperty("apple.awt._windowFadeDelegate", null);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                    this.switchTimer(false);
                }
            });
            if (this.myTarget.isVisible()) {
                this.switchTimer(true);
            }
        }

        private void switchTimer(boolean on) {
            if (on && !this.myTimer.isRunning()) {
                this.myTimer.start();
            }
            if (!on && this.myTimer.isRunning()) {
                this.myTimer.stop();
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!this.myTarget.isShowing()) {
                return;
            }
            PointerInfo info = MouseInfo.getPointerInfo();
            if (info == null) {
                return;
            }
            Point mouseLocation = info.getLocation();
            Point targetLocation = this.myTarget.getLocationOnScreen();
            if (mouseLocation.x < targetLocation.x || mouseLocation.x > targetLocation.x + this.myTarget.getWidth()) {
                return;
            }
            if (Math.abs(mouseLocation.y - targetLocation.y - this.getMaxHeight()) < 10) {
                this.myScrollDirection = 1;
            } else if (Math.abs(mouseLocation.y - targetLocation.y) < 10) {
                this.myScrollDirection = -1;
            } else {
                return;
            }
            SwingUtilities.convertPointFromScreen(mouseLocation, this.myTarget);
            this.myTarget.dispatchEvent(new MouseEvent(this.myTarget, 504, System.currentTimeMillis(), 0, mouseLocation.x, mouseLocation.y, 0, false));
            this.updateShift(5 * this.myScrollDirection);
        }

        private void updateShift(int increment) {
            int maxHeight = super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight();
            int newShift = Math.max(0, Math.min(maxHeight, this.myShift + increment));
            if (newShift != this.myShift) {
                this.myShift = newShift;
                this.myTarget.revalidate();
                this.myTarget.repaint();
                Window w = ComponentUtil.getWindow((Component)this.myTarget.getComponent());
                if (w != null) {
                    for (Window window : w.getOwnedWindows()) {
                        window.dispose();
                    }
                }
            }
        }

        public void paintIfNeeded(Graphics g) {
            int i;
            if (this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, i, this.myTarget.getWidth(), i);
                }
                AllIcons.General.ArrowUp.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.ArrowUp.getIconWidth() / 2, 0);
            }
            if (super.preferredLayoutSize((Container)this.myTarget).height - this.getMaxHeight() - this.myShift > 0) {
                for (i = 0; i < this.dim.length; ++i) {
                    g.setColor(this.dim[i]);
                    g.drawLine(0, this.myTarget.getHeight() - i, this.myTarget.getWidth(), this.myTarget.getHeight() - i);
                }
                AllIcons.General.ArrowDown.paintIcon(this.myTarget, g, this.myTarget.getWidth() / 2 - AllIcons.General.ArrowDown.getIconWidth() / 2, this.myTarget.getHeight() - AllIcons.General.ArrowDown.getIconHeight());
            }
        }

        @Override
        public void layoutContainer(Container target) {
            Insets insets = target.getInsets();
            int width = target.getWidth() - insets.left - insets.right;
            Component[] components = target.getComponents();
            int y = -this.myShift + insets.top;
            for (Component component : components) {
                int height = component.getPreferredSize().height;
                component.setBounds(insets.left, y, width, height);
                y += height;
            }
        }

        private int getMaxHeight() {
            GraphicsConfiguration configuration = this.myTarget.getGraphicsConfiguration();
            if (configuration == null && this.myTarget.getInvoker() != null) {
                configuration = this.myTarget.getInvoker().getGraphicsConfiguration();
            }
            if (configuration == null) {
                return Short.MAX_VALUE;
            }
            Rectangle screenRectangle = ScreenUtil.getScreenRectangle((GraphicsConfiguration)configuration);
            return screenRectangle.height;
        }

        @Override
        @NotNull
        public Dimension preferredLayoutSize(Container target) {
            Dimension dimension = super.preferredLayoutSize(target);
            int maxHeight = this.getMaxHeight();
            this.switchTimer(dimension.height > maxHeight);
            dimension.height = Math.min(maxHeight, dimension.height);
            Dimension dimension2 = dimension;
            if (dimension2 == null) {
                MyLayout.$$$reportNull$$$0(0);
            }
            return dimension2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/JBPopupMenu$MyLayout", "preferredLayoutSize"));
        }
    }
}

