/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.projectImport;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VirtualFile;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectOpenProcessor {
    public static final ExtensionPointName<ProjectOpenProcessor> EXTENSION_POINT_NAME = new ExtensionPointName("com.intellij.projectOpenProcessor");

    @NotNull
    @Nls
    public abstract String getName();

    @Nullable
    public Icon getIcon() {
        return null;
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(0);
        }
        return this.getIcon();
    }

    public abstract boolean canOpenProject(@NotNull VirtualFile var1);

    public boolean isProjectFile(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(1);
        }
        return this.canOpenProject(file);
    }

    @Messages.YesNoCancelResult
    public int askConfirmationForOpeningProject(@NotNull VirtualFile file, @Nullable Project project) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(2);
        }
        return Messages.showYesNoCancelDialog(project, IdeBundle.message("message.open.file.is.project", file.getName()), IdeBundle.message("title.open.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.project", new Object[0]), IdeBundle.message("message.open.file.is.project.open.as.file", new Object[0]), IdeBundle.message("button.cancel", new Object[0]), Messages.getQuestionIcon());
    }

    @Nullable
    public abstract Project doOpenProject(@NotNull VirtualFile var1, @Nullable Project var2, boolean var3);

    public boolean lookForProjectsInDirectory() {
        return true;
    }

    public boolean canImportProjectAfterwards() {
        return false;
    }

    public void importProjectAfterwards(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(3);
        }
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(4);
        }
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(5);
        }
        return ProjectOpenProcessor.getImportProvider(file, false);
    }

    @Nullable
    public static ProjectOpenProcessor getImportProvider(@NotNull VirtualFile file, boolean onlyIfExistingProjectFile) {
        if (file == null) {
            ProjectOpenProcessor.$$$reportNull$$$0(6);
        }
        return (ProjectOpenProcessor)EXTENSION_POINT_NAME.findFirstSafe(provider -> provider.canOpenProject(file) && (!onlyIfExistingProjectFile || provider.isProjectFile(file)));
    }

    public boolean isStrongProjectInfoHolder() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/projectImport/ProjectOpenProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIcon";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isProjectFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "askConfirmationForOpeningProject";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "importProjectAfterwards";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportProvider";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

