/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionToolbarPosition;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ListToolbarDecorator;
import com.intellij.ui.TableToolbarDecorator;
import com.intellij.ui.TreeToolbarDecorator;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBViewport;
import com.intellij.ui.table.TableView;
import com.intellij.util.SmartList;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolbarDecorator
implements CommonActionsPanel.ListenerFactory {
    protected Border myPanelBorder;
    protected Border myToolbarBorder;
    protected Border myScrollPaneBorder;
    protected boolean myAddActionEnabled;
    protected boolean myEditActionEnabled;
    protected boolean myRemoveActionEnabled;
    protected boolean myUpActionEnabled;
    protected boolean myDownActionEnabled;
    private final List<AnActionButton> myExtraActions = new SmartList();
    private ActionToolbarPosition myToolbarPosition;
    protected AnActionButtonRunnable myAddAction;
    protected AnActionButtonRunnable myEditAction;
    protected AnActionButtonRunnable myRemoveAction;
    protected AnActionButtonRunnable myUpAction;
    protected AnActionButtonRunnable myDownAction;
    private String myAddName;
    private String myEditName;
    private String myRemoveName;
    private String myMoveUpName;
    private String myMoveDownName;
    private AnActionButtonUpdater myAddActionUpdater;
    private AnActionButtonUpdater myRemoveActionUpdater;
    private AnActionButtonUpdater myEditActionUpdater;
    private AnActionButtonUpdater myMoveUpActionUpdater;
    private AnActionButtonUpdater myMoveDownActionUpdater;
    private Dimension myPreferredSize;
    private Dimension myMinimumSize;
    private CommonActionsPanel myActionsPanel;
    private Comparator<? super AnActionButton> myButtonComparator;
    private Icon myAddIcon;
    private boolean myForcedDnD;

    @NotNull
    protected abstract JComponent getComponent();

    protected abstract void updateButtons();

    protected void updateExtraElementActions(boolean someElementSelected) {
        for (AnActionButton action : this.myExtraActions) {
            if (!(action instanceof ElementActionButton)) continue;
            action.setEnabled(someElementSelected);
        }
    }

    public final CommonActionsPanel getActionsPanel() {
        return this.myActionsPanel;
    }

    @NotNull
    public ToolbarDecorator initPosition() {
        this.setToolbarPosition(SystemInfo.isMac ? ActionToolbarPosition.BOTTOM : ActionToolbarPosition.RIGHT);
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(0);
        }
        return toolbarDecorator;
    }

    @Deprecated
    public ToolbarDecorator setAsUsualTopToolbar() {
        return this.setToolbarPosition(ActionToolbarPosition.TOP).setPanelBorder((Border)JBUI.Borders.empty());
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTable table) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(1);
        }
        ToolbarDecorator toolbarDecorator = new TableToolbarDecorator(table, null).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(2);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static ToolbarDecorator createDecorator(@NotNull JTree tree) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(3);
        }
        return ToolbarDecorator.createDecorator(tree, null);
    }

    @NotNull
    private static ToolbarDecorator createDecorator(@NotNull JTree tree, @Nullable ElementProducer<?> producer) {
        if (tree == null) {
            ToolbarDecorator.$$$reportNull$$$0(4);
        }
        ToolbarDecorator toolbarDecorator = new TreeToolbarDecorator(tree, producer).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(5);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(6);
        }
        ToolbarDecorator toolbarDecorator = new ListToolbarDecorator<T>(list, null).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(7);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull JList<T> list, EditableModel editableModel) {
        if (list == null) {
            ToolbarDecorator.$$$reportNull$$$0(8);
        }
        ToolbarDecorator toolbarDecorator = new ListToolbarDecorator<T>(list, editableModel).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(9);
        }
        return toolbarDecorator;
    }

    @NotNull
    public static <T> ToolbarDecorator createDecorator(@NotNull TableView<T> table, @Nullable ElementProducer<T> producer) {
        if (table == null) {
            ToolbarDecorator.$$$reportNull$$$0(10);
        }
        ToolbarDecorator toolbarDecorator = new TableToolbarDecorator(table, producer).initPosition();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(11);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableAddAction() {
        ToolbarDecorator toolbarDecorator = this.setAddAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(12);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableRemoveAction() {
        ToolbarDecorator toolbarDecorator = this.setRemoveAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(13);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableUpAction() {
        ToolbarDecorator toolbarDecorator = this.setMoveUpAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(14);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableUpDownActions() {
        this.disableUpAction();
        ToolbarDecorator toolbarDecorator = this.disableDownAction();
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(15);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator disableDownAction() {
        ToolbarDecorator toolbarDecorator = this.setMoveDownAction(null);
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(16);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setPanelBorder(Border border) {
        this.myPanelBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(17);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setToolbarBorder(Border border) {
        this.myToolbarBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(18);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setScrollPaneBorder(Border border) {
        this.myScrollPaneBorder = border;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(19);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setButtonComparator(Comparator<? super AnActionButton> buttonComparator) {
        this.myButtonComparator = buttonComparator;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(20);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setButtonComparator(String ... actionNames) {
        if (actionNames == null) {
            ToolbarDecorator.$$$reportNull$$$0(21);
        }
        List<String> names = Arrays.asList(actionNames);
        this.myButtonComparator = (o1, o2) -> {
            String t1 = o1.getTemplatePresentation().getText();
            String t2 = o2.getTemplatePresentation().getText();
            if (t1 == null || t2 == null) {
                return 0;
            }
            int ind1 = names.indexOf(t1);
            int ind2 = names.indexOf(t2);
            if (ind1 == -1 && ind2 >= 0) {
                return 1;
            }
            if (ind2 == -1 && ind1 >= 0) {
                return -1;
            }
            return ind1 - ind2;
        };
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(22);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator addExtraAction(@NotNull AnActionButton action) {
        if (action == null) {
            ToolbarDecorator.$$$reportNull$$$0(23);
        }
        this.myExtraActions.add(action);
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(24);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator addExtraActions(AnActionButton ... actions) {
        if (actions == null) {
            ToolbarDecorator.$$$reportNull$$$0(25);
        }
        for (AnActionButton action : actions) {
            if (action == null) continue;
            this.addExtraAction(action);
        }
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(26);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setToolbarPosition(ActionToolbarPosition position) {
        this.myToolbarPosition = position;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(27);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddAction(AnActionButtonRunnable action) {
        this.myAddActionEnabled = action != null;
        this.myAddAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(28);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditAction(AnActionButtonRunnable action) {
        this.myEditActionEnabled = action != null;
        this.myEditAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(29);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveAction(AnActionButtonRunnable action) {
        this.myRemoveActionEnabled = action != null;
        this.myRemoveAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(30);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpAction(AnActionButtonRunnable action) {
        this.myUpActionEnabled = action != null;
        this.myUpAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(31);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownAction(AnActionButtonRunnable action) {
        this.myDownActionEnabled = action != null;
        this.myDownAction = action;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(32);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddActionName(@NlsActions.ActionText String name) {
        this.myAddName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(33);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditActionName(@NlsActions.ActionText String name) {
        this.myEditName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(34);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionName(@NlsActions.ActionText String name) {
        this.myRemoveName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(35);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionName(@NlsActions.ActionText String name) {
        this.myMoveUpName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(36);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionName(@NlsActions.ActionText String name) {
        this.myMoveDownName = name;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(37);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddActionUpdater(AnActionButtonUpdater updater) {
        this.myAddActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(38);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setRemoveActionUpdater(AnActionButtonUpdater updater) {
        this.myRemoveActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(39);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setEditActionUpdater(AnActionButtonUpdater updater) {
        this.myEditActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(40);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveUpActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveUpActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(41);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMoveDownActionUpdater(AnActionButtonUpdater updater) {
        this.myMoveDownActionUpdater = updater;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(42);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setForcedDnD() {
        this.myForcedDnD = true;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(43);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setActionGroup(@NotNull ActionGroup actionGroup) {
        AnAction[] actions;
        if (actionGroup == null) {
            ToolbarDecorator.$$$reportNull$$$0(44);
        }
        for (AnAction action : actions = actionGroup.getChildren(null)) {
            if (action instanceof Separator) continue;
            this.addExtraAction(AnActionButton.fromAction(action));
        }
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(45);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setPreferredSize(Dimension size) {
        this.myPreferredSize = size;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(46);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setMinimumSize(Dimension size) {
        this.myMinimumSize = size;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(47);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setVisibleRowCount(int rowCount) {
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(48);
        }
        return toolbarDecorator;
    }

    @NotNull
    public ToolbarDecorator setAddIcon(Icon addIcon) {
        this.myAddIcon = addIcon;
        ToolbarDecorator toolbarDecorator = this;
        if (toolbarDecorator == null) {
            ToolbarDecorator.$$$reportNull$$$0(49);
        }
        return toolbarDecorator;
    }

    @NotNull
    public JPanel createPanel() {
        CommonActionsPanel.Buttons[] buttons = this.getButtons();
        JComponent contextComponent = this.getComponent();
        UIUtil.putClientProperty((JComponent)contextComponent, JBViewport.FORCE_VISIBLE_ROW_COUNT_KEY, (Object)true);
        this.myActionsPanel = new CommonActionsPanel(this, contextComponent, this.myToolbarPosition, this.myExtraActions.toArray(new AnActionButton[0]), this.myButtonComparator, this.myAddName, this.myRemoveName, this.myMoveUpName, this.myMoveDownName, this.myEditName, this.myAddIcon, buttons);
        JBScrollPane scrollPane = new JBScrollPane(contextComponent){

            @Override
            public Dimension getPreferredSize() {
                Dimension preferredSize = super.getPreferredSize();
                if (!this.isPreferredSizeSet()) {
                    this.setPreferredSize(new Dimension(0, preferredSize.height));
                }
                return preferredSize;
            }
        };
        scrollPane.setBorder((Border)JBUI.Borders.empty());
        scrollPane.setViewportBorder((Border)JBUI.Borders.empty());
        if (this.myPreferredSize != null) {
            scrollPane.setPreferredSize(this.myPreferredSize);
        }
        if (this.myMinimumSize != null) {
            scrollPane.setMinimumSize(this.myMinimumSize);
        }
        JPanel panel2 = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                ToolbarDecorator.this.updateButtons();
            }
        };
        panel2.add((Component)scrollPane, "Center");
        panel2.add((Component)this.myActionsPanel, ToolbarDecorator.getPlacement(this.myToolbarPosition));
        this.installUpdaters();
        this.updateButtons();
        this.installDnD();
        panel2.putClientProperty("ACTION_TOOLBAR", this.myActionsPanel.getComponent(0));
        panel2.setBorder(this.myPanelBorder != null ? this.myPanelBorder : IdeBorderFactory.createBorder(15));
        if (this.myScrollPaneBorder != null || this.myPanelBorder instanceof EmptyBorder) {
            scrollPane.setBorder(this.myScrollPaneBorder != null ? this.myScrollPaneBorder : IdeBorderFactory.createBorder(15));
        }
        if ((this.myToolbarBorder == null || this.myToolbarBorder instanceof EmptyBorder) && scrollPane.getBorder() == null || scrollPane.getBorder() instanceof EmptyBorder) {
            this.myToolbarBorder = new CustomLineBorder(this.myToolbarPosition == ActionToolbarPosition.BOTTOM ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.RIGHT ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.TOP ? 1 : 0, this.myToolbarPosition == ActionToolbarPosition.LEFT ? 1 : 0);
        }
        this.myActionsPanel.setBorder(this.myToolbarBorder != null ? this.myToolbarBorder : JBUI.Borders.empty());
        JPanel jPanel = panel2;
        if (jPanel == null) {
            ToolbarDecorator.$$$reportNull$$$0(50);
        }
        return jPanel;
    }

    private void installUpdaters() {
        if (this.myAddActionEnabled && this.myAddAction != null && this.myAddActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.ADD).addCustomUpdater(this.myAddActionUpdater);
        }
        if (this.myEditActionEnabled && this.myEditAction != null && this.myEditActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.EDIT).addCustomUpdater(this.myEditActionUpdater);
        }
        if (this.myRemoveActionEnabled && this.myRemoveAction != null && this.myRemoveActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.REMOVE).addCustomUpdater(this.myRemoveActionUpdater);
        }
        if (this.myUpActionEnabled && this.myUpAction != null && this.myMoveUpActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.UP).addCustomUpdater(this.myMoveUpActionUpdater);
        }
        if (this.myDownActionEnabled && this.myDownAction != null && this.myMoveDownActionUpdater != null) {
            this.myActionsPanel.getAnActionButton(CommonActionsPanel.Buttons.DOWN).addCustomUpdater(this.myMoveDownActionUpdater);
        }
    }

    protected void installDnD() {
        if ((this.myForcedDnD || this.myUpAction != null && this.myUpActionEnabled && this.myDownAction != null && this.myDownActionEnabled) && !ApplicationManager.getApplication().isHeadlessEnvironment() && this.isModelEditable()) {
            this.installDnDSupport();
        }
    }

    protected abstract void installDnDSupport();

    protected abstract boolean isModelEditable();

    @NotNull
    static Object getPlacement(@NotNull ActionToolbarPosition position) {
        if (position == null) {
            ToolbarDecorator.$$$reportNull$$$0(51);
        }
        switch (position) {
            case TOP: {
                return "North";
            }
            case LEFT: {
                return "West";
            }
            case BOTTOM: {
                return "South";
            }
            case RIGHT: {
                return "East";
            }
        }
        return "South";
    }

    private CommonActionsPanel.Buttons @NotNull [] getButtons() {
        ArrayList<CommonActionsPanel.Buttons> buttons = new ArrayList<CommonActionsPanel.Buttons>();
        HashMap<CommonActionsPanel.Buttons, Pair> map = new HashMap<CommonActionsPanel.Buttons, Pair>();
        map.put(CommonActionsPanel.Buttons.ADD, Pair.create((Object)this.myAddActionEnabled, (Object)this.myAddAction));
        map.put(CommonActionsPanel.Buttons.REMOVE, Pair.create((Object)this.myRemoveActionEnabled, (Object)this.myRemoveAction));
        map.put(CommonActionsPanel.Buttons.EDIT, Pair.create((Object)this.myEditActionEnabled, (Object)this.myEditAction));
        map.put(CommonActionsPanel.Buttons.UP, Pair.create((Object)this.myUpActionEnabled, (Object)this.myUpAction));
        map.put(CommonActionsPanel.Buttons.DOWN, Pair.create((Object)this.myDownActionEnabled, (Object)this.myDownAction));
        for (CommonActionsPanel.Buttons button : CommonActionsPanel.Buttons.values()) {
            Pair action = (Pair)map.get((Object)button);
            if (action == null || action.first == null || !((Boolean)action.first).booleanValue() || action.second == null) continue;
            buttons.add(button);
        }
        CommonActionsPanel.Buttons[] buttonsArray = buttons.toArray(new CommonActionsPanel.Buttons[0]);
        if (buttonsArray == null) {
            ToolbarDecorator.$$$reportNull$$$0(52);
        }
        return buttonsArray;
    }

    @Override
    @NotNull
    public CommonActionsPanel.Listener createListener(final @NotNull CommonActionsPanel panel2) {
        if (panel2 == null) {
            ToolbarDecorator.$$$reportNull$$$0(53);
        }
        return new CommonActionsPanel.Listener(){

            @Override
            public void doAdd() {
                if (ToolbarDecorator.this.myAddAction != null) {
                    ToolbarDecorator.this.myAddAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.ADD));
                }
            }

            @Override
            public void doEdit() {
                if (ToolbarDecorator.this.myEditAction != null) {
                    ToolbarDecorator.this.myEditAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.EDIT));
                }
            }

            @Override
            public void doRemove() {
                if (ToolbarDecorator.this.myRemoveAction != null) {
                    ToolbarDecorator.this.myRemoveAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.REMOVE));
                }
            }

            @Override
            public void doUp() {
                if (ToolbarDecorator.this.myUpAction != null) {
                    ToolbarDecorator.this.myUpAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.UP));
                }
            }

            @Override
            public void doDown() {
                if (ToolbarDecorator.this.myDownAction != null) {
                    ToolbarDecorator.this.myDownAction.run(panel2.getAnActionButton(CommonActionsPanel.Buttons.DOWN));
                }
            }
        };
    }

    @Nullable
    public static AnActionButton findAddButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(54);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.ADD);
    }

    @Nullable
    public static AnActionButton findEditButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(55);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.EDIT);
    }

    @Nullable
    public static AnActionButton findRemoveButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(56);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.REMOVE);
    }

    @Nullable
    public static AnActionButton findUpButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(57);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.UP);
    }

    @Nullable
    public static AnActionButton findDownButton(@NotNull JComponent container) {
        if (container == null) {
            ToolbarDecorator.$$$reportNull$$$0(58);
        }
        return ToolbarDecorator.findButton(container, CommonActionsPanel.Buttons.DOWN);
    }

    @Nullable
    private static AnActionButton findButton(JComponent comp, CommonActionsPanel.Buttons type) {
        CommonActionsPanel panel2 = (CommonActionsPanel)UIUtil.findComponentOfType((JComponent)comp, CommonActionsPanel.class);
        if (panel2 != null) {
            return panel2.getAnActionButton(type);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 44: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 44: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionNames";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionGroup";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "initPosition";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 44: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/ToolbarDecorator";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "createDecorator";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "disableAddAction";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "disableRemoveAction";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpAction";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpDownActions";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "disableDownAction";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "setPanelBorder";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolbarBorder";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "setScrollPaneBorder";
                break;
            }
            case 20: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "setButtonComparator";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraAction";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "addExtraActions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "setToolbarPosition";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddAction";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditAction";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveAction";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpAction";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownAction";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddActionName";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditActionName";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveActionName";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpActionName";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownActionName";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddActionUpdater";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "setRemoveActionUpdater";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "setEditActionUpdater";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveUpActionUpdater";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "setMoveDownActionUpdater";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "setForcedDnD";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "setActionGroup";
                break;
            }
            case 46: {
                objectArray = objectArray2;
                objectArray2[1] = "setPreferredSize";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "setMinimumSize";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "setVisibleRowCount";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "setAddIcon";
                break;
            }
            case 50: {
                objectArray = objectArray2;
                objectArray2[1] = "createPanel";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "getButtons";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createDecorator";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setButtonComparator";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addExtraAction";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "addExtraActions";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "setActionGroup";
                break;
            }
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "getPlacement";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "findAddButton";
                break;
            }
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "findEditButton";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "findRemoveButton";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "findUpButton";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findDownButton";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 21: 
            case 23: 
            case 25: 
            case 44: 
            case 51: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static abstract class ElementActionButton
    extends AnActionButton {
        public ElementActionButton(@NlsContexts.Button String text, @NlsContexts.Tooltip String description, @Nullable Icon icon) {
            super(text, description, icon);
        }

        public ElementActionButton(@NlsContexts.Button String text, Icon icon) {
            super(text, icon);
        }

        public ElementActionButton() {
        }

        public ElementActionButton(@NlsContexts.Button String text) {
            super(text);
        }
    }
}

