/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.vcs.actions.VcsContext;
import com.intellij.vcsUtil.VcsSelection;
import com.intellij.vcsUtil.VcsSelectionProvider;
import org.jetbrains.annotations.Nullable;

public final class VcsSelectionUtil {
    private VcsSelectionUtil() {
    }

    @Nullable
    public static VcsSelection getSelection(VcsContext context) {
        Editor editor = context.getEditor();
        if (editor == null) {
            return null;
        }
        SelectionModel selectionModel = editor.getSelectionModel();
        if (!selectionModel.hasSelection()) {
            for (VcsSelectionProvider provider : VcsSelectionProvider.EP_NAME.getExtensionList()) {
                try {
                    VcsSelection vcsSelection = provider.getSelection(context);
                    if (vcsSelection == null) continue;
                    return vcsSelection;
                }
                catch (IndexNotReadyException indexNotReadyException) {
                }
            }
        }
        return new VcsSelection(editor.getDocument(), selectionModel);
    }
}

