/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupEvent;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.stats.completion.CompletionActionsListener;
import com.intellij.stats.completion.CompletionLogger;
import com.intellij.stats.completion.DeferredLog;
import com.intellij.stats.experiment.WebServiceStatus;
import com.intellij.stats.storage.factors.LookupStorage;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0011H\u0016J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0017\u001a\u00020\u0011H\u0016J\b\u0010\u0018\u001a\u00020\u0011H\u0016J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0011H\u0016J\b\u0010\u001d\u001a\u00020\fH\u0002J\u0012\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u0002J\u0010\u0010!\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\"\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010#\u001a\u00020\u0011H\u0016R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/intellij/stats/completion/CompletionActionsTracker;", "Lcom/intellij/stats/completion/CompletionActionsListener;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "lookupStorage", "Lcom/intellij/stats/storage/factors/LookupStorage;", "logger", "Lcom/intellij/stats/completion/CompletionLogger;", "experimentHelper", "Lcom/intellij/stats/experiment/WebServiceStatus;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/stats/storage/factors/LookupStorage;Lcom/intellij/stats/completion/CompletionLogger;Lcom/intellij/stats/experiment/WebServiceStatus;)V", "completionStarted", "", "deferredLog", "Lcom/intellij/stats/completion/DeferredLog;", "selectedByDotTyping", "afterAppend", "", "c", "", "afterBackspacePressed", "beforeBackspacePressed", "beforeCharTyped", "beforeDownPressed", "beforeUpPressed", "currentItemChanged", "event", "Lcom/intellij/codeInsight/lookup/LookupEvent;", "downPressed", "isCompletionActive", "isSelectedByTyping", "item", "Lcom/intellij/codeInsight/lookup/LookupElement;", "itemSelected", "lookupCanceled", "upPressed", "intellij.statsCollector"})
public final class CompletionActionsTracker
implements CompletionActionsListener {
    private boolean completionStarted;
    private boolean selectedByDotTyping;
    private final DeferredLog deferredLog;
    private final LookupImpl lookup;
    private final LookupStorage lookupStorage;
    private final CompletionLogger logger;
    private final WebServiceStatus experimentHelper;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCompletionActive() {
        if (this.completionStarted) {
            if (!this.lookup.isLookupDisposed()) return true;
        }
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    public void lookupCanceled(@NotNull LookupEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        LookupElement currentItem = this.lookup.getCurrentItem();
        Map<String, Long> performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (this.isSelectedByTyping(currentItem) || this.selectedByDotTyping) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.completionCancelled(performance, timestamp);
        }
    }

    public void currentItemChanged(@NotNull LookupEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.completionStarted = true;
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                boolean isPerformExperiment = CompletionActionsTracker.access$getExperimentHelper$p(this.this$0).isExperimentOnCurrentIDE();
                int experimentVersion = CompletionActionsTracker.access$getExperimentHelper$p(this.this$0).experimentVersion();
                CompletionActionsTracker.access$getLogger$p(this.this$0).completionStarted(CompletionActionsTracker.access$getLookup$p(this.this$0), isPerformExperiment, experimentVersion, this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    public void itemSelected(@NotNull LookupEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        if (!this.completionStarted) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        Map<String, Long> performance = this.lookupStorage.getPerformanceTracker().measurements();
        if (this.isSelectedByTyping(this.lookup.getCurrentItem())) {
            this.logger.itemSelectedByTyping(this.lookup, performance, timestamp);
        } else {
            this.logger.itemSelectedCompletionFinished(this.lookup, performance, timestamp);
        }
    }

    @Override
    public void beforeDownPressed() {
        this.deferredLog.log();
    }

    @Override
    public void downPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).downPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeUpPressed() {
        this.deferredLog.log();
    }

    @Override
    public void upPressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).upPressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        this.deferredLog.log();
    }

    @Override
    public void afterBackspacePressed() {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterBackspacePressed(CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    @Override
    public void beforeCharTyped(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        if (c == '.') {
            LookupElement item = this.lookup.getCurrentItem();
            if (item == null) {
                this.logger.customMessage("Before typed " + c + " lookup.currentItem is null; lookup size: " + this.lookup.getItems().size(), timestamp);
                return;
            }
            String string = this.lookup.itemPattern(item);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lookup.itemPattern(item)");
            String text = string;
            if (Intrinsics.areEqual((Object)item.getLookupString(), (Object)text)) {
                this.selectedByDotTyping = true;
            }
        }
    }

    public void afterAppend(char c) {
        if (!this.isCompletionActive()) {
            return;
        }
        long timestamp = System.currentTimeMillis();
        this.deferredLog.log();
        this.deferredLog.defer((Function0<Unit>)((Function0)new Function0<Unit>(this, c, timestamp){
            final /* synthetic */ CompletionActionsTracker this$0;
            final /* synthetic */ char $c;
            final /* synthetic */ long $timestamp;

            public final void invoke() {
                CompletionActionsTracker.access$getLogger$p(this.this$0).afterCharTyped(this.$c, CompletionActionsTracker.access$getLookup$p(this.this$0), this.$timestamp);
            }
            {
                this.this$0 = completionActionsTracker;
                this.$c = c;
                this.$timestamp = l;
                super(0);
            }
        }));
    }

    private final boolean isSelectedByTyping(LookupElement item) {
        if (item != null) {
            String string = this.lookup.itemPattern(item);
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"lookup.itemPattern(item)");
            String pattern = string;
            return Intrinsics.areEqual((Object)item.getLookupString(), (Object)pattern);
        }
        return false;
    }

    public CompletionActionsTracker(@NotNull LookupImpl lookup, @NotNull LookupStorage lookupStorage, @NotNull CompletionLogger logger, @NotNull WebServiceStatus experimentHelper) {
        Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
        Intrinsics.checkParameterIsNotNull((Object)lookupStorage, (String)"lookupStorage");
        Intrinsics.checkParameterIsNotNull((Object)logger, (String)"logger");
        Intrinsics.checkParameterIsNotNull((Object)experimentHelper, (String)"experimentHelper");
        this.lookup = lookup;
        this.lookupStorage = lookupStorage;
        this.logger = logger;
        this.experimentHelper = experimentHelper;
        this.deferredLog = new DeferredLog();
    }

    public static final /* synthetic */ WebServiceStatus access$getExperimentHelper$p(CompletionActionsTracker $this) {
        return $this.experimentHelper;
    }

    public static final /* synthetic */ CompletionLogger access$getLogger$p(CompletionActionsTracker $this) {
        return $this.logger;
    }

    public static final /* synthetic */ LookupImpl access$getLookup$p(CompletionActionsTracker $this) {
        return $this.lookup;
    }
}

