/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.stats.completion;

import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.ml.CompletionEnvironment;
import com.intellij.codeInsight.completion.ml.ContextFeatureProvider;
import com.intellij.codeInsight.completion.ml.MLFeatureValue;
import com.intellij.codeInsight.lookup.Lookup;
import com.intellij.codeInsight.lookup.LookupEx;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.stats.storage.factors.MutableLookupStorage;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/intellij/stats/completion/ContextFeaturesContributor;", "Lcom/intellij/codeInsight/completion/CompletionContributor;", "()V", "calculateContextFactors", "", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "storage", "Lcom/intellij/stats/storage/factors/MutableLookupStorage;", "fillCompletionVariants", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "MyEnvironment", "intellij.statsCollector"})
public final class ContextFeaturesContributor
extends CompletionContributor {
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull CompletionResultSet result) {
        MutableLookupStorage storage;
        LookupImpl lookup;
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)result, (String)"result");
        LookupEx lookupEx = LookupManager.getActiveLookup((Editor)parameters.getEditor());
        if (!(lookupEx instanceof LookupImpl)) {
            lookupEx = null;
        }
        if ((lookup = (LookupImpl)lookupEx) != null && (storage = MutableLookupStorage.Companion.get(lookup)) != null && storage.shouldComputeFeatures() && !storage.isContextFactorsInitialized()) {
            this.calculateContextFactors(lookup, parameters, storage);
        }
        super.fillCompletionVariants(parameters, result);
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateContextFactors(LookupImpl lookup, CompletionParameters parameters, MutableLookupStorage storage) {
        MyEnvironment environment = new MyEnvironment(lookup, parameters);
        boolean bl = false;
        Map contextFeatures = new LinkedHashMap();
        for (ContextFeatureProvider provider : ContextFeatureProvider.forLanguage((Language)storage.getLanguage())) {
            String providerName;
            Map features2;
            ProgressManager.checkCanceled();
            ContextFeatureProvider contextFeatureProvider = provider;
            Intrinsics.checkExpressionValueIsNotNull((Object)contextFeatureProvider, (String)"provider");
            Intrinsics.checkExpressionValueIsNotNull((Object)contextFeatureProvider.getName(), (String)"provider.name");
            long start = System.nanoTime();
            Intrinsics.checkExpressionValueIsNotNull((Object)provider.calculateFeatures((CompletionEnvironment)environment), (String)"provider.calculateFeatures(environment)");
            Object object = features2;
            boolean bl2 = false;
            Iterator iterator = object.entrySet().iterator();
            while (iterator.hasNext()) {
                void featureName;
                Map.Entry entry;
                Map.Entry entry2 = entry = iterator.next();
                boolean bl3 = false;
                object = (String)entry2.getKey();
                entry2 = entry;
                bl3 = false;
                MLFeatureValue value = (MLFeatureValue)entry2.getValue();
                String string = "ml_ctx_" + providerName + '_' + (String)featureName;
                MLFeatureValue mLFeatureValue = value;
                Intrinsics.checkExpressionValueIsNotNull((Object)mLFeatureValue, (String)"value");
                contextFeatures.put(string, mLFeatureValue);
            }
            long timeSpent = System.nanoTime() - start;
            storage.getPerformanceTracker().contextFeaturesCalculated(providerName, TimeUnit.NANOSECONDS.toMillis(timeSpent));
        }
        storage.initContextFactors(contextFeatures, environment);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0006H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/intellij/stats/completion/ContextFeaturesContributor$MyEnvironment;", "Lcom/intellij/codeInsight/completion/ml/CompletionEnvironment;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "lookup", "Lcom/intellij/codeInsight/lookup/impl/LookupImpl;", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "(Lcom/intellij/codeInsight/lookup/impl/LookupImpl;Lcom/intellij/codeInsight/completion/CompletionParameters;)V", "getLookup", "Lcom/intellij/codeInsight/lookup/Lookup;", "getParameters", "intellij.statsCollector"})
    private static final class MyEnvironment
    extends UserDataHolderBase
    implements CompletionEnvironment {
        private final LookupImpl lookup;
        private final CompletionParameters parameters;

        @NotNull
        public Lookup getLookup() {
            return (Lookup)this.lookup;
        }

        @NotNull
        public CompletionParameters getParameters() {
            return this.parameters;
        }

        public MyEnvironment(@NotNull LookupImpl lookup, @NotNull CompletionParameters parameters) {
            Intrinsics.checkParameterIsNotNull((Object)lookup, (String)"lookup");
            Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
            this.lookup = lookup;
            this.parameters = parameters;
        }
    }
}

