/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.text;

import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class TextWithMnemonic {
    public static final Pattern MNEMONIC = Pattern.compile(" ?\\(_?[A-Z]\\)");
    @NotNull
    @Nls
    private final String myText;
    private final int myMnemonicIndex;
    @NotNull
    @Nls
    private final String myMnemonicSuffix;

    private TextWithMnemonic(@NotNull @Nls String text, int mnemonicIndex, @NotNull @Nls String mnemonicSuffix) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(0);
        }
        if (mnemonicSuffix == null) {
            TextWithMnemonic.$$$reportNull$$$0(1);
        }
        assert (mnemonicIndex >= 0 || mnemonicSuffix.isEmpty());
        assert (mnemonicIndex >= -1 && mnemonicIndex < text.length() + mnemonicSuffix.length());
        this.myText = StringUtil.internEmptyString((String)text);
        this.myMnemonicIndex = mnemonicIndex;
        this.myMnemonicSuffix = mnemonicSuffix;
    }

    @NotNull
    @Nls
    public String getText() {
        String string = this.myText + this.myMnemonicSuffix.substring(this.myMnemonicSuffix.length() - TextWithMnemonic.getEllipsisLength(this.myMnemonicSuffix));
        if (string == null) {
            TextWithMnemonic.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    @Nls
    public String getText(boolean withMnemonicSuffix) {
        String string = withMnemonicSuffix ? this.myText + this.myMnemonicSuffix : this.getText();
        if (string == null) {
            TextWithMnemonic.$$$reportNull$$$0(3);
        }
        return string;
    }

    public int getMnemonic() {
        return this.hasMnemonic() ? (int)Character.toUpperCase((this.myText + this.myMnemonicSuffix).charAt(this.myMnemonicIndex)) : 0;
    }

    public int getMnemonicIndex() {
        return this.myMnemonicIndex;
    }

    public boolean hasMnemonic() {
        return this.myMnemonicIndex >= 0;
    }

    public TextWithMnemonic dropMnemonic(boolean forceRemove) {
        if (!this.hasMnemonic()) {
            return this;
        }
        if (!forceRemove) {
            return TextWithMnemonic.fromPlainText(this.myText);
        }
        Matcher matcher = MNEMONIC.matcher(this.myText);
        if (matcher.find()) {
            return TextWithMnemonic.fromPlainText(matcher.replaceAll(""));
        }
        return this;
    }

    public TextWithMnemonic setMnemonicAt(int index) {
        if (index < 0 || index >= this.myText.length() + this.myMnemonicSuffix.length()) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return index == this.myMnemonicIndex ? this : new TextWithMnemonic(this.myText, index, this.myMnemonicSuffix);
    }

    public TextWithMnemonic append(@NotNull @Nls String textToAppend) {
        if (textToAppend == null) {
            TextWithMnemonic.$$$reportNull$$$0(4);
        }
        return new TextWithMnemonic(this.myText + textToAppend, this.myMnemonicIndex, this.myMnemonicSuffix);
    }

    public TextWithMnemonic replaceFirst(@NotNull String target, @NotNull String replacement) {
        int index;
        if (target == null) {
            TextWithMnemonic.$$$reportNull$$$0(5);
        }
        if (replacement == null) {
            TextWithMnemonic.$$$reportNull$$$0(6);
        }
        if ((index = this.myText.indexOf(target)) == -1) {
            return this;
        }
        String resultText = this.myText.substring(0, index) + replacement + this.myText.substring(index + target.length());
        int resultIndex = this.myMnemonicIndex < index ? this.myMnemonicIndex : (this.myMnemonicIndex >= index + target.length() ? this.myMnemonicIndex - target.length() + replacement.length() : -1);
        return new TextWithMnemonic(resultText, resultIndex, this.myMnemonicSuffix);
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(7);
        }
        return new TextWithMnemonic(text, -1, "");
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic fromPlainText(@NotNull @Nls String text, char mnemonicChar) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(8);
        }
        if (mnemonicChar == '\u0000') {
            return TextWithMnemonic.fromPlainText(text);
        }
        mnemonicChar = Character.toUpperCase(mnemonicChar);
        for (int i = 0; i < text.length(); ++i) {
            if (Character.toUpperCase(text.charAt(i)) != mnemonicChar) continue;
            return new TextWithMnemonic(text, i, "");
        }
        int ellipsisLength = TextWithMnemonic.getEllipsisLength(text);
        String suffix = "(" + mnemonicChar + ")" + text.substring(text.length() - ellipsisLength);
        text = text.substring(0, text.length() - ellipsisLength);
        return new TextWithMnemonic(text, text.length() + 1, suffix);
    }

    @NotNull
    @Contract(pure=true)
    public static TextWithMnemonic parse(@NotNull String text) {
        if (text == null) {
            TextWithMnemonic.$$$reportNull$$$0(9);
        }
        if (text.indexOf(27) >= 0) {
            text = text.replace('\u001b', '&');
        }
        if (text.contains("_") || text.contains("&")) {
            String plain;
            int length;
            StringBuilder plainText = new StringBuilder();
            int mnemonicIndex = -1;
            int backShift = 0;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (mnemonicIndex == -1 && (ch == '_' || ch == '&')) {
                    if (++i >= text.length()) break;
                    ch = text.charAt(i);
                    if (ch != '_' && ch != '&') {
                        mnemonicIndex = i - 1 - backShift;
                    } else {
                        ++backShift;
                    }
                }
                plainText.append(ch);
            }
            if ((length = (plain = plainText.toString()).length() - TextWithMnemonic.getEllipsisLength(plain)) > 3 && mnemonicIndex == length - 2 && plain.charAt(length - 1) == ')' && plain.charAt(length - 3) == '(') {
                int pos;
                for (pos = length - 3; pos > 0 && plain.charAt(pos - 1) == ' '; --pos) {
                }
                return new TextWithMnemonic(plain.substring(0, pos), mnemonicIndex, plain.substring(pos));
            }
            return new TextWithMnemonic(plain, mnemonicIndex, "");
        }
        return TextWithMnemonic.fromPlainText(text);
    }

    private static int getEllipsisLength(String text) {
        if (text.endsWith("...")) {
            return 3;
        }
        if (text.endsWith("\u2026")) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextWithMnemonic mnemonic = (TextWithMnemonic)o;
        return this.myMnemonicIndex == mnemonic.myMnemonicIndex && this.myText.equals(mnemonic.myText) && this.myMnemonicSuffix.equals(mnemonic.myMnemonicSuffix);
    }

    public int hashCode() {
        return (this.myText.hashCode() * 31 + this.myMnemonicIndex) * 31 + this.myMnemonicSuffix.hashCode();
    }

    public String toString() {
        if (this.myMnemonicIndex > -1) {
            String completeText = this.myText + this.myMnemonicSuffix;
            String prefix = StringUtil.escapeMnemonics((String)completeText.substring(0, this.myMnemonicIndex));
            String suffix = completeText.substring(this.myMnemonicIndex);
            return prefix + "_" + suffix;
        }
        return StringUtil.escapeMnemonics((String)this.myText);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mnemonicSuffix";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToAppend";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/text/TextWithMnemonic";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "append";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "replaceFirst";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "fromPlainText";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

