/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.codeStyle.arrangement.component;

import com.intellij.application.options.codeStyle.arrangement.action.ArrangementRemoveConditionAction;
import com.intellij.application.options.codeStyle.arrangement.animation.ArrangementAnimationPanel;
import com.intellij.application.options.codeStyle.arrangement.color.ArrangementColorsProvider;
import com.intellij.application.options.codeStyle.arrangement.util.InsetsPanel;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementStandardSettingsManager;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementUiComponent;
import com.intellij.psi.codeStyle.arrangement.std.InvertibleArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RoundedLineBorder;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.Consumer;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArrangementAtomMatchConditionComponent
implements ArrangementUiComponent {
    @NotNull
    private static final BorderStrategy TEXT_BORDER_STRATEGY = new NameBorderStrategy();
    @NotNull
    private static final BorderStrategy PREDEFINED_BORDER_STRATEGY = new PredefinedConditionBorderStrategy();
    @NotNull
    private final SimpleColoredComponent myTextControl;
    @NotNull
    private final Set<ArrangementSettingsToken> myAvailableTokens;
    @NotNull
    private final BorderStrategy myBorderStrategy;
    @NotNull
    private final String myText;
    @NotNull
    private final ArrangementColorsProvider myColorsProvider;
    @NotNull
    private final RoundedLineBorder myBorder;
    @NotNull
    private final ArrangementAtomMatchCondition myCondition;
    @NotNull
    private final ArrangementAnimationPanel myAnimationPanel;
    @Nullable
    private final ActionButton myCloseButton;
    @Nullable
    private final Rectangle myCloseButtonBounds;
    @Nullable
    private final Consumer<? super ArrangementAtomMatchConditionComponent> myCloseCallback;
    @NotNull
    private Color myBackgroundColor;
    @Nullable
    private final Dimension myTextControlSize;
    @Nullable
    private Rectangle myScreenBounds;
    @Nullable
    private ArrangementUiComponent.Listener myListener;
    private boolean myInverted;
    private boolean myEnabled;
    private boolean mySelected;
    private boolean myCloseButtonHovered;
    @Nullable
    private ArrangementAtomMatchCondition myOppositeCondition;
    @Nullable
    private String myInvertedText;

    public ArrangementAtomMatchConditionComponent(@NotNull ArrangementStandardSettingsManager manager, @NotNull ArrangementColorsProvider colorsProvider, @NotNull ArrangementAtomMatchCondition condition, @Nullable Consumer<? super ArrangementAtomMatchConditionComponent> closeCallback) {
        if (manager == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(0);
        }
        if (colorsProvider == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(1);
        }
        if (condition == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(2);
        }
        this.myTextControl = new SimpleColoredComponent(){

            @NotNull
            public Dimension getMinimumSize() {
                Dimension dimension = this.getPreferredSize();
                if (dimension == null) {
                    1.$$$reportNull$$$0(0);
                }
                return dimension;
            }

            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }

            @NotNull
            public Dimension getPreferredSize() {
                Dimension dimension = ArrangementAtomMatchConditionComponent.this.myTextControlSize == null ? super.getPreferredSize() : ArrangementAtomMatchConditionComponent.this.myTextControlSize;
                if (dimension == null) {
                    1.$$$reportNull$$$0(1);
                }
                return dimension;
            }

            public String toString() {
                return "text component for " + ArrangementAtomMatchConditionComponent.this.myText;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAtomMatchConditionComponent$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getMinimumSize";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPreferredSize";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        this.myAvailableTokens = new HashSet<ArrangementSettingsToken>();
        this.myInverted = false;
        this.myEnabled = true;
        this.myColorsProvider = colorsProvider;
        this.myCondition = condition;
        this.myAvailableTokens.add(condition.getType());
        this.myCloseCallback = closeCallback;
        ArrangementSettingsToken type = condition.getType();
        this.myBorderStrategy = StdArrangementTokenType.REG_EXP.is(type) ? TEXT_BORDER_STRATEGY : PREDEFINED_BORDER_STRATEGY;
        this.myText = type.equals(condition.getValue()) || condition.getValue() instanceof Boolean ? type.getRepresentationValue() : (StdArrangementTokenType.REG_EXP.is(type) ? String.format("%s %s", StringUtil.toLowerCase((String)type.getRepresentationValue()), condition.getValue()) : condition.getValue().toString());
        this.myTextControl.setTextAlign(0);
        this.myTextControl.append(this.myText, SimpleTextAttributes.fromTextAttributes((TextAttributes)colorsProvider.getTextAttributes(type, false)));
        this.myTextControl.setOpaque(false);
        int maxWidth = manager.getWidth(type);
        this.myTextControlSize = !StdArrangementTokenType.REG_EXP.is(type) && maxWidth > 0 ? new Dimension(maxWidth, this.myTextControl.getPreferredSize().height) : this.myTextControl.getPreferredSize();
        final ArrangementRemoveConditionAction action2 = new ArrangementRemoveConditionAction();
        Icon buttonIcon = action2.getTemplatePresentation().getIcon();
        if (closeCallback == null) {
            this.myCloseButton = null;
            this.myCloseButtonBounds = null;
        } else {
            this.myCloseButton = new ActionButton(action2, action2.getTemplatePresentation().clone(), "Arrangement.Rule.Match.Control.Place", (Dimension)JBUI.emptySize()){

                @Override
                public Icon getIcon() {
                    return ArrangementAtomMatchConditionComponent.this.myCloseButtonHovered ? action2.getTemplatePresentation().getHoveredIcon() : action2.getTemplatePresentation().getIcon();
                }
            };
            this.myCloseButtonBounds = new Rectangle(0, 0, buttonIcon.getIconWidth(), buttonIcon.getIconHeight());
        }
        JPanel insetsPanel = new JPanel(new GridBagLayout()){

            @Override
            public String toString() {
                return "insets panel for " + ArrangementAtomMatchConditionComponent.this.myText;
            }
        };
        GridBag constraints2 = new GridBag().anchor(17).weightx(1.0).insets(0, 0, 0, this.myCloseButton == null ? 12 : 0);
        insetsPanel.add((Component)this.myTextControl, constraints2);
        insetsPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)8));
        insetsPanel.setOpaque(false);
        JPanel roundBorderPanel = new JPanel(new GridBagLayout()){

            @Override
            public void paint(Graphics g) {
                Rectangle buttonBounds = ArrangementAtomMatchConditionComponent.this.getCloseButtonScreenBounds();
                if (buttonBounds != null) {
                    PointerInfo info = MouseInfo.getPointerInfo();
                    ArrangementAtomMatchConditionComponent.this.myCloseButtonHovered = info != null && buttonBounds.contains(info.getLocation());
                }
                Rectangle bounds2 = this.getBounds();
                g.setColor(ArrangementAtomMatchConditionComponent.this.myBackgroundColor);
                g.fillRoundRect(0, 0, bounds2.width, bounds2.height, 12, 12);
                super.paint(g);
            }

            @Override
            public String toString() {
                return "round border panel for " + ArrangementAtomMatchConditionComponent.this.myText;
            }

            @Override
            protected void paintBorder(Graphics g) {
                ArrangementAtomMatchConditionComponent.this.myBorderStrategy.setup((Graphics2D)g);
                super.paintBorder(g);
            }
        };
        roundBorderPanel.add((Component)insetsPanel, new GridBag().anchor(17));
        if (this.myCloseButton != null) {
            roundBorderPanel.add((Component)new InsetsPanel(this.myCloseButton), new GridBag().anchor(13));
        }
        this.myBorder = this.myBorderStrategy.create();
        roundBorderPanel.setBorder((Border)this.myBorder);
        roundBorderPanel.setOpaque(false);
        this.myAnimationPanel = new ArrangementAnimationPanel(roundBorderPanel, false, true){

            @Override
            public void paint(Graphics g) {
                Point point = UIUtil.getLocationOnScreen((JComponent)this);
                if (point != null) {
                    Rectangle bounds2 = ArrangementAtomMatchConditionComponent.this.myAnimationPanel.getBounds();
                    ArrangementAtomMatchConditionComponent.this.myScreenBounds = new Rectangle(point.x, point.y, bounds2.width, bounds2.height);
                }
                if (!ArrangementAtomMatchConditionComponent.this.myEnabled && g instanceof Graphics2D) {
                    ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.3f));
                }
                super.paint(g);
            }
        };
        this.setSelected(false);
        if (this.myCloseButton != null) {
            this.myCloseButton.setVisible(false);
        }
        this.setData(this.myCondition.getValue());
    }

    @NotNull
    public ArrangementAtomMatchCondition getMatchCondition() {
        if (Boolean.valueOf(this.myInverted).equals(this.myCondition.getValue())) {
            if (this.myOppositeCondition == null) {
                this.myOppositeCondition = new ArrangementAtomMatchCondition(this.myCondition.getType(), (Object)(!this.myInverted ? 1 : 0));
            }
            ArrangementAtomMatchCondition arrangementAtomMatchCondition = this.myOppositeCondition;
            if (arrangementAtomMatchCondition == null) {
                ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(3);
            }
            return arrangementAtomMatchCondition;
        }
        ArrangementAtomMatchCondition arrangementAtomMatchCondition = this.myCondition;
        if (arrangementAtomMatchCondition == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(4);
        }
        return arrangementAtomMatchCondition;
    }

    public void setData(@NotNull Object data2) {
        if (data2 == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(5);
        }
        if (data2 instanceof Boolean && this.myCondition.getType() instanceof InvertibleArrangementSettingsToken) {
            this.myInverted = (Boolean)data2 == false;
            this.updateComponentText(this.mySelected);
        }
    }

    @NotNull
    public JComponent getUiComponent() {
        ArrangementAnimationPanel arrangementAnimationPanel = this.myAnimationPanel;
        if (arrangementAnimationPanel == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(6);
        }
        return arrangementAnimationPanel;
    }

    @Nullable
    public Rectangle getScreenBounds() {
        return this.myScreenBounds;
    }

    public void setSelected(boolean selected2) {
        boolean notifyListener = selected2 != this.mySelected;
        this.mySelected = selected2;
        TextAttributes attributes = this.updateComponentText(selected2);
        this.myBorder.setColor(this.myColorsProvider.getBorderColor(selected2));
        this.myBackgroundColor = attributes.getBackgroundColor();
        if (notifyListener && this.myListener != null) {
            this.myListener.stateChanged();
        }
    }

    @NotNull
    private TextAttributes updateComponentText(boolean selected2) {
        this.myTextControl.clear();
        TextAttributes attributes = this.myColorsProvider.getTextAttributes(this.myCondition.getType(), selected2);
        this.myTextControl.append(this.getComponentText(), SimpleTextAttributes.fromTextAttributes((TextAttributes)attributes));
        TextAttributes textAttributes = attributes;
        if (textAttributes == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(7);
        }
        return textAttributes;
    }

    private String getComponentText() {
        if (this.myInverted) {
            if (StringUtil.isEmpty((String)this.myInvertedText)) {
                ArrangementSettingsToken token = this.myCondition.getType();
                assert (token instanceof InvertibleArrangementSettingsToken);
                this.myInvertedText = ((InvertibleArrangementSettingsToken)token).getInvertedRepresentationValue();
            }
            return this.myInvertedText;
        }
        return this.myText;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
        if (!enabled) {
            this.setSelected(false);
        }
    }

    @Nullable
    public Rectangle onMouseMove(@NotNull MouseEvent event) {
        Rectangle buttonBounds;
        if (event == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(8);
        }
        if ((buttonBounds = this.getCloseButtonScreenBounds()) == null) {
            return null;
        }
        if (this.myCloseButton != null && !this.myCloseButton.isVisible()) {
            this.myCloseButton.setVisible(true);
            return buttonBounds;
        }
        boolean mouseOverButton = buttonBounds.contains(event.getLocationOnScreen());
        return mouseOverButton ^ this.myCloseButtonHovered ? buttonBounds : null;
    }

    public void onMouseRelease(@NotNull MouseEvent event) {
        Rectangle buttonBounds;
        if (event == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(9);
        }
        if ((buttonBounds = this.getCloseButtonScreenBounds()) != null && this.myCloseCallback != null && buttonBounds.contains(event.getLocationOnScreen())) {
            this.myCloseCallback.consume((Object)this);
            event.consume();
        }
    }

    public Rectangle onMouseEntered(@NotNull MouseEvent e) {
        if (e == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(10);
        }
        if (this.myCloseButton != null) {
            this.myCloseButton.setVisible(true);
            return this.getCloseButtonScreenBounds();
        }
        return null;
    }

    @Nullable
    public Rectangle onMouseExited() {
        if (this.myCloseButton == null) {
            return null;
        }
        this.myCloseButton.setVisible(false);
        return this.getCloseButtonScreenBounds();
    }

    @Nullable
    private Rectangle getCloseButtonScreenBounds() {
        if (this.myCloseButton == null || this.myScreenBounds == null) {
            return null;
        }
        Rectangle buttonBounds = SwingUtilities.convertRectangle(this.myCloseButton.getParent(), this.myCloseButtonBounds, this.myAnimationPanel);
        buttonBounds.x += this.myScreenBounds.x;
        buttonBounds.y += this.myScreenBounds.y;
        return buttonBounds;
    }

    @NotNull
    public ArrangementAnimationPanel getAnimationPanel() {
        ArrangementAnimationPanel arrangementAnimationPanel = this.myAnimationPanel;
        if (arrangementAnimationPanel == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(11);
        }
        return arrangementAnimationPanel;
    }

    public String toString() {
        return this.getComponentText();
    }

    @NotNull
    public ArrangementSettingsToken getToken() {
        ArrangementSettingsToken arrangementSettingsToken = this.myCondition.getType();
        if (arrangementSettingsToken == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(12);
        }
        return arrangementSettingsToken;
    }

    @NotNull
    public Set<ArrangementSettingsToken> getAvailableTokens() {
        Set<ArrangementSettingsToken> set = this.myAvailableTokens;
        if (set == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(13);
        }
        return set;
    }

    public void chooseToken(@NotNull ArrangementSettingsToken data2) throws IllegalArgumentException, UnsupportedOperationException {
        if (data2 == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(14);
        }
        throw new UnsupportedOperationException();
    }

    public boolean isSelected() {
        return this.mySelected;
    }

    public void reset() {
        this.setSelected(false);
        this.setData(true);
    }

    public int getBaselineToUse(int width, int height) {
        return -1;
    }

    public void setListener(@NotNull ArrangementUiComponent.Listener listener2) {
        if (listener2 == null) {
            ArrangementAtomMatchConditionComponent.$$$reportNull$$$0(15);
        }
        this.myListener = listener2;
    }

    public void handleMouseClickOnSelected() {
        if (this.myInverted || !(this.myCondition.getType() instanceof InvertibleArrangementSettingsToken)) {
            this.setSelected(false);
        }
        this.setData(this.myInverted);
    }

    public boolean alwaysCanBeActive() {
        return this.myInverted;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorsProvider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAtomMatchConditionComponent";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAtomMatchConditionComponent";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMatchCondition";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUiComponent";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "updateComponentText";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnimationPanel";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getToken";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTokens";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "onMouseMove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "onMouseRelease";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "onMouseEntered";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "chooseToken";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NameBorderStrategy
    implements BorderStrategy {
        @NotNull
        private final BasicStroke myStroke = new BasicStroke(1.0f, 0, 2, 1.0f, new float[]{5.0f, 5.0f}, 0.0f);

        private NameBorderStrategy() {
        }

        @Override
        public RoundedLineBorder create() {
            return IdeBorderFactory.createRoundedBorder((int)12, (int)2);
        }

        @Override
        public void setup(@NotNull Graphics2D g) {
            if (g == null) {
                NameBorderStrategy.$$$reportNull$$$0(0);
            }
            g.setStroke(this.myStroke);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAtomMatchConditionComponent$NameBorderStrategy", "setup"));
        }
    }

    private static class PredefinedConditionBorderStrategy
    implements BorderStrategy {
        private PredefinedConditionBorderStrategy() {
        }

        @Override
        public RoundedLineBorder create() {
            return IdeBorderFactory.createRoundedBorder((int)12);
        }

        @Override
        public void setup(@NotNull Graphics2D g) {
            if (g == null) {
                PredefinedConditionBorderStrategy.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/application/options/codeStyle/arrangement/component/ArrangementAtomMatchConditionComponent$PredefinedConditionBorderStrategy", "setup"));
        }
    }

    private static interface BorderStrategy {
        public RoundedLineBorder create();

        public void setup(@NotNull Graphics2D var1);
    }
}

