/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.EventResult;
import com.intellij.build.events.Failure;
import com.intellij.build.events.FailureResult;
import com.intellij.build.events.MessageEvent;
import com.intellij.build.events.MessageEventResult;
import com.intellij.build.events.SkippedResult;
import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ide.util.treeView.PresentableNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EmptyIcon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExecutionNode
extends PresentableNodeDescriptor<ExecutionNode> {
    private static final Icon NODE_ICON_OK = AllIcons.RunConfigurations.TestPassed;
    private static final Icon NODE_ICON_ERROR = AllIcons.RunConfigurations.TestError;
    private static final Icon NODE_ICON_WARNING = AllIcons.General.Warning;
    private static final Icon NODE_ICON_INFO = AllIcons.General.Information;
    private static final Icon NODE_ICON_SKIPPED = AllIcons.RunConfigurations.TestIgnored;
    private static final Icon NODE_ICON_STATISTICS = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_SIMPLE = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_DEFAULT = EmptyIcon.ICON_16;
    private static final Icon NODE_ICON_RUNNING = new AnimatedIcon.Default();
    private final List<ExecutionNode> myChildrenList;
    private List<ExecutionNode> myVisibleChildrenList;
    private final AtomicInteger myErrors;
    private final AtomicInteger myWarnings;
    private final AtomicInteger myInfos;
    private final ExecutionNode myParentNode;
    private volatile long startTime;
    private volatile long endTime;
    @Nullable
    private String myTitle;
    @Nullable
    private String myHint;
    @Nullable
    private volatile EventResult myResult;
    private final boolean myAutoExpandNode;
    private final Supplier<Boolean> myIsCorrectThread;
    @Nullable
    private volatile Navigatable myNavigatable;
    @Nullable
    private volatile NullableLazyValue<Icon> myPreferredIconValue;
    @Nullable
    private Predicate<ExecutionNode> myFilter;
    private boolean myAlwaysLeaf;

    public ExecutionNode(Project aProject, ExecutionNode parentNode, boolean isAutoExpandNode, @NotNull Supplier<Boolean> isCorrectThread) {
        if (isCorrectThread == null) {
            ExecutionNode.$$$reportNull$$$0(0);
        }
        super(aProject, (NodeDescriptor)parentNode);
        this.myChildrenList = new ArrayList<ExecutionNode>();
        this.myVisibleChildrenList = null;
        this.myErrors = new AtomicInteger();
        this.myWarnings = new AtomicInteger();
        this.myInfos = new AtomicInteger();
        this.myName = "";
        this.myParentNode = parentNode;
        this.myAutoExpandNode = isAutoExpandNode;
        this.myIsCorrectThread = isCorrectThread;
    }

    private boolean nodeIsVisible(ExecutionNode node) {
        return this.myFilter == null || this.myFilter.test(node);
    }

    protected void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            ExecutionNode.$$$reportNull$$$0(1);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        this.setIcon(this.getCurrentIcon());
        presentation2.setPresentableText(this.myName);
        presentation2.setIcon(this.getIcon());
        if (StringUtil.isNotEmpty((String)this.myTitle)) {
            presentation2.addText(this.myTitle + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String hint = this.getCurrentHint();
        boolean isNotEmptyName = StringUtil.isNotEmpty((String)this.myName);
        if (isNotEmptyName && this.myTitle != null || hint != null) {
            presentation2.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        }
        if (StringUtil.isNotEmpty((String)hint)) {
            if (isNotEmptyName) {
                hint = " " + hint;
            }
            presentation2.addText(hint, SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myName = name;
    }

    @Nullable
    public String getTitle() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myTitle;
    }

    public void setTitle(@Nullable String title) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myTitle = title;
    }

    public void setHint(@Nullable String hint) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myHint = hint;
    }

    public void add(@NotNull ExecutionNode node) {
        if (node == null) {
            ExecutionNode.$$$reportNull$$$0(2);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myChildrenList.add(node);
        node.setFilter(this.myFilter);
        if (this.myVisibleChildrenList != null && this.nodeIsVisible(node)) {
            this.myVisibleChildrenList.add(node);
        }
    }

    void removeChildren() {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myChildrenList.clear();
        if (this.myVisibleChildrenList != null) {
            this.myVisibleChildrenList.clear();
        }
        this.myErrors.set(0);
        this.myWarnings.set(0);
        this.myInfos.set(0);
        this.myResult = null;
    }

    @Nullable
    public String getDuration() {
        if (this.startTime == this.endTime) {
            return null;
        }
        if (this.isRunning()) {
            long duration = this.startTime == 0L ? 0L : System.currentTimeMillis() - this.startTime;
            String durationText = StringUtil.formatDurationApproximate((long)duration);
            int index = durationText.indexOf("s ");
            if (index != -1) {
                durationText = durationText.substring(0, index + 1);
            }
            return durationText;
        }
        return ExecutionNode.isSkipped(this.myResult) ? null : StringUtil.formatDuration((long)(this.endTime - this.startTime));
    }

    public long getStartTime() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.startTime = startTime;
    }

    public long getEndTime() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.endTime;
    }

    public ExecutionNode setEndTime(long endTime) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.endTime = endTime;
        return this.reapplyParentFilterIfRequired(null);
    }

    private ExecutionNode reapplyParentFilterIfRequired(@Nullable ExecutionNode result2) {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (this.myParentNode != null) {
            Predicate<ExecutionNode> filter2;
            List<ExecutionNode> parentVisibleChildrenList = this.myParentNode.myVisibleChildrenList;
            if (parentVisibleChildrenList != null && (filter2 = this.myParentNode.myFilter) != null) {
                boolean wasPresent = parentVisibleChildrenList.contains((Object)this);
                boolean shouldBePresent = filter2.test(this);
                if (shouldBePresent != wasPresent) {
                    if (shouldBePresent) {
                        this.myParentNode.maybeReapplyFilter();
                    } else {
                        parentVisibleChildrenList.remove((Object)this);
                    }
                    result2 = this.myParentNode;
                }
            }
            return this.myParentNode.reapplyParentFilterIfRequired(result2);
        }
        return result2;
    }

    @NotNull
    public List<ExecutionNode> getChildList() {
        assert (this.myIsCorrectThread.get().booleanValue());
        List<ExecutionNode> visibleList = this.myVisibleChildrenList;
        if (visibleList != null) {
            List<ExecutionNode> list2 = visibleList;
            if (list2 == null) {
                ExecutionNode.$$$reportNull$$$0(3);
            }
            return list2;
        }
        List<ExecutionNode> list3 = this.myChildrenList;
        if (list3 == null) {
            ExecutionNode.$$$reportNull$$$0(4);
        }
        return list3;
    }

    @Nullable
    public ExecutionNode getParent() {
        return this.myParentNode;
    }

    public ExecutionNode getElement() {
        return this;
    }

    @Nullable
    public Predicate<ExecutionNode> getFilter() {
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myFilter;
    }

    public void setFilter(@Nullable Predicate<ExecutionNode> filter2) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myFilter = filter2;
        for (ExecutionNode node : this.myChildrenList) {
            node.setFilter(this.myFilter);
        }
        if (filter2 == null) {
            this.myVisibleChildrenList = null;
        } else {
            if (this.myVisibleChildrenList == null) {
                this.myVisibleChildrenList = Collections.synchronizedList(new ArrayList());
            }
            this.maybeReapplyFilter();
        }
    }

    private void maybeReapplyFilter() {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (this.myVisibleChildrenList != null) {
            this.myVisibleChildrenList.clear();
            this.myChildrenList.stream().filter(it -> this.nodeIsVisible((ExecutionNode)((Object)it))).forEachOrdered(this.myVisibleChildrenList::add);
        }
    }

    public boolean isRunning() {
        return this.endTime <= 0L && !ExecutionNode.isSkipped(this.myResult) && !ExecutionNode.isFailed(this.myResult);
    }

    public boolean hasWarnings() {
        return this.myWarnings.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.WARNING;
    }

    public boolean hasInfos() {
        return this.myInfos.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.INFO;
    }

    public boolean isFailed() {
        return ExecutionNode.isFailed(this.myResult) || this.myErrors.get() > 0 || this.myResult instanceof MessageEventResult && ((MessageEventResult)this.myResult).getKind() == MessageEvent.Kind.ERROR;
    }

    @Nullable
    public EventResult getResult() {
        return this.myResult;
    }

    public ExecutionNode setResult(@Nullable EventResult result2) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myResult = result2;
        return this.reapplyParentFilterIfRequired(null);
    }

    public boolean isAutoExpandNode() {
        return this.myAutoExpandNode;
    }

    @ApiStatus.Experimental
    public boolean isAlwaysLeaf() {
        return this.myAlwaysLeaf;
    }

    @ApiStatus.Experimental
    public void setAlwaysLeaf(boolean alwaysLeaf) {
        this.myAlwaysLeaf = alwaysLeaf;
    }

    public void setNavigatable(@Nullable Navigatable navigatable) {
        assert (this.myIsCorrectThread.get().booleanValue());
        this.myNavigatable = navigatable;
    }

    @NotNull
    public List<Navigatable> getNavigatables() {
        if (this.myNavigatable != null) {
            List<Navigatable> list2 = Collections.singletonList(this.myNavigatable);
            if (list2 == null) {
                ExecutionNode.$$$reportNull$$$0(5);
            }
            return list2;
        }
        if (this.myResult == null) {
            List<Navigatable> list3 = Collections.emptyList();
            if (list3 == null) {
                ExecutionNode.$$$reportNull$$$0(6);
            }
            return list3;
        }
        if (this.myResult instanceof FailureResult) {
            SmartList result2 = new SmartList();
            for (Failure failure : ((FailureResult)this.myResult).getFailures()) {
                ContainerUtil.addIfNotNull((Collection)result2, (Object)failure.getNavigatable());
            }
            SmartList smartList = result2;
            if (smartList == null) {
                ExecutionNode.$$$reportNull$$$0(7);
            }
            return smartList;
        }
        List<Navigatable> list4 = Collections.emptyList();
        if (list4 == null) {
            ExecutionNode.$$$reportNull$$$0(8);
        }
        return list4;
    }

    public void setIconProvider(final Supplier<? extends Icon> iconProvider) {
        this.myPreferredIconValue = new NullableLazyValue<Icon>(){

            @Nullable
            protected Icon compute() {
                return (Icon)iconProvider.get();
            }
        };
    }

    @Nullable
    public ExecutionNode reportChildMessageKind(MessageEvent.Kind kind) {
        assert (this.myIsCorrectThread.get().booleanValue());
        if (kind == MessageEvent.Kind.ERROR) {
            this.myErrors.incrementAndGet();
        } else if (kind == MessageEvent.Kind.WARNING) {
            this.myWarnings.incrementAndGet();
        } else if (kind == MessageEvent.Kind.INFO) {
            this.myInfos.incrementAndGet();
        }
        return this.reapplyParentFilterIfRequired(null);
    }

    @Nullable
    @ApiStatus.Experimental
    ExecutionNode findFirstChild(@NotNull Predicate<? super ExecutionNode> filter2) {
        if (filter2 == null) {
            ExecutionNode.$$$reportNull$$$0(9);
        }
        assert (this.myIsCorrectThread.get().booleanValue());
        return this.myChildrenList.stream().filter(filter2).findFirst().orElse(null);
    }

    private String getCurrentHint() {
        assert (this.myIsCorrectThread.get().booleanValue());
        String hint = this.myHint;
        int warnings = this.myWarnings.get();
        int errors = this.myErrors.get();
        if (warnings > 0 || errors > 0) {
            if (hint == null) {
                hint = "";
            }
            ExecutionNode parent = this.getParent();
            hint = hint + (parent == null || parent.getParent() == null ? (this.isRunning() ? "  " : " with ") : " ");
            if (errors > 0) {
                hint = hint + errors + " " + StringUtil.pluralize((String)"error", (int)errors);
                if (warnings > 0) {
                    hint = hint + ", ";
                }
            }
            if (warnings > 0) {
                hint = hint + warnings + " " + StringUtil.pluralize((String)"warning", (int)warnings);
            }
        }
        return hint;
    }

    private Icon getCurrentIcon() {
        if (this.myPreferredIconValue != null) {
            return (Icon)this.myPreferredIconValue.getValue();
        }
        if (this.myResult instanceof MessageEventResult) {
            return ExecutionNode.getIcon(((MessageEventResult)this.myResult).getKind());
        }
        return this.isRunning() ? NODE_ICON_RUNNING : (ExecutionNode.isFailed(this.myResult) ? NODE_ICON_ERROR : (ExecutionNode.isSkipped(this.myResult) ? NODE_ICON_SKIPPED : (this.myErrors.get() > 0 ? NODE_ICON_ERROR : (this.myWarnings.get() > 0 ? NODE_ICON_WARNING : NODE_ICON_OK))));
    }

    public static boolean isFailed(@Nullable EventResult result2) {
        return result2 instanceof FailureResult;
    }

    public static boolean isSkipped(@Nullable EventResult result2) {
        return result2 instanceof SkippedResult;
    }

    public static Icon getEventResultIcon(@Nullable EventResult result2) {
        if (result2 == null) {
            return NODE_ICON_RUNNING;
        }
        if (ExecutionNode.isFailed(result2)) {
            return NODE_ICON_ERROR;
        }
        if (ExecutionNode.isSkipped(result2)) {
            return NODE_ICON_SKIPPED;
        }
        return NODE_ICON_OK;
    }

    private static Icon getIcon(MessageEvent.Kind kind) {
        switch (kind) {
            case ERROR: {
                return NODE_ICON_ERROR;
            }
            case WARNING: {
                return NODE_ICON_WARNING;
            }
            case INFO: {
                return NODE_ICON_INFO;
            }
            case STATISTICS: {
                return NODE_ICON_STATISTICS;
            }
            case SIMPLE: {
                return NODE_ICON_SIMPLE;
            }
        }
        return NODE_ICON_DEFAULT;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isCorrectThread";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/build/ExecutionNode";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/build/ExecutionNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildList";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getNavigatables";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findFirstChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

