/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.HectorComponent;
import com.intellij.codeInsight.daemon.impl.analysis.FileHighlightingSetting;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightLevelUtil;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightingLevelManager;
import com.intellij.icons.AllIcons;
import com.intellij.internal.statistic.service.fus.collectors.UIEventId;
import com.intellij.internal.statistic.service.fus.collectors.UIEventLogger;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.EditorBundle;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.options.ex.ConfigurableExtensionPointUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.ui.ErrorsConfigurableProvider;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.Border;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HectorComponentImpl
extends JPanel
implements HectorComponent {
    private static final Logger LOG = Logger.getInstance(HectorComponent.class);
    private WeakReference<JBPopup> myHectorRef;
    private final ArrayList<HectorComponentPanel> myAdditionalPanels;
    private final Map<Language, JSlider> mySliders;
    private final PsiFile myFile;

    HectorComponentImpl(@NotNull PsiFile file2) {
        boolean addLabel;
        if (file2 == null) {
            HectorComponentImpl.$$$reportNull$$$0(0);
        }
        super(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 7, 0));
        this.myFile = file2;
        this.mySliders = new HashMap<Language, JSlider>();
        Project project = this.myFile.getProject();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        VirtualFile virtualFile = this.myFile.getContainingFile().getVirtualFile();
        LOG.assertTrue(virtualFile != null);
        boolean notInLibrary = !fileIndex.isInLibrary(virtualFile) || fileIndex.isInContent(virtualFile);
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        ArrayList languages = new ArrayList(viewProvider.getLanguages());
        languages.sort(PsiUtilBase.LANGUAGE_COMPARATOR);
        for (Language language : languages) {
            Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
            sliderLabels.put(1, new JLabel(EditorBundle.message((String)"hector.none.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorOff, 2));
            sliderLabels.put(2, new JLabel(EditorBundle.message((String)"hector.syntax.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorSyntax, 2));
            if (notInLibrary) {
                sliderLabels.put(3, new JLabel(EditorBundle.message((String)"hector.inspections.slider.label", (Object[])new Object[0]), AllIcons.Ide.HectorOn, 2));
            }
            JSlider slider = new JSlider(1, 1, notInLibrary ? 3 : 2, 1);
            slider.setLabelTable(sliderLabels);
            UIUtil.setSliderIsFilled((JSlider)slider, (boolean)true);
            slider.setPaintLabels(true);
            slider.setSnapToTicks(true);
            slider.addChangeListener(e -> {
                int value2 = slider.getValue();
                Enumeration enumeration = sliderLabels.keys();
                while (enumeration.hasMoreElements()) {
                    Integer key = (Integer)enumeration.nextElement();
                    ((JComponent)sliderLabels.get(key)).setForeground(key <= value2 ? UIUtil.getLabelForeground() : UIUtil.getLabelDisabledForeground());
                }
            });
            PsiFile psiRoot = viewProvider.getPsi(language);
            assert (psiRoot != null) : "No root in " + viewProvider + " for " + language;
            slider.setValue(HectorComponentImpl.getValue(HighlightingLevelManager.getInstance(project).shouldHighlight((PsiElement)psiRoot), HighlightingLevelManager.getInstance(project).shouldInspect((PsiElement)psiRoot)));
            this.mySliders.put(language, slider);
        }
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, (Insets)JBUI.insetsLeft((int)5), 0, 0);
        JPanel panel2 = new JPanel(new GridBagLayout());
        panel2.setBorder((Border)IdeBorderFactory.createTitledBorder((String)EditorBundle.message((String)"hector.highlighting.level.title", (Object[])new Object[0]), (boolean)false));
        boolean bl = addLabel = this.mySliders.size() > 1;
        if (addLabel) {
            this.layoutVertical(panel2);
        } else {
            this.layoutHorizontal(panel2);
        }
        gc.gridx = 0;
        gc.gridy = 0;
        gc.weighty = 1.0;
        gc.fill = 1;
        this.add((Component)panel2, gc);
        gc.gridy = -1;
        gc.weighty = 0.0;
        HyperlinkLabel configurator = new HyperlinkLabel(DaemonBundle.message((String)"popup.action.configure.inspections", (Object[])new Object[0]));
        gc.insets.right = 5;
        gc.insets.bottom = 10;
        gc.weightx = 0.0;
        gc.fill = 0;
        gc.anchor = 13;
        this.add((Component)configurator, gc);
        configurator.addHyperlinkListener(e -> {
            JBPopup hector = this.getOldHector();
            if (hector != null) {
                hector.cancel();
            }
            if (!DaemonCodeAnalyzer.getInstance((Project)this.myFile.getProject()).isHighlightingAvailable(this.myFile)) {
                return;
            }
            Project project1 = this.myFile.getProject();
            ShowSettingsUtil.getInstance().editConfigurable(project1, ConfigurableExtensionPointUtil.createProjectConfigurableForProvider(project1, ErrorsConfigurableProvider.class));
        });
        gc.anchor = 17;
        gc.weightx = 1.0;
        gc.insets.right = 0;
        gc.fill = 2;
        this.myAdditionalPanels = new ArrayList();
        for (HectorComponentPanelsProvider provider : (HectorComponentPanelsProvider[])HectorComponentPanelsProvider.EP_NAME.getExtensions((AreaInstance)project)) {
            HectorComponentPanel componentPanel = provider.createConfigurable(file2);
            if (componentPanel == null) continue;
            this.myAdditionalPanels.add(componentPanel);
            this.add((Component)componentPanel.createComponent(), gc);
            componentPanel.reset();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension preferredSize = super.getPreferredSize();
        int width = JBUIScale.scale((int)300);
        if (preferredSize.width < width) {
            preferredSize.width = width;
        }
        return preferredSize;
    }

    private void layoutHorizontal(JPanel panel2) {
        for (JSlider slider : this.mySliders.values()) {
            slider.setOrientation(0);
            slider.setPreferredSize((Dimension)JBUI.size((int)200, (int)40));
            panel2.add((Component)slider, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)5, (int)0), 0, 0));
        }
    }

    private void layoutVertical(JPanel panel2) {
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            JPanel borderPanel = new JPanel(new BorderLayout());
            slider.setPreferredSize((Dimension)JBUI.size((int)100));
            borderPanel.add((Component)new JLabel(language.getID()), "North");
            borderPanel.add((Component)slider, "Center");
            panel2.add((Component)borderPanel, new GridBagConstraints(-1, 1, 1, 1, 0.0, 1.0, 10, 3, (Insets)JBUI.insets((int)0, (int)5), 0, 0));
        }
    }

    @Override
    public void showComponent(@NotNull Component component2, @NotNull Function1<? super Dimension, ? extends Point> offset) {
        if (component2 == null) {
            HectorComponentImpl.$$$reportNull$$$0(1);
        }
        if (offset == null) {
            HectorComponentImpl.$$$reportNull$$$0(2);
        }
        this.showComponent(new RelativePoint(component2, (Point)offset.invoke((Object)this.getPreferredSize())));
    }

    @Override
    public void showComponent(@NotNull RelativePoint point) {
        if (point == null) {
            HectorComponentImpl.$$$reportNull$$$0(3);
        }
        JBPopup hector = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)this, (JComponent)this).setRequestFocus(true).setMovable(true).setCancelCallback(() -> {
            for (HectorComponentPanel additionalPanel : this.myAdditionalPanels) {
                if (additionalPanel.canClose()) continue;
                return Boolean.FALSE;
            }
            this.onClose();
            return Boolean.TRUE;
        }).createPopup();
        Disposer.register((Disposable)this.myFile.getProject(), () -> {
            JBPopup oldHector = this.getOldHector();
            if (oldHector != null && !oldHector.isDisposed()) {
                Disposer.dispose((Disposable)oldHector);
            }
            Disposer.dispose((Disposable)hector);
        });
        JBPopup oldHector = this.getOldHector();
        if (oldHector != null) {
            oldHector.cancel();
        } else {
            this.myHectorRef = new WeakReference<JBPopup>(hector);
            UIEventLogger.logUIEvent((UIEventId)UIEventId.HectorPopupDisplayed);
            hector.show(point);
        }
    }

    @Nullable
    private JBPopup getOldHector() {
        if (this.myHectorRef == null) {
            return null;
        }
        JBPopup hector = (JBPopup)this.myHectorRef.get();
        if (hector == null || !hector.isVisible()) {
            this.myHectorRef = null;
            return null;
        }
        return hector;
    }

    private void onClose() {
        if (this.isModified()) {
            for (HectorComponentPanel panel2 : this.myAdditionalPanels) {
                try {
                    panel2.apply();
                }
                catch (ConfigurationException configurationException) {}
            }
            this.forceDaemonRestart();
        }
    }

    private void forceDaemonRestart() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            assert (root != null) : "No root in " + viewProvider + " for " + language;
            int value2 = slider.getValue();
            if (value2 == 1) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_HIGHLIGHTING);
                continue;
            }
            if (value2 == 2) {
                HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.SKIP_INSPECTION);
                continue;
            }
            HighlightLevelUtil.forceRootHighlighting((PsiElement)root, FileHighlightingSetting.FORCE_HIGHLIGHTING);
        }
        InjectedLanguageManager.getInstance((Project)this.myFile.getProject()).dropFileCaches(this.myFile);
        DaemonCodeAnalyzer analyzer = DaemonCodeAnalyzer.getInstance((Project)this.myFile.getProject());
        analyzer.restart();
    }

    private boolean isModified() {
        FileViewProvider viewProvider = this.myFile.getViewProvider();
        for (Language language : this.mySliders.keySet()) {
            JSlider slider = this.mySliders.get(language);
            PsiFile root = viewProvider.getPsi(language);
            HighlightingLevelManager highlightingLevelManager = HighlightingLevelManager.getInstance(this.myFile.getProject());
            if (root == null || HectorComponentImpl.getValue(highlightingLevelManager.shouldHighlight((PsiElement)root), highlightingLevelManager.shouldInspect((PsiElement)root)) == slider.getValue()) continue;
            return true;
        }
        for (HectorComponentPanel panel2 : this.myAdditionalPanels) {
            if (!panel2.isModified()) continue;
            return true;
        }
        return false;
    }

    private static int getValue(boolean isSyntaxHighlightingEnabled, boolean isInspectionsHighlightingEnabled) {
        if (!isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 1;
        }
        if (isSyntaxHighlightingEnabled && !isInspectionsHighlightingEnabled) {
            return 2;
        }
        return 3;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "offset";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/daemon/impl/HectorComponentImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showComponent";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

