/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.impl.DaemonCodeAnalyzerEx;
import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.codeInsight.daemon.impl.DaemonProgressIndicator;
import com.intellij.codeInsight.daemon.impl.FileStatusMap;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.VisibleHighlightingPassFactory;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.HintAction;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorActivityManager;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;

public class ShowAutoImportPass
extends TextEditorHighlightingPass {
    private final Editor myEditor;
    private final PsiFile myFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final boolean hasDirtyTextRange;

    ShowAutoImportPass(@NotNull Project project, @NotNull PsiFile file2, @NotNull Editor editor) {
        if (project == null) {
            ShowAutoImportPass.$$$reportNull$$$0(0);
        }
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            ShowAutoImportPass.$$$reportNull$$$0(2);
        }
        super(project, editor.getDocument(), false);
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.myEditor = editor;
        ProperTextRange range2 = VisibleHighlightingPassFactory.calculateVisibleRange(this.myEditor);
        this.myStartOffset = range2.getStartOffset();
        this.myEndOffset = range2.getEndOffset();
        this.myFile = file2;
        this.hasDirtyTextRange = FileStatusMap.getDirtyTextRange(editor, 4) != null;
    }

    @Override
    public void doCollectInformation(@NotNull ProgressIndicator progress2) {
        if (progress2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(3);
        }
    }

    @Override
    public void doApplyInformationToEditor() {
        ApplicationManager.getApplication().invokeLater(this::showImports);
    }

    private void showImports() {
        Application application = ApplicationManager.getApplication();
        application.assertIsDispatchThread();
        if (!EditorActivityManager.getInstance().isFocused(this.myEditor)) {
            return;
        }
        if (DumbService.isDumb((Project)this.myProject) || !this.myFile.isValid()) {
            return;
        }
        if (this.myEditor.isDisposed() || this.myEditor instanceof EditorWindow && !((EditorWindow)this.myEditor).isValid()) {
            return;
        }
        int caretOffset = this.myEditor.getCaretModel().getOffset();
        this.importUnambiguousImports(caretOffset);
        if (this.isImportHintEnabled()) {
            List<HighlightInfo> visibleHighlights = ShowAutoImportPass.getVisibleHighlights(this.myStartOffset, this.myEndOffset, this.myProject, this.myEditor, this.hasDirtyTextRange);
            for (int i2 = visibleHighlights.size() - 1; i2 >= 0; --i2) {
                HighlightInfo info = visibleHighlights.get(i2);
                if (info.startOffset > caretOffset || !this.showAddImportHint(info)) continue;
                return;
            }
            for (HighlightInfo visibleHighlight : visibleHighlights) {
                if (visibleHighlight.startOffset <= caretOffset || !this.showAddImportHint(visibleHighlight)) continue;
                return;
            }
        }
    }

    private void importUnambiguousImports(int caretOffset) {
        Document document = this.myEditor.getDocument();
        ArrayList infos = new ArrayList();
        DaemonCodeAnalyzerEx.processHighlights(document, this.myProject, null, 0, document.getTextLength(), (Processor<? super HighlightInfo>)((Processor)info -> {
            if (info.hasHint() && info.getSeverity() == HighlightSeverity.ERROR && !info.getFixTextRange().containsOffset(caretOffset)) {
                infos.add(info);
            }
            return true;
        }));
        for (HighlightInfo info2 : infos) {
            HintAction action2;
            Iterator<HintAction> iterator2 = ShowAutoImportPass.extractHints(info2).iterator();
            while (!(!iterator2.hasNext() || (action2 = iterator2.next()).isAvailable(this.myProject, this.myEditor, this.myFile) && ShowAutoImportPass.mayAutoImportNow(this.myFile) && action2.fixSilently(this.myEditor))) {
            }
        }
    }

    public static boolean mayAutoImportNow(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(4);
        }
        return ShowAutoImportPass.isAddUnambiguousImportsOnTheFlyEnabled(psiFile) && (ApplicationManager.getApplication().isUnitTestMode() || DaemonListeners.canChangeFileSilently((PsiFileSystemItem)psiFile)) && ShowAutoImportPass.isInModelessContext(psiFile.getProject());
    }

    private static boolean isInModelessContext(@NotNull Project project) {
        if (project == null) {
            ShowAutoImportPass.$$$reportNull$$$0(5);
        }
        return Registry.is((String)"ide.perProjectModality") ? !LaterInvocator.isInModalContextForProject(project) : !LaterInvocator.isInModalContext();
    }

    public static boolean isAddUnambiguousImportsOnTheFlyEnabled(@NotNull PsiFile psiFile) {
        PsiFile templateFile;
        if (psiFile == null) {
            ShowAutoImportPass.$$$reportNull$$$0(6);
        }
        if ((templateFile = PsiUtilCore.getTemplateLanguageFile((PsiElement)psiFile)) == null) {
            return false;
        }
        boolean isJsp = templateFile.getFileType().getName().equals("JSP") || templateFile.getFileType().getName().equals("JSPX");
        return isJsp ? CodeInsightSettings.getInstance().JSP_ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY : CodeInsightSettings.getInstance().ADD_UNAMBIGIOUS_IMPORTS_ON_THE_FLY;
    }

    @NotNull
    private static List<HighlightInfo> getVisibleHighlights(int startOffset, int endOffset, @NotNull Project project, @NotNull Editor editor, boolean isDirty) {
        if (project == null) {
            ShowAutoImportPass.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            ShowAutoImportPass.$$$reportNull$$$0(8);
        }
        ArrayList<HighlightInfo> highlights = new ArrayList<HighlightInfo>();
        int offset = editor.getCaretModel().getOffset();
        DaemonCodeAnalyzerEx.processHighlights(editor.getDocument(), project, null, startOffset, endOffset, (Processor<? super HighlightInfo>)((Processor)info -> {
            if (!isDirty && !info.getFixTextRange().contains(offset)) {
                return true;
            }
            if (info.hasHint() && !editor.getFoldingModel().isOffsetCollapsed(info.startOffset)) {
                highlights.add((HighlightInfo)info);
            }
            return true;
        }));
        ArrayList<HighlightInfo> arrayList = highlights;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private boolean showAddImportHint(@NotNull HighlightInfo info) {
        PsiElement element2;
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(10);
        }
        if ((element2 = this.myFile.findElementAt(info.startOffset)) == null || !element2.isValid()) {
            return false;
        }
        for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
            if (!action2.isAvailable(this.myProject, this.myEditor, this.myFile) || !action2.showHint(this.myEditor)) continue;
            return true;
        }
        return false;
    }

    public static void fixAllImportsSilently(@NotNull PsiFile file2, @NotNull List<? extends HintAction> actions) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(11);
        }
        if (actions == null) {
            ShowAutoImportPass.$$$reportNull$$$0(12);
        }
        if (actions.isEmpty()) {
            return;
        }
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return;
        }
        ImaginaryEditor editor = new ImaginaryEditor(file2.getProject(), document);
        for (HintAction hintAction : actions) {
            hintAction.fixSilently((Editor)editor);
        }
    }

    @NotNull
    public static List<HintAction> getImportHints(@NotNull PsiFile file2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(13);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            List<HintAction> list2 = Collections.emptyList();
            if (list2 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(14);
            }
            return list2;
        }
        Project project = file2.getProject();
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file2);
        if (document == null || !ShowAutoImportPass.hasUnresolvedReferences(file2)) {
            List<HintAction> list3 = Collections.emptyList();
            if (list3 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(15);
            }
            return list3;
        }
        DaemonProgressIndicator progress2 = new DaemonProgressIndicator();
        AtomicReference infos = new AtomicReference(Collections.emptyList());
        ((ApplicationImpl)ApplicationManager.getApplication()).executeByImpatientReader(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> infos.set(DaemonCodeAnalyzerEx.getInstanceEx(project).runMainPasses(file2, document, progress2)), (ProgressIndicator)progress2));
        ArrayList<HintAction> result2 = new ArrayList<HintAction>(infos.get().size());
        for (HighlightInfo info : infos.get()) {
            for (HintAction action2 : ShowAutoImportPass.extractHints(info)) {
                if (!action2.isAvailable(project, null, file2)) continue;
                result2.add(action2);
            }
        }
        ArrayList<HintAction> arrayList = result2;
        if (arrayList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private static boolean hasUnresolvedReferences(@NotNull PsiFile file2) {
        if (file2 == null) {
            ShowAutoImportPass.$$$reportNull$$$0(17);
        }
        final Ref result2 = new Ref((Object)false);
        file2.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element2) {
                if (element2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element2 instanceof PsiReference && ((PsiReference)element2).resolve() == null) {
                    result2.set((Object)true);
                    this.stopWalking();
                }
                super.visitElement(element2);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass$1", "visitElement"));
            }
        });
        return (Boolean)result2.get();
    }

    private boolean isImportHintEnabled() {
        return DaemonCodeAnalyzerSettings.getInstance().isImportHintEnabled() && DaemonCodeAnalyzer.getInstance((Project)this.myProject).isImportHintsEnabled(this.myFile);
    }

    @NotNull
    private static List<HintAction> extractHints(@NotNull HighlightInfo info) {
        List<Pair<HighlightInfo.IntentionActionDescriptor, TextRange>> list2;
        if (info == null) {
            ShowAutoImportPass.$$$reportNull$$$0(18);
        }
        if ((list2 = info.quickFixActionRanges) == null) {
            List<HintAction> list3 = Collections.emptyList();
            if (list3 == null) {
                ShowAutoImportPass.$$$reportNull$$$0(19);
            }
            return list3;
        }
        SmartList hintActions = new SmartList();
        for (Pair<HighlightInfo.IntentionActionDescriptor, TextRange> pair : list2) {
            IntentionAction action2 = ((HighlightInfo.IntentionActionDescriptor)pair.getFirst()).getAction();
            if (!(action2 instanceof HintAction)) continue;
            hintActions.add((HintAction)action2);
        }
        SmartList smartList = hintActions;
        if (smartList == null) {
            ShowAutoImportPass.$$$reportNull$$$0(20);
        }
        return smartList;
    }

    @NotNull
    public static String getMessage(boolean multiple, @NotNull String name) {
        if (name == null) {
            ShowAutoImportPass.$$$reportNull$$$0(21);
        }
        String messageKey = multiple ? "import.popup.multiple" : "import.popup.text";
        String hintText = DaemonBundle.message((String)messageKey, (Object[])new Object[]{name});
        String string = hintText = hintText + " " + KeymapUtil.getFirstKeyboardShortcutText((AnAction)ActionManager.getInstance().getAction("ShowIntentionActions"));
        if (string == null) {
            ShowAutoImportPass.$$$reportNull$$$0(22);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progress";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/ShowAutoImportPass";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getVisibleHighlights";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportHints";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "extractHints";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doCollectInformation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mayAutoImportNow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isInModelessContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAddUnambiguousImportsOnTheFlyEnabled";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getVisibleHighlights";
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "showAddImportHint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fixAllImportsSilently";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getImportHints";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedReferences";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "extractHints";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 14: 
            case 15: 
            case 16: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

