/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExpandToLevelAction
extends EditorAction {
    protected BaseExpandToLevelAction(final int level, final boolean expandAll) {
        super((EditorActionHandler)new BaseFoldingHandler(){

            protected void doExecute(@NotNull Editor editor, @Nullable Caret caret, DataContext dataContext) {
                if (editor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (caret == null) {
                    caret = editor.getCaretModel().getPrimaryCaret();
                }
                int offset = caret.getOffset();
                FoldRegion rootRegion = null;
                if (!expandAll) {
                    FoldRegion[] regions;
                    rootRegion = FoldingUtil.findFoldRegionStartingAtLine(editor, editor.getDocument().getLineNumber(offset));
                    if (rootRegion == null && (regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)).length > 0) {
                        rootRegion = regions[0];
                    }
                    if (rootRegion == null) {
                        return;
                    }
                }
                FoldRegion root = rootRegion;
                int[] rootLevel = new int[]{root == null ? 1 : -1};
                editor.getFoldingModel().runBatchFoldingOperation(() -> {
                    Iterator<FoldRegion> regionTreeIterator = FoldingUtil.createFoldTreeIterator(editor);
                    LinkedList<FoldRegion> currentStack = new LinkedList<FoldRegion>();
                    while (regionTreeIterator.hasNext()) {
                        FoldRegion region = regionTreeIterator.next();
                        while (!currentStack.isEmpty() && !BaseExpandToLevelAction.isChild((FoldRegion)currentStack.peek(), region)) {
                            if (currentStack.remove() != root) continue;
                            rootLevel[0] = -1;
                        }
                        currentStack.push(region);
                        int currentLevel = currentStack.size();
                        if (region == root) {
                            rootLevel[0] = currentLevel;
                        }
                        if (rootLevel[0] < 0) continue;
                        int relativeLevel = currentLevel - rootLevel[0];
                        if (relativeLevel < level) {
                            region.setExpanded(true);
                            continue;
                        }
                        if (relativeLevel != level) continue;
                        region.setExpanded(false);
                    }
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/folding/impl/actions/BaseExpandToLevelAction$1", "doExecute"));
            }
        });
    }

    private static boolean isChild(@NotNull FoldRegion parent, @NotNull FoldRegion child2) {
        if (parent == null) {
            BaseExpandToLevelAction.$$$reportNull$$$0(0);
        }
        if (child2 == null) {
            BaseExpandToLevelAction.$$$reportNull$$$0(1);
        }
        return child2.getStartOffset() >= parent.getStartOffset() && child2.getEndOffset() <= parent.getEndOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "parent";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "child";
                break;
            }
        }
        objectArray[1] = "com/intellij/codeInsight/folding/impl/actions/BaseExpandToLevelAction";
        objectArray[2] = "isChild";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

