/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceScope {
    public abstract GlobalSearchScope getGlobalSearchScope();

    public abstract Project getProject();

    public abstract GlobalSearchScope getLibrariesScope();

    @NotNull
    private static Map<Module, Collection<Module>> buildAllDependencies(@NotNull Project project) {
        if (project == null) {
            SourceScope.$$$reportNull$$$0(0);
        }
        Graph graph2 = ModuleManager.getInstance((Project)project).moduleGraph();
        HashMap<Module, Collection<Module>> result2 = new HashMap<Module, Collection<Module>>();
        for (Module module : graph2.getNodes()) {
            SourceScope.buildDependenciesForModule(module, (Graph<Module>)graph2, result2);
        }
        HashMap<Module, Collection<Module>> hashMap = result2;
        if (hashMap == null) {
            SourceScope.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void buildDependenciesForModule(@NotNull Module module, final Graph<Module> graph2, Map<Module, Collection<Module>> map2) {
        if (module == null) {
            SourceScope.$$$reportNull$$$0(2);
        }
        final HashSet deps = new HashSet();
        map2.put(module, deps);
        new Object(){

            void traverse(Module m) {
                Iterator iterator2 = graph2.getIn((Object)m);
                while (iterator2.hasNext()) {
                    Module dep = (Module)iterator2.next();
                    if (deps.contains(dep)) continue;
                    deps.add(dep);
                    this.traverse(dep);
                }
            }
        }.traverse(module);
    }

    public static SourceScope wholeProject(final Project project) {
        return new SourceScope(){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return GlobalSearchScope.allScope((Project)project);
            }

            @Override
            public Project getProject() {
                return project;
            }

            @Override
            public Module[] getModulesToCompile() {
                return ModuleManager.getInstance((Project)project).getModules();
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return this.getGlobalSearchScope();
            }
        };
    }

    public static SourceScope modulesWithDependencies(final Module[] modules2) {
        if (modules2 == null || modules2.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules2[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> module.getModuleRuntimeScope(true));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> new ModuleWithDependenciesAndLibsDependencies(module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules2;
            }
        };
    }

    private static GlobalSearchScope evaluateScopesAndUnite(Module[] modules2, ScopeForModuleEvaluator evaluator) {
        GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Object[])modules2, GlobalSearchScope.class, module -> evaluator.evaluate((Module)module));
        return GlobalSearchScope.union((GlobalSearchScope[])scopes);
    }

    public static SourceScope modules(final Module[] modules2) {
        if (modules2 == null || modules2.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules2[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> GlobalSearchScope.moduleScope((Module)module));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules2, module -> GlobalSearchScope.moduleWithLibrariesScope((Module)module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules2;
            }
        };
    }

    public abstract Module[] getModulesToCompile();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/SourceScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/SourceScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAllDependencies";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDependenciesForModule";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ModuleWithDependenciesAndLibsDependencies
    extends GlobalSearchScope {
        private final GlobalSearchScope myMainScope;
        private final List<GlobalSearchScope> myScopes = new ArrayList<GlobalSearchScope>();

        ModuleWithDependenciesAndLibsDependencies(Module module) {
            super(module.getProject());
            this.myMainScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            Map map2 = SourceScope.buildAllDependencies(module.getProject());
            Collection modules2 = (Collection)map2.get(module);
            for (Module dependency : modules2) {
                this.myScopes.add(GlobalSearchScope.moduleWithLibrariesScope((Module)dependency));
            }
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(0);
            }
            return this.findScopeFor(file2) != null;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(2);
            }
            GlobalSearchScope scope = this.findScopeFor(file1);
            assert (scope != null);
            if (scope.contains(file2)) {
                return scope.compare(file1, file2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(3);
            }
            return this.myMainScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        @NotNull
        public Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection collection = this.myMainScope.getUnloadedModulesBelongingToScope();
            if (collection == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Nullable
        private GlobalSearchScope findScopeFor(VirtualFile file2) {
            if (this.myMainScope.contains(file2)) {
                return this.myMainScope;
            }
            int size = this.myScopes.size();
            for (int i2 = 0; i2 < size; ++i2) {
                GlobalSearchScope scope = this.myScopes.get(i2);
                if (!scope.contains(file2)) continue;
                return scope;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ScopeForModuleEvaluator {
        public GlobalSearchScope evaluate(Module var1);
    }

    private static abstract class ModuleSourceScope
    extends SourceScope {
        private final Project myProject;

        ModuleSourceScope(Project project) {
            this.myProject = project;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }
    }
}

