/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.TestsUIUtil;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements DataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create((String)"testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    public TestTreeView() {
        this.setLargeModel(true);
    }

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model.getRoot())));
        this.getSelectionModel().setSelectionMode(model.getProperties().getSelectionMode());
        this.myModel = model;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
    }

    public Object getData(@NotNull String dataId) {
        TreePath[] paths;
        if (dataId == null) {
            TestTreeView.$$$reportNull$$$0(0);
        }
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (LangDataKeys.PSI_ELEMENT_ARRAY.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<PsiElement> els = new ArrayList<PsiElement>(paths.length);
            for (TreePath path2 : paths) {
                PsiElement psiElement;
                AbstractTestProxy test;
                if (this.isPathSelected(path2.getParentPath()) || (test = this.getSelectedTest(path2)) == null || (psiElement = (PsiElement)TestsUIUtil.getData(test, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel)) == null) continue;
                els.add(psiElement);
            }
            return els.isEmpty() ? null : els.toArray(PsiElement.EMPTY_ARRAY);
        }
        if (Location.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null && paths.length > 1) {
            ArrayList<Location> locations = new ArrayList<Location>(paths.length);
            for (TreePath path3 : paths) {
                Location location;
                AbstractTestProxy test;
                if (this.isPathSelected(path3.getParentPath()) || (test = this.getSelectedTest(path3)) == null || (location = (Location)TestsUIUtil.getData(test, Location.DATA_KEY.getName(), this.myModel)) == null) continue;
                locations.add(location);
            }
            return locations.isEmpty() ? null : locations.toArray(new Location[0]);
        }
        if (AbstractTestProxy.DATA_KEYS.is(dataId) && (paths = this.getSelectionPaths()) != null) {
            return Arrays.stream(paths).map(path -> this.getSelectedTest((TreePath)path)).filter(Objects::nonNull).toArray(AbstractTestProxy[]::new);
        }
        if (MODEL_DATA_KEY.is(dataId)) {
            return this.myModel;
        }
        TreePath selectionPath = this.getSelectionPath();
        if (selectionPath == null) {
            return null;
        }
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return null;
        }
        try {
            return TestsUIUtil.getData(testProxy, dataId, this.myModel);
        }
        catch (IndexNotReadyException ignore) {
            return null;
        }
    }

    public void performCopy(@NotNull DataContext dataContext) {
        AbstractTestProxy selectedTest;
        PsiElement element2;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(1);
        }
        String fqn = (element2 = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null ? CopyReferenceAction.elementToFqn(element2) : ((selectedTest = this.getSelectedTest()) != null ? selectedTest.getLocationUrl() : null);
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(fqn));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        AbstractTestProxy test;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(2);
        }
        return (test = this.getSelectedTest()) != null && test.getLocationUrl() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(3);
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
        new TreeSpeedSearch(this, (Convertor<? super TreePath, String>)((Convertor)path -> {
            AbstractTestProxy testProxy = this.getSelectedTest((TreePath)path);
            if (testProxy == null) {
                return null;
            }
            return this.getPresentableName(testProxy);
        }));
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupHandler((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), obj -> {
            Object element2;
            Object userObject;
            if (obj instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)obj).getUserObject()) instanceof NodeDescriptor && (element2 = ((NodeDescriptor)userObject).getElement()) instanceof AbstractTestProxy) {
                return (PsiElement)TestsUIUtil.getData((AbstractTestProxy)element2, CommonDataKeys.PSI_ELEMENT.getName(), this.myModel);
            }
            return null;
        });
    }

    protected String getPresentableName(AbstractTestProxy testProxy) {
        return testProxy.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        objectArray2[1] = "com/intellij/execution/testframework/TestTreeView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getData";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "performCopy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyEnabled";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCopyVisible";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

