/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.usages.impl;

import com.intellij.find.FindBundle;
import com.intellij.find.usages.NonConfigurableUsageHandler;
import com.intellij.find.usages.UsageOptions;
import com.intellij.model.Symbol;
import com.intellij.model.presentation.SymbolPresentation;
import com.intellij.model.presentation.SymbolPresentationService;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.search.SearchService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.EmptyQuery;
import com.intellij.util.QueriesKt;
import com.intellij.util.Query;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0012\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\n\u001a\u00020\u000bH\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/find/usages/impl/DefaultSymbolUsageHandler;", "Lcom/intellij/find/usages/NonConfigurableUsageHandler;", "project", "Lcom/intellij/openapi/project/Project;", "symbol", "Lcom/intellij/model/Symbol;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/model/Symbol;)V", "buildSearchQuery", "Lcom/intellij/util/Query;", "Lcom/intellij/usages/Usage;", "options", "Lcom/intellij/find/usages/UsageOptions;", "createUsage", "reference", "Lcom/intellij/model/psi/PsiSymbolReference;", "getMaximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getSearchString", "", "intellij.platform.lang.impl"})
public final class DefaultSymbolUsageHandler
extends NonConfigurableUsageHandler {
    private final Project project;
    private final Symbol symbol;

    @Override
    @NotNull
    public SearchScope getMaximalSearchScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        return (SearchScope)globalSearchScope;
    }

    @Override
    @NotNull
    protected String getSearchString(@NotNull UsageOptions options2) {
        Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
        SymbolPresentation symbolPresentation = SymbolPresentationService.getInstance().getSymbolPresentation(this.symbol);
        Intrinsics.checkExpressionValueIsNotNull((Object)symbolPresentation, (String)"SymbolPresentationServic\u2026ymbolPresentation(symbol)");
        String string = symbolPresentation.getShortNameString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"SymbolPresentationServic\u2026n(symbol).shortNameString");
        String shortNameString = string;
        String string2 = FindBundle.message("usages.search.title.default", shortNameString);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"FindBundle.message(\"usag\u2026efault\", shortNameString)");
        return string2;
    }

    @Override
    @NotNull
    protected Query<? extends Usage> buildSearchQuery(@NotNull UsageOptions options2) {
        Intrinsics.checkParameterIsNotNull((Object)options2, (String)"options");
        if (options2.isUsages()) {
            Query query = SearchService.getInstance().searchPsiSymbolReferences(this.project, this.symbol, options2.getSearchScope());
            Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"SearchService.getInstanc\u2026bol, options.searchScope)");
            return QueriesKt.mapNotNull((Query)query, (Function1)((Function1)new Function1<PsiSymbolReference, Usage>(this){

                @Nullable
                public final Usage invoke(@NotNull PsiSymbolReference p1) {
                    Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                    return DefaultSymbolUsageHandler.access$createUsage((DefaultSymbolUsageHandler)this.receiver, p1);
                }

                public final KDeclarationContainer getOwner() {
                    return Reflection.getOrCreateKotlinClass(DefaultSymbolUsageHandler.class);
                }

                public final String getName() {
                    return "createUsage";
                }

                public final String getSignature() {
                    return "createUsage(Lcom/intellij/model/psi/PsiSymbolReference;)Lcom/intellij/usages/Usage;";
                }
            }));
        }
        Query query = EmptyQuery.getEmptyQuery();
        Intrinsics.checkExpressionValueIsNotNull((Object)query, (String)"EmptyQuery.getEmptyQuery()");
        return query;
    }

    private final Usage createUsage(PsiSymbolReference reference2) {
        TextRange textRange = reference2.getRangeInElement();
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"reference.rangeInElement");
        TextRange rangeInElement = textRange;
        UsageInfo usageInfo = new UsageInfo(reference2.getElement(), rangeInElement.getStartOffset(), rangeInElement.getEndOffset(), false);
        return (Usage)new UsageInfo2UsageAdapter(usageInfo);
    }

    public DefaultSymbolUsageHandler(@NotNull Project project, @NotNull Symbol symbol) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)symbol, (String)"symbol");
        this.project = project;
        this.symbol = symbol;
    }

    public static final /* synthetic */ Usage access$createUsage(DefaultSymbolUsageHandler $this, PsiSymbolReference reference2) {
        return $this.createUsage(reference2);
    }
}

