/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.customRegions;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.structureView.customRegions.CustomRegionTreeElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.folding.CustomFoldingBuilder;
import com.intellij.lang.folding.CustomFoldingProvider;
import com.intellij.lang.folding.FoldingBuilder;
import com.intellij.lang.folding.LanguageFolding;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomRegionStructureUtil {
    public static Collection<StructureViewTreeElement> groupByCustomRegions(@NotNull PsiElement rootElement, @NotNull Collection<StructureViewTreeElement> originalElements) {
        if (rootElement == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(0);
        }
        if (originalElements == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(1);
        }
        if (rootElement instanceof PsiFileEx && !((PsiFileEx)rootElement).isContentsLoaded() || rootElement instanceof StubBasedPsiElement && ((StubBasedPsiElement)rootElement).getStub() != null) {
            return originalElements;
        }
        List physicalElements = ContainerUtil.filter(originalElements, element2 -> {
            Object value2 = element2.getValue();
            return !(value2 instanceof StubBasedPsiElement) || ((StubBasedPsiElement)value2).getStub() == null;
        });
        Set childrenRanges = ContainerUtil.map2SetNotNull((Collection)physicalElements, element2 -> {
            Object value2 = element2.getValue();
            return value2 instanceof PsiElement ? CustomRegionStructureUtil.getTextRange((PsiElement)value2) : null;
        });
        Collection<CustomRegionTreeElement> customRegions = CustomRegionStructureUtil.collectCustomRegions(rootElement, childrenRanges);
        if (customRegions.size() > 0) {
            ArrayList<StructureViewTreeElement> result2 = new ArrayList<StructureViewTreeElement>(customRegions);
            for (StructureViewTreeElement element3 : physicalElements) {
                ProgressManager.checkCanceled();
                boolean isInCustomRegion = false;
                for (CustomRegionTreeElement customRegion : customRegions) {
                    if (!customRegion.containsElement(element3)) continue;
                    customRegion.addChild(element3);
                    isInCustomRegion = true;
                    break;
                }
                if (isInCustomRegion) continue;
                result2.add(element3);
            }
            return result2;
        }
        return originalElements;
    }

    private static TextRange getTextRange(@NotNull PsiElement element2) {
        if (element2 == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(2);
        }
        PsiElement first = element2.getFirstChild();
        if (!(element2 instanceof PsiFile) && first instanceof PsiComment && !first.textContains('\n')) {
            PsiElement next = first.getNextSibling();
            if (next instanceof PsiWhiteSpace) {
                next = next.getNextSibling();
            }
            if (next != null) {
                return new TextRange(next.getTextRange().getStartOffset(), element2.getTextRange().getEndOffset());
            }
        }
        return element2.getTextRange();
    }

    private static Collection<CustomRegionTreeElement> collectCustomRegions(@NotNull PsiElement rootElement, @NotNull Set<? extends TextRange> ranges) {
        if (rootElement == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(3);
        }
        if (ranges == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(4);
        }
        TextRange rootRange = CustomRegionStructureUtil.getTextRange(rootElement);
        Iterator iterator2 = ((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)rootElement).filter(element2 -> CustomRegionStructureUtil.isCustomRegionCommentCandidate(element2) && rootRange.contains(element2.getTextRange()) && !CustomRegionStructureUtil.isInsideRanges(element2, ranges))).iterator();
        SmartList customRegions = new SmartList();
        CustomRegionTreeElement currRegionElement = null;
        CustomFoldingProvider provider = null;
        while (iterator2.hasNext()) {
            ProgressManager.checkCanceled();
            PsiElement child2 = (PsiElement)iterator2.next();
            if (provider == null) {
                provider = CustomRegionStructureUtil.getProvider(child2);
            }
            if (provider == null) continue;
            String commentText = child2.getText();
            if (provider.isCustomRegionStart(commentText)) {
                if (currRegionElement == null) {
                    currRegionElement = new CustomRegionTreeElement(child2, provider);
                    customRegions.add(currRegionElement);
                    continue;
                }
                currRegionElement = currRegionElement.createNestedRegion(child2);
                continue;
            }
            if (!provider.isCustomRegionEnd(commentText) || currRegionElement == null) continue;
            currRegionElement = currRegionElement.endRegion(child2);
        }
        return customRegions;
    }

    @Nullable
    static CustomFoldingProvider getProvider(@NotNull PsiElement element2) {
        ASTNode node;
        if (element2 == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(5);
        }
        if ((node = element2.getNode()) != null) {
            for (CustomFoldingProvider provider : CustomFoldingProvider.getAllProviders()) {
                if (!provider.isCustomRegionStart(node.getText())) continue;
                return provider;
            }
        }
        return null;
    }

    private static boolean isInsideRanges(@NotNull PsiElement element2, @NotNull Set<? extends TextRange> ranges) {
        if (element2 == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(6);
        }
        if (ranges == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(7);
        }
        for (TextRange textRange : ranges) {
            TextRange elementRange;
            if (!textRange.contains((elementRange = element2.getTextRange()).getStartOffset()) && !textRange.contains(elementRange.getEndOffset())) continue;
            return true;
        }
        return false;
    }

    private static boolean isCustomRegionCommentCandidate(@NotNull PsiElement element2) {
        Language language;
        if (element2 == null) {
            CustomRegionStructureUtil.$$$reportNull$$$0(8);
        }
        if (!Language.ANY.is(language = element2.getLanguage())) {
            for (FoldingBuilder builder2 : LanguageFolding.INSTANCE.allForLanguage(language)) {
                if (!(builder2 instanceof CustomFoldingBuilder)) continue;
                return ((CustomFoldingBuilder)builder2).isCustomFoldingCandidate(element2);
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalElements";
                break;
            }
            case 2: 
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/structureView/customRegions/CustomRegionStructureUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "groupByCustomRegions";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getTextRange";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "collectCustomRegions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getProvider";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideRanges";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isCustomRegionCommentCandidate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

