/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.todo.CurrentFileTodosTreeBuilder;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFileDirAndModuleComparator;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.BaseToDoNode;
import com.intellij.ide.todo.nodes.ModuleToDoNode;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class SummaryNode
extends BaseToDoNode<ToDoSummary> {
    public SummaryNode(Project project, @NotNull ToDoSummary value2, TodoTreeBuilder builder2) {
        if (value2 == null) {
            SummaryNode.$$$reportNull$$$0(0);
        }
        super(project, value2, builder2);
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        ArrayList children2 = new ArrayList();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (this.myToDoSettings.isModulesShown()) {
            Iterator<PsiFile> i2 = this.myBuilder.getAllFiles();
            while (i2.hasNext()) {
                PsiFile psiFile = i2.next();
                if (psiFile == null) continue;
                VirtualFile virtualFile = psiFile.getVirtualFile();
                this.createModuleTodoNodeForFile(children2, projectFileIndex, virtualFile);
            }
        } else if (this.myToDoSettings.getIsPackagesShown()) {
            if (this.myBuilder instanceof CurrentFileTodosTreeBuilder) {
                Iterator<PsiFile> allFiles = this.myBuilder.getAllFiles();
                if (allFiles.hasNext()) {
                    children2.add((AbstractTreeNode<?>)new TodoFileNode(this.myProject, allFiles.next(), this.myBuilder, false));
                }
            } else {
                TodoTreeHelper.getInstance(this.getProject()).addPackagesToChildren(children2, null, this.myBuilder);
            }
        } else {
            Iterator<PsiFile> i3 = this.myBuilder.getAllFiles();
            while (i3.hasNext()) {
                PsiFile psiFile = i3.next();
                if (psiFile == null) continue;
                TodoFileNode fileNode = new TodoFileNode(this.getProject(), psiFile, this.myBuilder, false);
                if (!this.getTreeStructure().accept(psiFile) || children2.contains((Object)fileNode)) continue;
                children2.add((AbstractTreeNode<?>)fileNode);
            }
        }
        children2.sort(TodoFileDirAndModuleComparator.INSTANCE);
        ArrayList arrayList = children2;
        if (arrayList == null) {
            SummaryNode.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    protected void createModuleTodoNodeForFile(ArrayList<? super AbstractTreeNode<?>> children2, ProjectFileIndex projectFileIndex, VirtualFile virtualFile) {
        ModuleToDoNode moduleToDoNode;
        Module module = projectFileIndex.getModuleForFile(virtualFile);
        if (module != null && !children2.contains((Object)(moduleToDoNode = new ModuleToDoNode(this.getProject(), module, this.myBuilder)))) {
            children2.add(moduleToDoNode);
        }
    }

    public void update(@NotNull PresentationData presentation2) {
        if (presentation2 == null) {
            SummaryNode.$$$reportNull$$$0(2);
        }
        int todoItemCount = this.getTodoItemCount((ToDoSummary)this.getValue());
        int fileCount = this.getFileCount((ToDoSummary)this.getValue());
        presentation2.setPresentableText(IdeBundle.message((String)"node.todo.summary", (Object[])new Object[]{todoItemCount, fileCount}));
    }

    public String getTestPresentation() {
        return "Summary";
    }

    @Override
    public int getFileCount(ToDoSummary summary) {
        int count = 0;
        Iterator<PsiFile> i2 = this.myBuilder.getAllFiles();
        while (i2.hasNext()) {
            PsiFile psiFile = i2.next();
            if (psiFile == null || !this.getTreeStructure().accept(psiFile)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public int getTodoItemCount(ToDoSummary val) {
        int count = 0;
        Iterator<PsiFile> i2 = this.myBuilder.getAllFiles();
        while (i2.hasNext()) {
            count += ((Integer)ReadAction.compute(() -> this.getTreeStructure().getTodoItemCount((PsiFile)i2.next()))).intValue();
        }
        return count;
    }

    public int getWeight() {
        return 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/SummaryNode";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/SummaryNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

