/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.dir;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.impl.dir.DirDiffPanel;
import com.intellij.openapi.diff.impl.dir.DirDiffTableModel;
import com.intellij.openapi.diff.impl.dir.DirDiffWindow;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.table.JBTable;
import javax.swing.Action;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DirDiffDialog
extends DialogWrapper {
    private final DirDiffTableModel myModel;
    private DirDiffPanel myDiffPanel;

    public DirDiffDialog(Project project, DirDiffTableModel model) {
        super(project);
        this.setModal(false);
        this.myModel = model;
        this.setTitle(DiffBundle.message((String)"directory.diff", (Object[])new Object[0]));
        this.init();
        JBTable table = this.myDiffPanel.getTable();
        table.setColumnSelectionAllowed(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.getTableHeader().setResizingAllowed(false);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myModel);
        Disposer.register((Disposable)project, (Disposable)this.getDisposable());
    }

    protected String getDimensionServiceKey() {
        this.setSize(800, 600);
        this.myDiffPanel.setupSplitter();
        return "DirDiffDialog";
    }

    protected JComponent createCenterPanel() {
        this.myDiffPanel = new DirDiffPanel(this.myModel, new DirDiffWindow.Dialog(this));
        Disposer.register((Disposable)this.getDisposable(), (Disposable)this.myDiffPanel);
        return this.myDiffPanel.getPanel();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDiffPanel.getTable();
    }

    protected Action @NotNull [] createActions() {
        return new Action[0];
    }

    protected String getHelpId() {
        return "reference.dialogs.diff.folder";
    }
}

