/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CutLineActionHandler
extends EditorWriteActionHandler {
    private final boolean myToLineStart;

    CutLineActionHandler(boolean toLineStart) {
        super(true);
        this.myToLineStart = toLineStart;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        int end;
        int start2;
        if (caret == null) {
            caret = editor.getCaretModel().getCurrentCaret();
        }
        if (caret.hasSelection()) {
            CutLineActionHandler.delete(editor, caret, caret.getSelectionStart(), caret.getSelectionEnd());
            return;
        }
        Document doc = editor.getDocument();
        int caretOffset = caret.getOffset();
        if (this.myToLineStart && caretOffset == 0 || !this.myToLineStart && caretOffset >= doc.getTextLength()) {
            return;
        }
        int lineNumber = doc.getLineNumber(caretOffset);
        int lineEndOffset = doc.getLineEndOffset(lineNumber);
        int lineStartOffset = doc.getLineStartOffset(lineNumber);
        if (this.myToLineStart) {
            start2 = caret.getLogicalPosition().column == 0 ? lineStartOffset - 1 : lineStartOffset;
            end = caretOffset;
        } else if (caretOffset >= lineEndOffset) {
            start2 = lineEndOffset;
            end = lineEndOffset + 1;
        } else {
            start2 = caretOffset;
            end = lineEndOffset;
            if (lineEndOffset < doc.getTextLength() && CharArrayUtil.isEmptyOrSpaces((CharSequence)doc.getCharsSequence(), (int)caretOffset, (int)lineEndOffset)) {
                ++end;
            }
        }
        CutLineActionHandler.delete(editor, caret, start2, end);
    }

    private static void delete(@NotNull Editor editor, @NotNull Caret caret, int start2, int end) {
        if (editor == null) {
            CutLineActionHandler.$$$reportNull$$$0(0);
        }
        if (caret == null) {
            CutLineActionHandler.$$$reportNull$$$0(1);
        }
        CopyPasteManager.getInstance().stopKillRings();
        editor.getDocument().deleteString(start2, end);
        caret.moveToOffset(start2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "caret";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/editor/actions/CutLineActionHandler";
        objectArray[2] = "delete";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

