/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.HardReferencingRangeMarkerTree;
import com.intellij.openapi.editor.impl.IntervalTreeImpl;
import com.intellij.openapi.editor.impl.RangeMarkerImpl;
import com.intellij.openapi.editor.impl.RangeMarkerTree;
import com.intellij.openapi.util.Getter;
import java.util.function.IntSupplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MarkerTreeWithPartialSums<T extends RangeMarkerImpl>
extends HardReferencingRangeMarkerTree<T> {
    MarkerTreeWithPartialSums(@NotNull Document document) {
        if (document == null) {
            MarkerTreeWithPartialSums.$$$reportNull$$$0(0);
        }
        super(document);
    }

    @Override
    protected Node<T> getRoot() {
        return (Node)super.getRoot();
    }

    void valueUpdated(T marker) {
        Node node = (Node)this.lookupNode(marker);
        if (node != null) {
            node.recalculateSubTreeSumUp();
        }
    }

    int getSumOfValuesUpToOffset(int offset) {
        return this.getSumOfValuesForOverlappingRanges((Node<T>)this.getRoot(), offset, 0);
    }

    private int getSumOfValuesForOverlappingRanges(@Nullable Node<T> node, int offset, int deltaUpToRootExclusive) {
        if (node == null) {
            return 0;
        }
        int delta = deltaUpToRootExclusive + node.delta;
        if (offset >= node.maxEnd + delta) {
            return ((Node)node).subtreeSum;
        }
        int value2 = this.getSumOfValuesForOverlappingRanges((Node<T>)node.getLeft(), offset, delta);
        if (offset >= node.intervalStart() + delta) {
            value2 += ((Node)node).getLocalSum();
            value2 += this.getSumOfValuesForOverlappingRanges((Node<T>)node.getRight(), offset, delta);
        }
        return value2;
    }

    @Override
    @NotNull
    protected RangeMarkerTree.RMNode<T> createNewNode(@NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight, int layer) {
        if (key == null) {
            MarkerTreeWithPartialSums.$$$reportNull$$$0(1);
        }
        assert (start2 == end);
        assert (!greedyToLeft);
        assert (!greedyToRight);
        return new Node<T>(this, key, start2, start2, false, false, stickingToRight);
    }

    @Override
    void correctMax(@NotNull IntervalTreeImpl.IntervalNode<T> node, int deltaUpToRoot) {
        if (node == null) {
            MarkerTreeWithPartialSums.$$$reportNull$$$0(2);
        }
        super.correctMax(node, deltaUpToRoot);
        ((Node)node).recalculateSubTreeSum();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/editor/impl/MarkerTreeWithPartialSums";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createNewNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "correctMax";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static class Node<T extends RangeMarkerImpl>
    extends RangeMarkerTree.RMNode<T> {
        private int subtreeSum;

        Node(@NotNull RangeMarkerTree<T> rangeMarkerTree, @NotNull T key, int start2, int end, boolean greedyToLeft, boolean greedyToRight, boolean stickingToRight) {
            if (rangeMarkerTree == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (key == null) {
                Node.$$$reportNull$$$0(1);
            }
            super(rangeMarkerTree, key, start2, end, greedyToLeft, greedyToRight, stickingToRight);
        }

        @Override
        public Node<T> getLeft() {
            return (Node)super.getLeft();
        }

        @Override
        public Node<T> getRight() {
            return (Node)super.getRight();
        }

        @Override
        public Node<T> getParent() {
            return (Node)super.getParent();
        }

        private int getLocalSum() {
            int sum = 0;
            for (Getter g : this.intervals) {
                sum += ((IntSupplier)((Object)((RangeMarkerImpl)g.get()))).getAsInt();
            }
            return sum;
        }

        private void recalculateSubTreeSum() {
            IntervalTreeImpl.IntervalNode right;
            this.subtreeSum = this.getLocalSum();
            IntervalTreeImpl.IntervalNode left = this.getLeft();
            if (left != null) {
                this.subtreeSum += ((Node)left).subtreeSum;
            }
            if ((right = this.getRight()) != null) {
                this.subtreeSum += ((Node)right).subtreeSum;
            }
        }

        private void recalculateSubTreeSumUp() {
            for (IntervalTreeImpl.IntervalNode n = this; n != null; n = n.getParent()) {
                n.recalculateSubTreeSum();
            }
        }

        @Override
        void addInterval(@NotNull T interval) {
            if (interval == null) {
                Node.$$$reportNull$$$0(2);
            }
            super.addInterval(interval);
            this.recalculateSubTreeSumUp();
        }

        @Override
        void removeIntervalInternal(int i2) {
            super.removeIntervalInternal(i2);
            this.recalculateSubTreeSumUp();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rangeMarkerTree";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "key";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interval";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/editor/impl/MarkerTreeWithPartialSums$Node";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addInterval";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

