/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.suggested;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorFactoryEvent;
import com.intellij.openapi.editor.event.EditorFactoryListener;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.suggested.RefactoringAvailableGutterIconRenderer;
import com.intellij.refactoring.suggested.RefactoringDisabledGutterIconRenderer;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicator;
import com.intellij.refactoring.suggested.SuggestedRefactoringAvailabilityIndicatorKt$sam$java_util_function_Consumer$0;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000S\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004*\u0001\u0006\u0018\u0000 !2\u00020\u0001:\u0002!\"B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002J\u0006\u0010\u0015\u001a\u00020\u0013J\u0006\u0010\u0016\u001a\u00020\u0013J.\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\fH\u0002R\u0010\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "caretListener", "com/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$caretListener$1", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$caretListener$1;", "data", "Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Data;", "editorsAndHighlighters", "", "Lcom/intellij/openapi/editor/Editor;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "hasData", "", "getHasData", "()Z", "attachToEditor", "", "editor", "clear", "disable", "show", "document", "Lcom/intellij/openapi/editor/Document;", "markerRange", "Lcom/intellij/openapi/util/TextRange;", "availabilityRange", "refactoringEnabled", "tooltip", "", "updateHighlighter", "Companion", "Data", "intellij.platform.lang.impl"})
public final class SuggestedRefactoringAvailabilityIndicator {
    private Data data;
    private final Map<Editor, RangeHighlighter> editorsAndHighlighters;
    private final caretListener.1 caretListener;
    private final Project project;
    @NotNull
    private static final String disabledRefactoringTooltip;
    public static final Companion Companion;

    public final void show(@NotNull Document document, @NotNull TextRange markerRange, @NotNull TextRange availabilityRange, boolean refactoringEnabled, @NotNull String tooltip) {
        RangeMarker rangeMarker;
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)markerRange, (String)"markerRange");
        Intrinsics.checkParameterIsNotNull((Object)availabilityRange, (String)"availabilityRange");
        Intrinsics.checkParameterIsNotNull((Object)tooltip, (String)"tooltip");
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeMarker rangeMarker2 = document.createRangeMarker(markerRange);
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker2, (String)"document.createRangeMarker(markerRange)");
        RangeMarker rangeMarker3 = document.createRangeMarker(availabilityRange);
        RangeMarker rangeMarker4 = rangeMarker2;
        Document document2 = document;
        boolean bl = false;
        boolean bl2 = false;
        RangeMarker $this$apply = rangeMarker3;
        boolean bl3 = false;
        $this$apply.setGreedyToLeft(true);
        $this$apply.setGreedyToRight(true);
        RangeMarker rangeMarker5 = rangeMarker = rangeMarker3;
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeMarker5, (String)"document.createRangeMark\u2026 isGreedyToRight = true }");
        String string = tooltip;
        boolean bl4 = refactoringEnabled;
        RangeMarker rangeMarker6 = rangeMarker5;
        RangeMarker rangeMarker7 = rangeMarker4;
        Document document3 = document2;
        Data newData = new Data(document3, rangeMarker7, rangeMarker6, bl4, string);
        if (Intrinsics.areEqual((Object)newData, (Object)this.data)) {
            return;
        }
        this.clear();
        this.data = newData;
        rangeMarker3 = (Function1)new Function1<Editor, Unit>(this){

            public final void invoke(@NotNull Editor p1) {
                Intrinsics.checkParameterIsNotNull((Object)p1, (String)"p1");
                SuggestedRefactoringAvailabilityIndicator.access$attachToEditor((SuggestedRefactoringAvailabilityIndicator)this.receiver, p1);
            }

            public final KDeclarationContainer getOwner() {
                return Reflection.getOrCreateKotlinClass(SuggestedRefactoringAvailabilityIndicator.class);
            }

            public final String getName() {
                return "attachToEditor";
            }

            public final String getSignature() {
                return "attachToEditor(Lcom/intellij/openapi/editor/Editor;)V";
            }
        };
        EditorFactory.getInstance().editors(document, this.project).forEach(new SuggestedRefactoringAvailabilityIndicatorKt$sam$java_util_function_Consumer$0((Function1)rangeMarker3));
    }

    /*
     * WARNING - void declaration
     */
    public final void clear() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.data == null) {
            return;
        }
        this.data = null;
        Editor editor = this.editorsAndHighlighters;
        boolean bl = false;
        Iterator<Map.Entry<Editor, RangeHighlighter>> iterator2 = editor.entrySet().iterator();
        while (iterator2.hasNext()) {
            void editor2;
            RangeHighlighter rangeHighlighter;
            RangeHighlighter rangeHighlighter2 = rangeHighlighter = iterator2.next();
            boolean bl2 = false;
            editor = rangeHighlighter2.getKey();
            rangeHighlighter2 = rangeHighlighter;
            bl2 = false;
            RangeHighlighter highlighter = rangeHighlighter2.getValue();
            editor2.getCaretModel().removeCaretListener((CaretListener)this.caretListener);
            RangeHighlighter rangeHighlighter3 = highlighter;
            if (rangeHighlighter3 == null) continue;
            rangeHighlighter2 = rangeHighlighter3;
            bl2 = false;
            boolean bl3 = false;
            RangeHighlighter it = rangeHighlighter2;
            boolean bl4 = false;
            editor2.getMarkupModel().removeHighlighter(it);
        }
        this.editorsAndHighlighters.clear();
    }

    public final void disable() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Data data2 = this.data;
        if (data2 == null) {
            return;
        }
        Data data3 = data2;
        if (data3.getRefactoringEnabled()) {
            TextRange textRange = UtilsKt.getRange((RangeMarker)data3.getHighlighterRangeMarker());
            if (textRange == null) {
                return;
            }
            TextRange textRange2 = UtilsKt.getRange((RangeMarker)data3.getAvailabilityRangeMarker());
            if (textRange2 == null) {
                return;
            }
            this.show(data3.getDocument(), textRange, textRange2, false, data3.getTooltip());
        }
    }

    public final boolean getHasData() {
        return this.data != null;
    }

    private final void attachToEditor(Editor editor) {
        Data data2 = this.data;
        if (Intrinsics.areEqual((Object)editor.getDocument(), (Object)(data2 != null ? data2.getDocument() : null))) {
            editor.getCaretModel().addCaretListener((CaretListener)this.caretListener);
            this.updateHighlighter(editor);
        }
    }

    private final void updateHighlighter(Editor editor) {
        GutterIconRenderer gutterIconRenderer;
        Data data2;
        ApplicationManager.getApplication().assertIsDispatchThread();
        RangeHighlighter prevHighlighter = this.editorsAndHighlighters.get(editor);
        if (prevHighlighter != null) {
            editor.getMarkupModel().removeHighlighter(prevHighlighter);
            this.editorsAndHighlighters.remove(editor);
        }
        if ((data2 = this.data) == null || (data2 = data2.getAvailabilityRangeMarker()) == null || (data2 = UtilsKt.getRange((RangeMarker)data2)) == null) {
            return;
        }
        Data range2 = data2;
        CaretModel caretModel = editor.getCaretModel();
        Intrinsics.checkExpressionValueIsNotNull((Object)caretModel, (String)"editor.caretModel");
        if (!range2.containsOffset(caretModel.getOffset())) {
            return;
        }
        Data data3 = this.data;
        if (data3 == null) {
            Intrinsics.throwNpe();
        }
        TextRange textRange = UtilsKt.getRange((RangeMarker)data3.getHighlighterRangeMarker());
        if (textRange == null) {
            return;
        }
        TextRange highlighterRange = textRange;
        RangeHighlighter rangeHighlighter = editor.getMarkupModel().addRangeHighlighter(highlighterRange.getStartOffset(), highlighterRange.getEndOffset(), 6000, new TextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        Intrinsics.checkExpressionValueIsNotNull((Object)rangeHighlighter, (String)"editor.markupModel.addRa\u2026getArea.EXACT_RANGE\n    )");
        RangeHighlighter highlighter = rangeHighlighter;
        Data data4 = this.data;
        if (data4 == null) {
            Intrinsics.throwNpe();
        }
        if (data4.getRefactoringEnabled()) {
            Data data5 = this.data;
            if (data5 == null) {
                Intrinsics.throwNpe();
            }
            gutterIconRenderer = new RefactoringAvailableGutterIconRenderer(data5.getTooltip());
        } else {
            Data data6 = this.data;
            if (data6 == null) {
                Intrinsics.throwNpe();
            }
            gutterIconRenderer = new RefactoringDisabledGutterIconRenderer(data6.getTooltip());
        }
        highlighter.setGutterIconRenderer(gutterIconRenderer);
        this.editorsAndHighlighters.put(editor, highlighter);
    }

    public SuggestedRefactoringAvailabilityIndicator(@NotNull Project project) {
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        SuggestedRefactoringAvailabilityIndicator suggestedRefactoringAvailabilityIndicator = this;
        boolean bl = false;
        suggestedRefactoringAvailabilityIndicator.editorsAndHighlighters = map2 = (Map)new LinkedHashMap();
        this.caretListener = new CaretListener(this){
            final /* synthetic */ SuggestedRefactoringAvailabilityIndicator this$0;

            public void caretPositionChanged(@NotNull CaretEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
                SuggestedRefactoringAvailabilityIndicator.access$updateHighlighter(this.this$0, editor);
            }
            {
                this.this$0 = $outer;
            }
        };
        EditorFactory.getInstance().addEditorFactoryListener(new EditorFactoryListener(){

            public void editorCreated(@NotNull EditorFactoryEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                Editor editor = event.getEditor();
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"event.editor");
                this.attachToEditor(editor);
            }

            public void editorReleased(@NotNull EditorFactoryEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                editorsAndHighlighters.remove(event.getEditor());
            }
        }, (Disposable)this.project);
    }

    static {
        Companion = new Companion(null);
        String string = RefactoringBundle.message((String)"suggested.refactoring.disabled.gutter.icon.tooltip");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RefactoringBundle.messag\u2026led.gutter.icon.tooltip\")");
        disabledRefactoringTooltip = string;
    }

    public static final /* synthetic */ void access$updateHighlighter(SuggestedRefactoringAvailabilityIndicator $this, Editor editor) {
        $this.updateHighlighter(editor);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0010\b\n\u0000\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\u0015\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Data;", "", "document", "Lcom/intellij/openapi/editor/Document;", "highlighterRangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "availabilityRangeMarker", "refactoringEnabled", "", "tooltip", "", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/editor/RangeMarker;Lcom/intellij/openapi/editor/RangeMarker;ZLjava/lang/String;)V", "getAvailabilityRangeMarker", "()Lcom/intellij/openapi/editor/RangeMarker;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "getHighlighterRangeMarker", "getRefactoringEnabled", "()Z", "getTooltip", "()Ljava/lang/String;", "equals", "other", "hashCode", "", "intellij.platform.lang.impl"})
    private static final class Data {
        @NotNull
        private final Document document;
        @NotNull
        private final RangeMarker highlighterRangeMarker;
        @NotNull
        private final RangeMarker availabilityRangeMarker;
        private final boolean refactoringEnabled;
        @NotNull
        private final String tooltip;

        public boolean equals(@Nullable Object other) {
            return other instanceof Data && Intrinsics.areEqual((Object)((Data)other).document, (Object)this.document) && Intrinsics.areEqual((Object)UtilsKt.getRange((RangeMarker)((Data)other).highlighterRangeMarker), (Object)UtilsKt.getRange((RangeMarker)this.highlighterRangeMarker)) && Intrinsics.areEqual((Object)UtilsKt.getRange((RangeMarker)((Data)other).availabilityRangeMarker), (Object)UtilsKt.getRange((RangeMarker)this.availabilityRangeMarker)) && ((Data)other).refactoringEnabled == this.refactoringEnabled && Intrinsics.areEqual((Object)((Data)other).tooltip, (Object)this.tooltip);
        }

        public int hashCode() {
            return this.tooltip.hashCode();
        }

        @NotNull
        public final Document getDocument() {
            return this.document;
        }

        @NotNull
        public final RangeMarker getHighlighterRangeMarker() {
            return this.highlighterRangeMarker;
        }

        @NotNull
        public final RangeMarker getAvailabilityRangeMarker() {
            return this.availabilityRangeMarker;
        }

        public final boolean getRefactoringEnabled() {
            return this.refactoringEnabled;
        }

        @NotNull
        public final String getTooltip() {
            return this.tooltip;
        }

        public Data(@NotNull Document document, @NotNull RangeMarker highlighterRangeMarker, @NotNull RangeMarker availabilityRangeMarker, boolean refactoringEnabled, @NotNull String tooltip) {
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            Intrinsics.checkParameterIsNotNull((Object)highlighterRangeMarker, (String)"highlighterRangeMarker");
            Intrinsics.checkParameterIsNotNull((Object)availabilityRangeMarker, (String)"availabilityRangeMarker");
            Intrinsics.checkParameterIsNotNull((Object)tooltip, (String)"tooltip");
            this.document = document;
            this.highlighterRangeMarker = highlighterRangeMarker;
            this.availabilityRangeMarker = availabilityRangeMarker;
            this.refactoringEnabled = refactoringEnabled;
            this.tooltip = tooltip;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/refactoring/suggested/SuggestedRefactoringAvailabilityIndicator$Companion;", "", "()V", "disabledRefactoringTooltip", "", "Lorg/jetbrains/annotations/NotNull;", "getDisabledRefactoringTooltip", "()Ljava/lang/String;", "intellij.platform.lang.impl"})
    public static final class Companion {
        @NotNull
        public final String getDisabledRefactoringTooltip() {
            return disabledRefactoringTooltip;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

