/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.codeStyle;

import com.intellij.configurationStore.Property;
import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class PropertiesCodeStyleSettings
extends CustomCodeStyleSettings {
    public static final char[] DELIMITERS = new char[]{'=', ':', ' '};
    public boolean SPACES_AROUND_KEY_VALUE_DELIMITER;
    public boolean KEEP_BLANK_LINES;
    @Property(externalName="key_value_delimiter")
    public int KEY_VALUE_DELIMITER_CODE;

    public PropertiesCodeStyleSettings(CodeStyleSettings container) {
        super(PropertiesLanguage.INSTANCE.getID(), container);
    }

    public static PropertiesCodeStyleSettings getInstance(Project project) {
        return (PropertiesCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(PropertiesCodeStyleSettings.class);
    }

    public char getDelimiter() {
        return DELIMITERS[this.KEY_VALUE_DELIMITER_CODE];
    }

    public void readExternal(Element parentElement) throws InvalidDataException {
        super.readExternal(parentElement);
        parentElement = parentElement.getChild(this.getTagName());
        if (parentElement != null) {
            Character delimiter = null;
            for (Object o : parentElement.getChildren("option")) {
                Element e = (Element)o;
                String fieldName = e.getAttributeValue("name");
                if (!"KEY_VALUE_DELIMITER".equals(fieldName)) continue;
                String value = e.getAttributeValue("value");
                delimiter = Character.valueOf(value.charAt(0));
                break;
            }
            if (delimiter != null) {
                switch (delimiter.charValue()) {
                    case '=': {
                        this.KEY_VALUE_DELIMITER_CODE = 0;
                        break;
                    }
                    case ':': {
                        this.KEY_VALUE_DELIMITER_CODE = 1;
                        break;
                    }
                    case ' ': {
                        this.KEY_VALUE_DELIMITER_CODE = 2;
                    }
                }
            }
        }
    }

    protected void importLegacySettings(@NotNull CodeStyleSettings rootSettings) {
        if (rootSettings == null) {
            PropertiesCodeStyleSettings.$$$reportNull$$$0(0);
        }
        if (rootSettings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            rootSettings.getCommonSettings((Language)PropertiesLanguage.INSTANCE).ALIGN_GROUP_FIELD_DECLARATIONS = true;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootSettings", "com/intellij/lang/properties/psi/codeStyle/PropertiesCodeStyleSettings", "importLegacySettings"));
    }
}

