/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.commandInterface.console;

import com.intellij.execution.console.LanguageConsoleImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFileFactory;
import com.intellij.util.Consumer;
import com.jetbrains.commandInterface.command.Command;
import com.jetbrains.commandInterface.command.CommandExecutor;
import com.jetbrains.commandInterface.commandLine.CommandLineLanguage;
import com.jetbrains.commandInterface.commandLine.psi.CommandLineFile;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.psi.PyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CommandModeConsumer
implements Consumer<String> {
    @NotNull
    private static final Pattern EMPTY_SPACE = Pattern.compile("\\s+");
    @NotNull
    private final Collection<Command> myCommands;
    @NotNull
    private final Module myModule;
    @NotNull
    private final LanguageConsoleImpl myConsole;
    @Nullable
    private final CommandExecutor myDefaultExecutor;

    CommandModeConsumer(@Nullable Collection<Command> commands, @NotNull Module module, @NotNull LanguageConsoleImpl console, @Nullable CommandExecutor defaultExecutor) {
        if (module == null) {
            CommandModeConsumer.$$$reportNull$$$0(0);
        }
        if (console == null) {
            CommandModeConsumer.$$$reportNull$$$0(1);
        }
        this.myCommands = commands != null ? new ArrayList<Command>(commands) : Collections.emptyList();
        this.myModule = module;
        this.myConsole = console;
        this.myDefaultExecutor = defaultExecutor;
    }

    public void consume(String t) {
        PsiFileFactory fileFactory = PsiFileFactory.getInstance((Project)this.myModule.getProject());
        CommandLineFile file = PyUtil.as(fileFactory.createFileFromText((Language)CommandLineLanguage.INSTANCE, (CharSequence)t), CommandLineFile.class);
        if (file == null) {
            return;
        }
        String commandName = file.getCommand();
        List<String> commandAndArgs = Arrays.asList(EMPTY_SPACE.split(file.getText().trim()));
        List<String> args2 = commandAndArgs.size() > 1 ? commandAndArgs.subList(1, commandAndArgs.size()) : Collections.emptyList();
        for (Command command : this.myCommands) {
            if (!command.getName().equals(commandName)) continue;
            command.execute(commandName, this.myModule, args2, (ConsoleView)this.myConsole);
            return;
        }
        if (this.myDefaultExecutor != null && !commandAndArgs.isEmpty()) {
            this.myDefaultExecutor.execute(commandAndArgs.get(0), this.myModule, args2, (ConsoleView)this.myConsole);
        } else {
            this.myConsole.print(PyBundle.message("commandLine.commandNotFound", commandName), ConsoleViewContentType.ERROR_OUTPUT);
            this.myConsole.print("", ConsoleViewContentType.SYSTEM_OUTPUT);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "module";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "console";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/commandInterface/console/CommandModeConsumer";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

