/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.smartstepinto;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.DocumentUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyStackFrame;
import com.jetbrains.python.debugger.settings.PyDebuggerSettings;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariantVisitor;
import com.jetbrains.python.psi.PyArgumentList;
import com.jetbrains.python.psi.PyBinaryExpression;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyComprehensionElement;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyParenthesizedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class PySmartStepIntoHandler
extends XSmartStepIntoHandler<PySmartStepIntoVariant> {
    @NotNull
    private final XDebugSession mySession;
    @NotNull
    private final PyDebugProcess myProcess;

    public PySmartStepIntoHandler(@NotNull PyDebugProcess process2) {
        if (process2 == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(0);
        }
        this.mySession = process2.getSession();
        this.myProcess = process2;
    }

    public void startStepInto(@NotNull PySmartStepIntoVariant smartStepIntoVariant) {
        if (smartStepIntoVariant == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(1);
        }
        this.myProcess.startSmartStepInto(smartStepIntoVariant);
    }

    public String getPopupTitle(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(2);
        }
        return PyBundle.message("debug.popup.title.step.into.function", new Object[0]);
    }

    @NotNull
    public List<PySmartStepIntoVariant> computeSmartStepVariants(@NotNull XSourcePosition position) {
        List variantsFromPython;
        PyStackFrame currentFrame;
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(3);
        }
        if ((currentFrame = (PyStackFrame)this.mySession.getCurrentStackFrame()) == null || currentFrame.isComprehension()) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(4);
            }
            return list;
        }
        PySmartStepIntoContext context = this.createSmartStepIntoContext(currentFrame);
        if (context == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(5);
            }
            return list;
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        if (document == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(6);
            }
            return list;
        }
        Future future2 = ApplicationManager.getApplication().executeOnPooledThread(() -> this.myProcess.getSmartStepIntoVariants(context.getStartLine(), context.getEndLine()));
        try {
            variantsFromPython = (List)future2.get();
        }
        catch (InterruptedException | ExecutionException e) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (variantsFromPython.size() == 0) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(8);
            }
            return list;
        }
        return this.removePossiblyUnreachableVariants(document, position.getLine(), variantsFromPython, context);
    }

    @NotNull
    private List<PySmartStepIntoVariant> removePossiblyUnreachableVariants(@NotNull Document document, int line2, @NotNull List<Pair<String, Boolean>> variantsFromPython, @NotNull PySmartStepIntoContext context) {
        PsiElement expression;
        if (document == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(9);
        }
        if (variantsFromPython == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(10);
        }
        if (context == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(11);
        }
        if ((expression = this.findSmartStepIntoBaseExpression(document, line2)) == null) {
            List<PySmartStepIntoVariant> list = Collections.emptyList();
            if (list == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(12);
            }
            return list;
        }
        ArrayList<PySmartStepIntoVariant> result = new ArrayList<PySmartStepIntoVariant>();
        expression.accept((PsiElementVisitor)new PySmartStepIntoVariantVisitor(result, variantsFromPython, context));
        ArrayList<PySmartStepIntoVariant> arrayList = result;
        if (arrayList == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @Nullable
    private PsiElement findSmartStepIntoBaseExpression(@NotNull Document document, int line2) {
        PsiFile file;
        if (document == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(14);
        }
        if ((file = PsiDocumentManager.getInstance((Project)this.mySession.getProject()).getPsiFile(document)) == null) {
            return null;
        }
        PsiElement element = file.findElementAt(DocumentUtil.getFirstNonSpaceCharOffset((Document)document, (int)line2));
        if (element == null) {
            return null;
        }
        PsiElement argumentList = PsiTreeUtil.getParentOfType((PsiElement)element, PyArgumentList.class);
        if (argumentList != null) {
            return argumentList.getParent();
        }
        PsiElement parenthesizedExpression = PsiTreeUtil.getParentOfType((PsiElement)element, PyParenthesizedExpression.class);
        if (parenthesizedExpression != null) {
            return parenthesizedExpression;
        }
        PsiElement parent = element.getParent();
        int lineStartOffset = document.getLineStartOffset(line2);
        int lineEndOffset = document.getLineEndOffset(line2);
        while (parent != null && lineStartOffset <= parent.getTextOffset() && parent.getTextOffset() < lineEndOffset) {
            element = parent;
            parent = element.getParent();
        }
        if (element instanceof PyExpression) {
            return element;
        }
        final Ref psiElementRef = new Ref();
        element.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyBinaryExpression(PyBinaryExpression node) {
                this.storeElement((PsiElement)node);
            }

            @Override
            public void visitPyCallExpression(PyCallExpression node) {
                this.storeElement((PsiElement)node);
            }

            @Override
            public void visitPyComprehensionElement(PyComprehensionElement node) {
                this.storeElement(node);
            }

            @Override
            public void visitPyElement(PyElement node) {
                if (node instanceof PyDecorator) {
                    this.storeElement((PsiElement)node);
                }
                super.visitPyElement(node);
            }

            @Override
            public void visitPyDecoratorList(PyDecoratorList node) {
                this.storeElement((PsiElement)node);
                super.visitPyDecoratorList(node);
            }

            private void storeElement(PsiElement node) {
                if (psiElementRef.isNull()) {
                    psiElementRef.set((Object)node);
                }
            }
        });
        return (PsiElement)psiElementRef.get();
    }

    @NotNull
    public Promise<List<PySmartStepIntoVariant>> computeStepIntoVariants(@NotNull XSourcePosition position) {
        if (position == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(15);
        }
        if (PyDebuggerSettings.getInstance().isAlwaysDoSmartStepInto()) {
            Promise promise = this.computeSmartStepVariantsAsync(position);
            if (promise == null) {
                PySmartStepIntoHandler.$$$reportNull$$$0(16);
            }
            return promise;
        }
        Promise promise = Promises.rejectedPromise();
        if (promise == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(17);
        }
        return promise;
    }

    @Nullable
    public PySmartStepIntoContext createSmartStepIntoContext(@NotNull PyStackFrame frame) {
        XSourcePosition position;
        if (frame == null) {
            PySmartStepIntoHandler.$$$reportNull$$$0(18);
        }
        if ((position = frame.getSourcePosition()) == null) {
            return null;
        }
        Document document = FileDocumentManager.getInstance().getDocument(position.getFile());
        if (document == null) {
            return null;
        }
        PySmartStepIntoHandler handler = (PySmartStepIntoHandler)this.myProcess.getSmartStepIntoHandler();
        PsiElement expression = handler.findSmartStepIntoBaseExpression(document, position.getLine());
        if (expression != null) {
            TextRange range = expression.getTextRange();
            int startLine = document.getLineNumber(range.getStartOffset());
            int endLine = document.getLineNumber(range.getEndOffset());
            return new PySmartStepIntoContext(startLine + 1, endLine + 1, frame);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "process";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smartStepIntoVariant";
                break;
            }
            case 2: 
            case 3: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoHandler";
                break;
            }
            case 9: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variantsFromPython";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoHandler";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSmartStepVariants";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "removePossiblyUnreachableVariants";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "computeStepIntoVariants";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "startStepInto";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPopupTitle";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "computeSmartStepVariants";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "removePossiblyUnreachableVariants";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "findSmartStepIntoBaseExpression";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeStepIntoVariants";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createSmartStepIntoContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 13: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

