/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.smartstepinto;

import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoContext;
import com.jetbrains.python.debugger.smartstepinto.PySmartStepIntoVariant;
import com.jetbrains.python.psi.PyElementType;
import com.jetbrains.python.psi.PyPrefixExpression;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySmartStepIntoVariantOperator
extends PySmartStepIntoVariant {
    @NonNls
    private static final Map<String, String> UNARY_OPERATOR_MAPPING = ImmutableMap.of((Object)"__sub__", (Object)"__neg__", (Object)"__add__", (Object)"__pos__", (Object)"__invert__", (Object)"__invert__");

    public PySmartStepIntoVariantOperator(@NotNull PsiElement element, int callOrder, @NotNull PySmartStepIntoContext context) {
        if (element == null) {
            PySmartStepIntoVariantOperator.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PySmartStepIntoVariantOperator.$$$reportNull$$$0(1);
        }
        super(element, callOrder, context);
    }

    @Override
    @Nullable
    public String getFunctionName() {
        if (this.myElement instanceof LeafPsiElement) {
            return ((PyElementType)((LeafPsiElement)this.myElement).getElementType()).getSpecialMethodName();
        }
        if (this.myElement instanceof PyPrefixExpression) {
            return PySmartStepIntoVariantOperator.getUnaryOperatorSpecialMethodName(((PyPrefixExpression)this.myElement).getOperator());
        }
        return null;
    }

    @NotNull
    public String getText() {
        String text2 = this.myElement.getText();
        String string = this.myElement instanceof PyPrefixExpression ? text2.substring(0, 1) : text2;
        if (string == null) {
            PySmartStepIntoVariantOperator.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    @NotNull
    public TextRange getHighlightRange() {
        TextRange textRange = this.myElement.getTextRange();
        TextRange textRange2 = this.myElement instanceof PyPrefixExpression ? new TextRange(textRange.getStartOffset(), textRange.getStartOffset() + 1) : textRange;
        if (textRange2 == null) {
            PySmartStepIntoVariantOperator.$$$reportNull$$$0(3);
        }
        return textRange2;
    }

    @Nullable
    public static String getUnaryOperatorSpecialMethodName(@NotNull PyElementType operator) {
        if (operator == null) {
            PySmartStepIntoVariantOperator.$$$reportNull$$$0(4);
        }
        return UNARY_OPERATOR_MAPPING.getOrDefault(operator.getSpecialMethodName(), null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoVariantOperator";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/debugger/smartstepinto/PySmartStepIntoVariantOperator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlightRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUnaryOperatorSpecialMethodName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

