/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.ide.BrowserUtil;
import com.intellij.util.Url;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.io.HttpRequests;
import java.io.IOException;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.TypeCastException;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.plugins.github.authentication.GHOAuthCallbackHandler;
import org.jetbrains.plugins.github.authentication.GHOAuthService;
import org.jetbrains.plugins.github.authentication.GHTokenRequest;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\b\u001a\u0004\u0018\u00010\u00022\u0006\u0010\t\u001a\u00020\u0002H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u0002J\u0006\u0010\f\u001a\u00020\u000bR\u0014\u0010\u0004\u001a\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/authentication/GHTokenRequest;", "Lorg/jetbrains/concurrency/AsyncPromise;", "", "()V", "codeChallenge", "getCodeChallenge", "()Ljava/lang/String;", "codeVerifier", "acquireToken", "code", "processCode", "", "startAuthorization", "intellij.vcs.github"})
final class GHTokenRequest
extends AsyncPromise<String> {
    private final String codeVerifier = DigestUtil.randomToken();

    private final String getCodeChallenge() {
        String string = this.codeVerifier;
        MessageDigest messageDigest = DigestUtil.sha256();
        Base64.Encoder encoder = Base64.getEncoder();
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        String string3 = encoder.encodeToString(messageDigest.digest(byArray2));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"Base64.getEncoder().enco\u2026eVerifier.toByteArray()))");
        return string3;
    }

    public final void startAuthorization() {
        Url url = GHOAuthService.Companion.getAUTHORIZE_URL().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"code_challenge", (Object)this.getCodeChallenge()), TuplesKt.to((Object)"callback_url", (Object)GHOAuthCallbackHandler.Companion.getAuthorizationCodeUrl().toExternalForm())}));
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"AUTHORIZE_URL.addParamet\u2026l.toExternalForm()\n    ))");
        Url authorizeUrl = url;
        BrowserUtil.browse((String)authorizeUrl.toExternalForm());
    }

    public final void processCode(@NotNull String code) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        try {
            String token = this.acquireToken(code);
            if (token != null) {
                this.setResult(token);
            } else {
                this.setError("No token provided");
            }
        }
        catch (IOException e) {
            this.setError(e);
        }
    }

    private final String acquireToken(String code) {
        Url url = GHOAuthService.Companion.getACCESS_TOKEN_URL().addParameters(MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)"code", (Object)code), TuplesKt.to((Object)"code_verifier", (Object)this.codeVerifier)}));
        Intrinsics.checkExpressionValueIsNotNull((Object)url, (String)"ACCESS_TOKEN_URL.addPara\u2026r\" to codeVerifier\n    ))");
        Url tokenUrl = url;
        return (String)HttpRequests.post((String)tokenUrl.toExternalForm(), null).connect((HttpRequests.RequestProcessor)acquireToken.1.INSTANCE);
    }
}

