/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.toolwindow;

import com.intellij.icons.AllIcons;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListUiUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.util.Date;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHLabel;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.avatars.CachingGithubAvatarIconsProvider;
import org.jetbrains.plugins.github.pullrequest.ui.toolwindow.GHPROpenButtonViewModel;
import org.jetbrains.plugins.github.ui.InlineIconButton;
import org.jetbrains.plugins.github.util.GithubUIUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ8\u0010\u0010\u001a\u00020\u00112\u000e\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00022\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016R\u000e\u0010\t\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPRListCellRenderer;", "Ljavax/swing/ListCellRenderer;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "Ljavax/swing/JPanel;", "avatarIconsProvider", "Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;", "openButtonViewModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPROpenButtonViewModel;", "(Lorg/jetbrains/plugins/github/pullrequest/avatars/CachingGithubAvatarIconsProvider;Lorg/jetbrains/plugins/github/pullrequest/ui/toolwindow/GHPROpenButtonViewModel;)V", "assignees", "info", "Ljavax/swing/JLabel;", "labels", "openButtonPanel", "stateIcon", "title", "getListCellRendererComponent", "Ljava/awt/Component;", "list", "Ljavax/swing/JList;", "value", "index", "", "isSelected", "", "cellHasFocus", "intellij.vcs.github"})
public final class GHPRListCellRenderer
extends JPanel
implements ListCellRenderer<GHPullRequestShort> {
    private final JLabel stateIcon;
    private final JLabel title;
    private final JLabel info;
    private final JPanel labels;
    private final JPanel assignees;
    private final JPanel openButtonPanel;
    private final CachingGithubAvatarIconsProvider avatarIconsProvider;
    private final GHPROpenButtonViewModel openButtonViewModel;

    @Override
    @NotNull
    public Component getListCellRendererComponent(@NotNull JList<? extends GHPullRequestShort> list2, @NotNull GHPullRequestShort value, int index, boolean isSelected, boolean cellHasFocus) {
        Intrinsics.checkParameterIsNotNull(list2, (String)"list");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        this.setBackground(ListUiUtil.WithTallRow.INSTANCE.background(list2, isSelected, list2.hasFocus()));
        Color primaryTextColor = ListUiUtil.WithTallRow.INSTANCE.foreground(isSelected, list2.hasFocus());
        Color secondaryTextColor = ListUiUtil.WithTallRow.INSTANCE.secondaryForeground(list2, isSelected);
        JComponent jComponent = this.stateIcon;
        boolean bl = false;
        boolean bl2 = false;
        JLabel $this$apply = jComponent;
        boolean bl3 = false;
        $this$apply.setIcon(GithubUIUtil.INSTANCE.getPullRequestStateIcon(value.getState(), value.isDraft()));
        $this$apply.setToolTipText(GithubUIUtil.INSTANCE.getPullRequestStateText(value.getState(), value.isDraft()));
        jComponent = this.title;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl4 = false;
        $this$apply.setText(value.getTitle());
        $this$apply.setForeground(primaryTextColor);
        jComponent = this.info;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl5 = false;
        GHActor gHActor = value.getAuthor();
        $this$apply.setText("" + '#' + value.getNumber() + ' ' + (gHActor != null ? gHActor.getLogin() : null) + " on " + DateFormatUtil.formatDate((Date)value.getCreatedAt()));
        $this$apply.setForeground(secondaryTextColor);
        jComponent = this.labels;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl6 = false;
        $this$apply.removeAll();
        for (GHLabel label : value.getLabels()) {
            $this$apply.add((Component)GithubUIUtil.INSTANCE.createIssueLabelLabel(label));
            $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(4, 0)));
        }
        jComponent = this.assignees;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl7 = false;
        $this$apply.removeAll();
        for (GHUser assignee2 : value.getAssignees()) {
            if ($this$apply.getComponentCount() != 0) {
                $this$apply.add(Box.createRigidArea((Dimension)new JBDimension(10, 0)));
            }
            JLabel jLabel = new JLabel();
            JLabel jLabel2 = $this$apply;
            boolean bl8 = false;
            boolean bl9 = false;
            JLabel $this$apply2 = jLabel;
            boolean bl10 = false;
            $this$apply2.setIcon(this.avatarIconsProvider.getIcon(assignee2.getAvatarUrl()));
            $this$apply2.setToolTipText(assignee2.getLogin());
            JLabel jLabel3 = jLabel;
            jLabel2.add(jLabel3);
        }
        jComponent = this.openButtonPanel;
        bl = false;
        bl2 = false;
        $this$apply = jComponent;
        boolean bl11 = false;
        $this$apply.setVisible(index == this.openButtonViewModel.getHoveredRowIndex());
        $this$apply.setOpaque(this.openButtonViewModel.isButtonHovered());
        return this;
    }

    public GHPRListCellRenderer(@NotNull CachingGithubAvatarIconsProvider avatarIconsProvider, @NotNull GHPROpenButtonViewModel openButtonViewModel) {
        JPanel jPanel;
        Intrinsics.checkParameterIsNotNull((Object)avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkParameterIsNotNull((Object)openButtonViewModel, (String)"openButtonViewModel");
        this.avatarIconsProvider = avatarIconsProvider;
        this.openButtonViewModel = openButtonViewModel;
        this.stateIcon = new JLabel();
        this.title = new JLabel();
        this.info = new JLabel();
        JPanel jPanel2 = new JPanel();
        GHPRListCellRenderer gHPRListCellRenderer = this;
        boolean bl = false;
        boolean bl2 = false;
        JPanel $this$apply = jPanel2;
        boolean bl3 = false;
        $this$apply.setOpaque(false);
        $this$apply.setLayout(new BoxLayout($this$apply, 0));
        gHPRListCellRenderer.labels = jPanel = jPanel2;
        jPanel2 = new JPanel();
        gHPRListCellRenderer = this;
        bl = false;
        bl2 = false;
        $this$apply = jPanel2;
        boolean bl4 = false;
        $this$apply.setOpaque(false);
        $this$apply.setLayout(new BoxLayout($this$apply, 0));
        gHPRListCellRenderer.assignees = jPanel = jPanel2;
        jPanel2 = new JPanel(new GridBagLayout());
        gHPRListCellRenderer = this;
        bl = false;
        bl2 = false;
        $this$apply = jPanel2;
        boolean bl5 = false;
        $this$apply.setOpaque(false);
        $this$apply.setBackground(JBUI.CurrentTheme.ActionButton.pressedBackground());
        Icon icon = AllIcons.General.ArrowRight;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.ArrowRight");
        InlineIconButton inlineIconButton = new InlineIconButton(icon, null, null, null, null, 30, null);
        JPanel jPanel3 = $this$apply;
        boolean bl6 = false;
        boolean bl7 = false;
        InlineIconButton $this$apply2 = inlineIconButton;
        boolean bl8 = false;
        $this$apply2.setToolTipText(GithubBundle.message("pull.request.open.action", new Object[0]));
        InlineIconButton inlineIconButton2 = inlineIconButton;
        jPanel3.add(inlineIconButton2);
        gHPRListCellRenderer.openButtonPanel = jPanel = jPanel2;
        String gapAfter = JBUI.scale((int)5) + "px";
        JPanel jPanel4 = new JPanel(null);
        boolean bl9 = false;
        boolean bl10 = false;
        JPanel $this$apply3 = jPanel4;
        boolean bl11 = false;
        $this$apply3.setOpaque(false);
        $this$apply3.setBorder((Border)JBUI.Borders.empty((int)5, (int)8));
        $this$apply3.setLayout((LayoutManager)new MigLayout(new LC().gridGap(gapAfter, "0").insets("0", "0", "0", "0").fillX()));
        $this$apply3.add(this.stateIcon);
        $this$apply3.add((Component)this.title, new CC().minWidth("pref/2px").pushX().split(2).shrinkPrioX(1));
        $this$apply3.add((Component)this.labels, new CC().minWidth("0px").pushX().shrinkPrioX(0));
        $this$apply3.add((Component)this.info, new CC().newline().minWidth("0px").pushX().skip(1));
        JPanel infoPanel = jPanel4;
        this.setLayout((LayoutManager)new MigLayout(new LC().gridGap(gapAfter, "0").noGrid().insets("0", "0", "0", "0").fillX()));
        this.add((Component)infoPanel, new CC().minWidth("0"));
        this.add((Component)this.assignees, new CC().minWidth("0").gapBefore("push"));
        this.add((Component)this.openButtonPanel, new CC().minWidth("pref").growY());
    }
}

