/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.tribes.group;

import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.catalina.tribes.ByteMessage;
import org.apache.catalina.tribes.ChannelException;
import org.apache.catalina.tribes.ChannelInterceptor;
import org.apache.catalina.tribes.ChannelListener;
import org.apache.catalina.tribes.ChannelMessage;
import org.apache.catalina.tribes.ChannelReceiver;
import org.apache.catalina.tribes.ChannelSender;
import org.apache.catalina.tribes.ErrorHandler;
import org.apache.catalina.tribes.Heartbeat;
import org.apache.catalina.tribes.ManagedChannel;
import org.apache.catalina.tribes.Member;
import org.apache.catalina.tribes.MembershipListener;
import org.apache.catalina.tribes.MembershipService;
import org.apache.catalina.tribes.RemoteProcessException;
import org.apache.catalina.tribes.UniqueId;
import org.apache.catalina.tribes.group.ChannelCoordinator;
import org.apache.catalina.tribes.group.ChannelInterceptorBase;
import org.apache.catalina.tribes.group.InterceptorPayload;
import org.apache.catalina.tribes.group.RpcChannel;
import org.apache.catalina.tribes.group.RpcMessage;
import org.apache.catalina.tribes.group.interceptors.MessageDispatchInterceptor;
import org.apache.catalina.tribes.io.BufferPool;
import org.apache.catalina.tribes.io.ChannelData;
import org.apache.catalina.tribes.io.XByteBuffer;
import org.apache.catalina.tribes.util.Arrays;
import org.apache.catalina.tribes.util.Logs;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class GroupChannel
extends ChannelInterceptorBase
implements ManagedChannel {
    private static final Log log = LogFactory.getLog(GroupChannel.class);
    protected boolean heartbeat = true;
    protected long heartbeatSleeptime = 5000L;
    protected HeartbeatThread hbthread = null;
    protected ChannelCoordinator coordinator = new ChannelCoordinator();
    protected ChannelInterceptor interceptors = null;
    protected List<Object> membershipListeners = new CopyOnWriteArrayList<Object>();
    protected List<Object> channelListeners = new CopyOnWriteArrayList<Object>();
    protected boolean optionCheck = false;
    protected String name = null;

    public GroupChannel() {
        this.addInterceptor(this);
    }

    @Override
    public void addInterceptor(ChannelInterceptor channelInterceptor) {
        if (this.interceptors == null) {
            this.interceptors = channelInterceptor;
            this.interceptors.setNext(this.coordinator);
            this.interceptors.setPrevious(null);
            this.coordinator.setPrevious(this.interceptors);
        } else {
            ChannelInterceptor channelInterceptor2 = this.interceptors;
            while (channelInterceptor2.getNext() != this.coordinator) {
                channelInterceptor2 = channelInterceptor2.getNext();
            }
            channelInterceptor2.setNext(channelInterceptor);
            channelInterceptor.setNext(this.coordinator);
            channelInterceptor.setPrevious(channelInterceptor2);
            this.coordinator.setPrevious(channelInterceptor);
        }
    }

    @Override
    public void heartbeat() {
        super.heartbeat();
        for (Object object : this.membershipListeners) {
            if (!(object instanceof Heartbeat)) continue;
            ((Heartbeat)object).heartbeat();
        }
        for (Object object : this.channelListeners) {
            if (!(object instanceof Heartbeat)) continue;
            ((Heartbeat)object).heartbeat();
        }
    }

    @Override
    public UniqueId send(Member[] memberArray, Serializable serializable, int n) throws ChannelException {
        return this.send(memberArray, serializable, n, null);
    }

    @Override
    public UniqueId send(Member[] memberArray, Serializable serializable, int n, ErrorHandler errorHandler) throws ChannelException {
        if (serializable == null) {
            throw new ChannelException("Cant send a NULL message");
        }
        XByteBuffer xByteBuffer = null;
        try {
            if (memberArray == null || memberArray.length == 0) {
                throw new ChannelException("No destination given");
            }
            ChannelData channelData = new ChannelData(true);
            channelData.setAddress(this.getLocalMember(false));
            channelData.setTimestamp(System.currentTimeMillis());
            byte[] byArray = null;
            if (serializable instanceof ByteMessage) {
                byArray = ((ByteMessage)serializable).getMessage();
                n |= 1;
            } else {
                byArray = XByteBuffer.serialize(serializable);
                n &= 0xFFFFFFFE;
            }
            channelData.setOptions(n);
            xByteBuffer = BufferPool.getBufferPool().getBuffer(byArray.length + 128, false);
            xByteBuffer.append(byArray, 0, byArray.length);
            channelData.setMessage(xByteBuffer);
            InterceptorPayload interceptorPayload = null;
            if (errorHandler != null) {
                interceptorPayload = new InterceptorPayload();
                interceptorPayload.setErrorHandler(errorHandler);
            }
            this.getFirstInterceptor().sendMessage(memberArray, channelData, interceptorPayload);
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Sent msg:" + new UniqueId(channelData.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " to " + Arrays.toNameString(memberArray)));
                Logs.MESSAGES.trace((Object)("GroupChannel - Send Message:" + new UniqueId(channelData.getUniqueId()) + " is " + serializable));
            }
            UniqueId uniqueId = new UniqueId(channelData.getUniqueId());
            if (xByteBuffer != null) {
                BufferPool.getBufferPool().returnBuffer(xByteBuffer);
            }
            return uniqueId;
        }
        catch (Exception exception) {
            try {
                throw new ChannelException(exception);
            }
            catch (Throwable throwable) {
                if (xByteBuffer != null) {
                    BufferPool.getBufferPool().returnBuffer(xByteBuffer);
                }
                throw throwable;
            }
        }
    }

    @Override
    public void messageReceived(ChannelMessage channelMessage) {
        if (channelMessage == null) {
            return;
        }
        try {
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Received msg:" + new UniqueId(channelMessage.getUniqueId()) + " at " + new Timestamp(System.currentTimeMillis()) + " from " + channelMessage.getAddress().getName()));
            }
            Serializable serializable = null;
            if ((channelMessage.getOptions() & 1) == 1) {
                serializable = new ByteMessage(channelMessage.getMessage().getBytes());
            } else {
                try {
                    serializable = XByteBuffer.deserialize(channelMessage.getMessage().getBytesDirect(), 0, channelMessage.getMessage().getLength());
                }
                catch (Exception exception) {
                    log.error((Object)("Unable to deserialize message:" + channelMessage), (Throwable)exception);
                    return;
                }
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel - Receive Message:" + new UniqueId(channelMessage.getUniqueId()) + " is " + serializable));
            }
            Member member = channelMessage.getAddress();
            boolean bl = false;
            boolean bl2 = false;
            for (Object object : this.channelListeners) {
                ChannelListener channelListener = (ChannelListener)object;
                if (channelListener == null || !channelListener.accept(serializable, member)) continue;
                channelListener.messageReceived(serializable, member);
                bl2 = true;
                if (!(channelListener instanceof RpcChannel)) continue;
                bl = true;
            }
            if (!bl && serializable instanceof RpcMessage) {
                this.sendNoRpcChannelReply((RpcMessage)serializable, member);
            }
            if (Logs.MESSAGES.isTraceEnabled()) {
                Logs.MESSAGES.trace((Object)("GroupChannel delivered[" + bl2 + "] id:" + new UniqueId(channelMessage.getUniqueId())));
            }
        }
        catch (Exception exception) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Error receiving message:", (Throwable)exception);
            }
            throw new RemoteProcessException("Exception:" + exception.getMessage(), exception);
        }
    }

    protected void sendNoRpcChannelReply(RpcMessage rpcMessage, Member member) {
        try {
            if (rpcMessage instanceof RpcMessage.NoRpcChannelReply) {
                return;
            }
            RpcMessage.NoRpcChannelReply noRpcChannelReply = new RpcMessage.NoRpcChannelReply(rpcMessage.rpcId, rpcMessage.uuid);
            this.send(new Member[]{member}, noRpcChannelReply, 8);
        }
        catch (Exception exception) {
            log.error((Object)"Unable to find rpc channel, failed to send NoRpcChannelReply.", (Throwable)exception);
        }
    }

    @Override
    public void memberAdded(Member member) {
        for (Object object : this.membershipListeners) {
            MembershipListener membershipListener = (MembershipListener)object;
            if (membershipListener == null) continue;
            membershipListener.memberAdded(member);
        }
    }

    @Override
    public void memberDisappeared(Member member) {
        for (Object object : this.membershipListeners) {
            MembershipListener membershipListener = (MembershipListener)object;
            if (membershipListener == null) continue;
            membershipListener.memberDisappeared(member);
        }
    }

    protected synchronized void setupDefaultStack() throws ChannelException {
        Object object;
        Object object2;
        if (this.getFirstInterceptor() != null && this.getFirstInterceptor().getNext() instanceof ChannelCoordinator) {
            object2 = null;
            object = null;
            try {
                object = Class.forName("org.apache.catalina.tribes.group.interceptors.MessageDispatch15Interceptor", true, GroupChannel.class.getClassLoader());
                ((Class)object).newInstance();
            }
            catch (Throwable throwable) {
                object = MessageDispatchInterceptor.class;
            }
            try {
                object2 = (ChannelInterceptor)((Class)object).newInstance();
            }
            catch (Exception exception) {
                throw new ChannelException("Unable to add MessageDispatchInterceptor to interceptor chain.", exception);
            }
            this.addInterceptor((ChannelInterceptor)object2);
        }
        object2 = this.getInterceptors();
        while (object2.hasNext()) {
            object = object2.next();
            if (!(object instanceof ChannelInterceptorBase)) continue;
            ((ChannelInterceptorBase)object).setChannel(this);
        }
        this.coordinator.setChannel(this);
    }

    protected void checkOptionFlags() throws ChannelException {
        StringBuilder stringBuilder = new StringBuilder();
        for (ChannelInterceptor channelInterceptor = this.interceptors; channelInterceptor != null; channelInterceptor = channelInterceptor.getNext()) {
            int n = channelInterceptor.getOptionFlag();
            if (n == 0) continue;
            for (ChannelInterceptor channelInterceptor2 = channelInterceptor.getNext(); channelInterceptor2 != null; channelInterceptor2 = channelInterceptor2.getNext()) {
                int n2 = channelInterceptor2.getOptionFlag();
                if (n2 == 0 || (n & n2) != n && (n & n2) != n2) continue;
                stringBuilder.append("[");
                stringBuilder.append(channelInterceptor.getClass().getName());
                stringBuilder.append(":");
                stringBuilder.append(n);
                stringBuilder.append(" == ");
                stringBuilder.append(channelInterceptor2.getClass().getName());
                stringBuilder.append(":");
                stringBuilder.append(n2);
                stringBuilder.append("] ");
            }
        }
        if (stringBuilder.length() > 0) {
            throw new ChannelException("Interceptor option flag conflict: " + stringBuilder.toString());
        }
    }

    @Override
    public synchronized void start(int n) throws ChannelException {
        this.setupDefaultStack();
        if (this.optionCheck) {
            this.checkOptionFlags();
        }
        super.start(n);
        if (this.hbthread == null && this.heartbeat) {
            this.hbthread = new HeartbeatThread(this, this.heartbeatSleeptime);
            this.hbthread.start();
        }
    }

    @Override
    public synchronized void stop(int n) throws ChannelException {
        if (this.hbthread != null) {
            this.hbthread.stopHeartbeat();
            this.hbthread = null;
        }
        super.stop(n);
    }

    public ChannelInterceptor getFirstInterceptor() {
        if (this.interceptors != null) {
            return this.interceptors;
        }
        return this.coordinator;
    }

    @Override
    public ChannelReceiver getChannelReceiver() {
        return this.coordinator.getClusterReceiver();
    }

    @Override
    public ChannelSender getChannelSender() {
        return this.coordinator.getClusterSender();
    }

    @Override
    public MembershipService getMembershipService() {
        return this.coordinator.getMembershipService();
    }

    @Override
    public void setChannelReceiver(ChannelReceiver channelReceiver) {
        this.coordinator.setClusterReceiver(channelReceiver);
    }

    @Override
    public void setChannelSender(ChannelSender channelSender) {
        this.coordinator.setClusterSender(channelSender);
    }

    @Override
    public void setMembershipService(MembershipService membershipService) {
        this.coordinator.setMembershipService(membershipService);
    }

    @Override
    public void addMembershipListener(MembershipListener membershipListener) {
        if (!this.membershipListeners.contains(membershipListener)) {
            this.membershipListeners.add(membershipListener);
        }
    }

    @Override
    public void removeMembershipListener(MembershipListener membershipListener) {
        this.membershipListeners.remove(membershipListener);
    }

    @Override
    public void addChannelListener(ChannelListener channelListener) {
        if (this.channelListeners.contains(channelListener)) {
            throw new IllegalArgumentException("Listener already exists:" + channelListener + "[" + channelListener.getClass().getName() + "]");
        }
        this.channelListeners.add(channelListener);
    }

    @Override
    public void removeChannelListener(ChannelListener channelListener) {
        this.channelListeners.remove(channelListener);
    }

    @Override
    public Iterator<ChannelInterceptor> getInterceptors() {
        return new InterceptorIterator(this.getNext(), this.coordinator);
    }

    public void setOptionCheck(boolean bl) {
        this.optionCheck = bl;
    }

    public void setHeartbeatSleeptime(long l) {
        this.heartbeatSleeptime = l;
    }

    @Override
    public void setHeartbeat(boolean bl) {
        this.heartbeat = bl;
    }

    public boolean getOptionCheck() {
        return this.optionCheck;
    }

    public boolean getHeartbeat() {
        return this.heartbeat;
    }

    public long getHeartbeatSleeptime() {
        return this.heartbeatSleeptime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public static class HeartbeatThread
    extends Thread {
        private static final Log log = LogFactory.getLog(HeartbeatThread.class);
        protected static int counter = 1;
        protected volatile boolean doRun = true;
        protected GroupChannel channel;
        protected long sleepTime;

        protected static synchronized int inc() {
            return counter++;
        }

        public HeartbeatThread(GroupChannel groupChannel, long l) {
            this.setPriority(1);
            String string = "";
            if (groupChannel.getName() != null) {
                string = "[" + groupChannel.getName() + "]";
            }
            this.setName("GroupChannel-Heartbeat" + string + "-" + HeartbeatThread.inc());
            this.setDaemon(true);
            this.channel = groupChannel;
            this.sleepTime = l;
        }

        public void stopHeartbeat() {
            this.doRun = false;
            this.interrupt();
        }

        @Override
        public void run() {
            while (this.doRun) {
                try {
                    Thread.sleep(this.sleepTime);
                    this.channel.heartbeat();
                }
                catch (InterruptedException interruptedException) {
                    HeartbeatThread.interrupted();
                }
                catch (Exception exception) {
                    log.error((Object)"Unable to send heartbeat through Tribes interceptor stack. Will try to sleep again.", (Throwable)exception);
                }
            }
        }
    }

    public static class InterceptorIterator
    implements Iterator<ChannelInterceptor> {
        private ChannelInterceptor end;
        private ChannelInterceptor start;

        public InterceptorIterator(ChannelInterceptor channelInterceptor, ChannelInterceptor channelInterceptor2) {
            this.end = channelInterceptor2;
            this.start = channelInterceptor;
        }

        @Override
        public boolean hasNext() {
            return this.start != null && this.start != this.end;
        }

        @Override
        public ChannelInterceptor next() {
            ChannelInterceptor channelInterceptor = null;
            if (this.hasNext()) {
                channelInterceptor = this.start;
                this.start = this.start.getNext();
            }
            return channelInterceptor;
        }

        @Override
        public void remove() {
        }
    }
}

