/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.dbcp.dbcp2;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.sql.DataSource;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.dbcp.dbcp2.BasicDataSourceMXBean;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.ConnectionFactoryFactory;
import org.apache.tomcat.dbcp.dbcp2.DriverFactory;
import org.apache.tomcat.dbcp.dbcp2.ObjectNameWrapper;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnection;
import org.apache.tomcat.dbcp.dbcp2.PoolableConnectionFactory;
import org.apache.tomcat.dbcp.dbcp2.PoolingDataSource;
import org.apache.tomcat.dbcp.dbcp2.SwallowedExceptionLogger;
import org.apache.tomcat.dbcp.dbcp2.Utils;
import org.apache.tomcat.dbcp.pool2.PooledObject;
import org.apache.tomcat.dbcp.pool2.impl.AbandonedConfig;
import org.apache.tomcat.dbcp.pool2.impl.BaseObjectPoolConfig;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPool;
import org.apache.tomcat.dbcp.pool2.impl.GenericObjectPoolConfig;

public class BasicDataSource
implements DataSource,
BasicDataSourceMXBean,
MBeanRegistration,
AutoCloseable {
    private static final Log log = LogFactory.getLog(BasicDataSource.class);
    private volatile Boolean defaultAutoCommit;
    private transient Boolean defaultReadOnly;
    private volatile int defaultTransactionIsolation = -1;
    private Integer defaultQueryTimeoutSeconds;
    private volatile String defaultCatalog;
    private volatile String defaultSchema;
    private boolean cacheState = true;
    private Driver driver;
    private String driverClassName;
    private ClassLoader driverClassLoader;
    private boolean lifo = true;
    private int maxTotal = 8;
    private int maxIdle = 8;
    private int minIdle = 0;
    private int initialSize = 0;
    private long maxWaitMillis = -1L;
    private boolean poolPreparedStatements = false;
    private boolean clearStatementPoolOnReturn = false;
    private int maxOpenPreparedStatements = -1;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private long minEvictableIdleTimeMillis = 1800000L;
    private long softMinEvictableIdleTimeMillis = -1L;
    private String evictionPolicyClassName = BaseObjectPoolConfig.DEFAULT_EVICTION_POLICY_CLASS_NAME;
    private boolean testWhileIdle = false;
    private volatile String password;
    private String url;
    private String userName;
    private volatile String validationQuery;
    private volatile int validationQueryTimeoutSeconds = -1;
    private String connectionFactoryClassName;
    private volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private long maxConnLifetimeMillis = -1L;
    private boolean logExpiredConnections = true;
    private String jmxName;
    private boolean autoCommitOnReturn = true;
    private boolean rollbackOnReturn = true;
    private volatile Set<String> disconnectionSqlCodes;
    private boolean fastFailValidation;
    private volatile GenericObjectPool<PoolableConnection> connectionPool;
    private Properties connectionProperties = new Properties();
    private volatile DataSource dataSource;
    private volatile PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private AbandonedConfig abandonedConfig;
    private boolean closed;
    private ObjectNameWrapper registeredJmxObjectName;

    protected static void validateConnectionFactory(PoolableConnectionFactory poolableConnectionFactory) throws Exception {
        PoolableConnection poolableConnection = null;
        PooledObject<PoolableConnection> pooledObject = null;
        try {
            pooledObject = poolableConnectionFactory.makeObject();
            poolableConnection = pooledObject.getObject();
            poolableConnectionFactory.activateObject(pooledObject);
            poolableConnectionFactory.validateConnection(poolableConnection);
            poolableConnectionFactory.passivateObject(pooledObject);
        }
        finally {
            if (pooledObject != null) {
                poolableConnectionFactory.destroyObject(pooledObject);
            }
        }
    }

    public void addConnectionProperty(String string, String string2) {
        this.connectionProperties.put(string, string2);
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.registeredJmxObjectName != null) {
            this.registeredJmxObjectName.unregisterMBean();
            this.registeredJmxObjectName = null;
        }
        this.closed = true;
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), exception);
        }
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (genericObjectPool != null) {
                genericObjectPool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        return ConnectionFactoryFactory.createConnectionFactory(this, DriverFactory.createDriver(this));
    }

    protected void createConnectionPool(PoolableConnectionFactory poolableConnectionFactory) {
        GenericObjectPoolConfig<PoolableConnection> genericObjectPoolConfig = new GenericObjectPoolConfig<PoolableConnection>();
        this.updateJmxName(genericObjectPoolConfig);
        genericObjectPoolConfig.setJmxEnabled(this.registeredJmxObjectName != null);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.createObjectPool(poolableConnectionFactory, genericObjectPoolConfig, this.abandonedConfig);
        genericObjectPool.setMaxTotal(this.maxTotal);
        genericObjectPool.setMaxIdle(this.maxIdle);
        genericObjectPool.setMinIdle(this.minIdle);
        genericObjectPool.setMaxWaitMillis(this.maxWaitMillis);
        genericObjectPool.setTestOnCreate(this.testOnCreate);
        genericObjectPool.setTestOnBorrow(this.testOnBorrow);
        genericObjectPool.setTestOnReturn(this.testOnReturn);
        genericObjectPool.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        genericObjectPool.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis);
        genericObjectPool.setSoftMinEvictableIdleTimeMillis(this.softMinEvictableIdleTimeMillis);
        genericObjectPool.setTestWhileIdle(this.testWhileIdle);
        genericObjectPool.setLifo(this.lifo);
        genericObjectPool.setSwallowedExceptionListener(new SwallowedExceptionLogger(log, this.logExpiredConnections));
        genericObjectPool.setEvictionPolicyClassName(this.evictionPolicyClassName);
        poolableConnectionFactory.setPool(genericObjectPool);
        this.connectionPool = genericObjectPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            DataSource dataSource;
            PoolableConnectionFactory poolableConnectionFactory;
            if (this.dataSource != null) {
                return this.dataSource;
            }
            this.jmxRegister();
            ConnectionFactory connectionFactory = this.createConnectionFactory();
            boolean bl = false;
            try {
                poolableConnectionFactory = this.createPoolableConnectionFactory(connectionFactory);
                poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
                poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
                bl = true;
            }
            catch (RuntimeException | SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException("Error creating connection factory", exception);
            }
            if (bl) {
                this.createConnectionPool(poolableConnectionFactory);
            }
            bl = false;
            try {
                dataSource = this.createDataSourceInstance();
                dataSource.setLogWriter(this.logWriter);
                bl = true;
            }
            catch (RuntimeException | SQLException exception) {
                throw exception;
            }
            catch (Exception exception) {
                throw new SQLException("Error creating datasource", exception);
            }
            finally {
                if (!bl) {
                    this.closeConnectionPool();
                }
            }
            try {
                for (int i = 0; i < this.initialSize; ++i) {
                    this.connectionPool.addObject();
                }
            }
            catch (Exception exception) {
                this.closeConnectionPool();
                throw new SQLException("Error preloading the connection pool", exception);
            }
            this.startPoolMaintenance();
            this.dataSource = dataSource;
            return this.dataSource;
        }
    }

    protected DataSource createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> poolingDataSource = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        poolingDataSource.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return poolingDataSource;
    }

    protected GenericObjectPool<PoolableConnection> createObjectPool(PoolableConnectionFactory poolableConnectionFactory, GenericObjectPoolConfig<PoolableConnection> genericObjectPoolConfig, AbandonedConfig abandonedConfig) {
        GenericObjectPool<PoolableConnection> genericObjectPool = abandonedConfig != null && (abandonedConfig.getRemoveAbandonedOnBorrow() || abandonedConfig.getRemoveAbandonedOnMaintenance()) ? new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, genericObjectPoolConfig, abandonedConfig) : new GenericObjectPool<PoolableConnection>(poolableConnectionFactory, genericObjectPoolConfig);
        return genericObjectPool;
    }

    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory connectionFactory) throws SQLException {
        PoolableConnectionFactory poolableConnectionFactory = null;
        try {
            poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, ObjectNameWrapper.unwrap(this.registeredJmxObjectName));
            poolableConnectionFactory.setValidationQuery(this.validationQuery);
            poolableConnectionFactory.setValidationQueryTimeout(this.validationQueryTimeoutSeconds);
            poolableConnectionFactory.setConnectionInitSql(this.connectionInitSqls);
            poolableConnectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            poolableConnectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            poolableConnectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            poolableConnectionFactory.setDefaultCatalog(this.defaultCatalog);
            poolableConnectionFactory.setDefaultSchema(this.defaultSchema);
            poolableConnectionFactory.setCacheState(this.cacheState);
            poolableConnectionFactory.setPoolStatements(this.poolPreparedStatements);
            poolableConnectionFactory.setClearStatementPoolOnReturn(this.clearStatementPoolOnReturn);
            poolableConnectionFactory.setMaxOpenPreparedStatements(this.maxOpenPreparedStatements);
            poolableConnectionFactory.setMaxConnLifetimeMillis(this.maxConnLifetimeMillis);
            poolableConnectionFactory.setRollbackOnReturn(this.getRollbackOnReturn());
            poolableConnectionFactory.setAutoCommitOnReturn(this.getAutoCommitOnReturn());
            poolableConnectionFactory.setDefaultQueryTimeout(this.getDefaultQueryTimeout());
            poolableConnectionFactory.setFastFailValidation(this.fastFailValidation);
            poolableConnectionFactory.setDisconnectionSqlCodes(this.disconnectionSqlCodes);
            BasicDataSource.validateConnectionFactory(poolableConnectionFactory);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + exception.getMessage() + ")", exception);
        }
        return poolableConnectionFactory;
    }

    public void evict() throws Exception {
        if (this.connectionPool != null) {
            this.connectionPool.evict();
        }
    }

    public PrintWriter getAbandonedLogWriter() {
        return this.abandonedConfig == null ? null : this.abandonedConfig.getLogWriter();
    }

    @Override
    public boolean getAbandonedUsageTracking() {
        return this.abandonedConfig != null && this.abandonedConfig.getUseUsageTracking();
    }

    public boolean getAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    @Override
    public boolean getCacheState() {
        return this.cacheState;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (Utils.IS_SECURITY_ENABLED) {
            PrivilegedExceptionAction<Connection> privilegedExceptionAction = () -> this.createDataSource().getConnection();
            try {
                return AccessController.doPrivileged(privilegedExceptionAction);
            }
            catch (PrivilegedActionException privilegedActionException) {
                Throwable throwable = privilegedActionException.getCause();
                if (throwable instanceof SQLException) {
                    throw (SQLException)throwable;
                }
                throw new SQLException(privilegedActionException);
            }
        }
        return this.createDataSource().getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    public String getConnectionFactoryClassName() {
        return this.connectionFactoryClassName;
    }

    public List<String> getConnectionInitSqls() {
        List<String> list = this.connectionInitSqls;
        return list == null ? Collections.emptyList() : list;
    }

    @Override
    public String[] getConnectionInitSqlsAsArray() {
        return this.getConnectionInitSqls().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    protected GenericObjectPool<PoolableConnection> getConnectionPool() {
        return this.connectionPool;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public Integer getDefaultQueryTimeout() {
        return this.defaultQueryTimeoutSeconds;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public Set<String> getDisconnectionSqlCodes() {
        Set<String> set = this.disconnectionSqlCodes;
        return set == null ? Collections.emptySet() : set;
    }

    @Override
    public String[] getDisconnectionSqlCodesAsArray() {
        return this.getDisconnectionSqlCodes().toArray(Utils.EMPTY_STRING_ARRAY);
    }

    public synchronized Driver getDriver() {
        return this.driver;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    @Override
    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    @Deprecated
    public boolean getEnableAutoCommitOnReturn() {
        return this.autoCommitOnReturn;
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    @Override
    public boolean getFastFailValidation() {
        return this.fastFailValidation;
    }

    @Override
    public synchronized int getInitialSize() {
        return this.initialSize;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    @Override
    public synchronized boolean getLifo() {
        return this.lifo;
    }

    @Override
    public boolean getLogAbandoned() {
        return this.abandonedConfig != null && this.abandonedConfig.getLogAbandoned();
    }

    @Override
    public boolean getLogExpiredConnections() {
        return this.logExpiredConnections;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public long getMaxConnLifetimeMillis() {
        return this.maxConnLifetimeMillis;
    }

    @Override
    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    @Override
    public synchronized int getMaxOpenPreparedStatements() {
        return this.maxOpenPreparedStatements;
    }

    @Override
    public synchronized int getMaxTotal() {
        return this.maxTotal;
    }

    @Override
    public synchronized long getMaxWaitMillis() {
        return this.maxWaitMillis;
    }

    @Override
    public synchronized long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    @Override
    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    @Override
    public int getNumActive() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        return genericObjectPool == null ? 0 : genericObjectPool.getNumActive();
    }

    @Override
    public int getNumIdle() {
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        return genericObjectPool == null ? 0 : genericObjectPool.getNumIdle();
    }

    @Override
    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    protected ObjectName getRegisteredJmxName() {
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    @Override
    public boolean getRemoveAbandonedOnBorrow() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnBorrow();
    }

    @Override
    public boolean getRemoveAbandonedOnMaintenance() {
        return this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedOnMaintenance();
    }

    @Override
    public int getRemoveAbandonedTimeout() {
        return this.abandonedConfig == null ? 300 : this.abandonedConfig.getRemoveAbandonedTimeout();
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    @Override
    public synchronized long getSoftMinEvictableIdleTimeMillis() {
        return this.softMinEvictableIdleTimeMillis;
    }

    @Override
    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    @Override
    public synchronized boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    @Override
    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    @Override
    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    @Override
    public synchronized String getUrl() {
        return this.url;
    }

    @Override
    public String getUsername() {
        return this.userName;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeoutSeconds;
    }

    public void invalidateConnection(Connection connection) throws IllegalStateException {
        PoolableConnection poolableConnection;
        if (connection == null) {
            return;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("Cannot invalidate connection: ConnectionPool is null.");
        }
        try {
            poolableConnection = connection.unwrap(PoolableConnection.class);
            if (poolableConnection == null) {
                throw new IllegalStateException("Cannot invalidate connection: Connection is not a poolable connection.");
            }
        }
        catch (SQLException sQLException) {
            throw new IllegalStateException("Cannot invalidate connection: Unwrapping poolable connection failed.", sQLException);
        }
        try {
            this.connectionPool.invalidateObject(poolableConnection);
        }
        catch (Exception exception) {
            throw new IllegalStateException("Invalidating connection threw unexpected exception", exception);
        }
    }

    @Override
    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    @Override
    public boolean isClearStatementPoolOnReturn() {
        return this.clearStatementPoolOnReturn;
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().isEmpty();
    }

    @Override
    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        return false;
    }

    private void jmxRegister() {
        if (this.registeredJmxObjectName != null) {
            return;
        }
        String string = this.getJmxName();
        if (string == null) {
            return;
        }
        try {
            ObjectNameWrapper.wrap(string).registerMBean(this);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            log.warn((Object)("The requested JMX name [" + string + "] was not valid and will be ignored."));
        }
    }

    protected void log(String string) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
        }
    }

    protected void log(String string, Throwable throwable) {
        if (this.logWriter != null) {
            this.logWriter.println(string);
            throwable.printStackTrace(this.logWriter);
        }
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        String string = this.getJmxName();
        if (string != null) {
            try {
                this.registeredJmxObjectName = ObjectNameWrapper.wrap(string);
            }
            catch (MalformedObjectNameException malformedObjectNameException) {
                log.warn((Object)("The requested JMX name [" + string + "] was not valid and will be ignored."));
            }
        }
        if (this.registeredJmxObjectName == null) {
            this.registeredJmxObjectName = ObjectNameWrapper.wrap(objectName);
        }
        return ObjectNameWrapper.unwrap(this.registeredJmxObjectName);
    }

    public void removeConnectionProperty(String string) {
        this.connectionProperties.remove(string);
    }

    @Override
    public synchronized void restart() throws SQLException {
        this.close();
        this.start();
    }

    public void setAbandonedLogWriter(PrintWriter printWriter) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogWriter(printWriter);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setAbandonedUsageTracking(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setUseUsageTracking(bl);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean bl) {
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void setAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public void setCacheState(boolean bl) {
        this.cacheState = bl;
    }

    public void setClearStatementPoolOnReturn(boolean bl) {
        this.clearStatementPoolOnReturn = bl;
    }

    public void setConnectionFactoryClassName(String string) {
        this.connectionFactoryClassName = this.isEmpty(string) ? null : string;
    }

    public void setConnectionInitSqls(Collection<String> collection) {
        if (collection != null && collection.size() > 0) {
            ArrayList<String> arrayList = null;
            for (String string : collection) {
                if (this.isEmpty(string)) continue;
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                }
                arrayList.add(string);
            }
            this.connectionInitSqls = arrayList;
        } else {
            this.connectionInitSqls = null;
        }
    }

    public void setConnectionProperties(String string) {
        Objects.requireNonNull(string, "connectionProperties is null");
        String[] stringArray = string.split(";");
        Properties properties = new Properties();
        for (String string2 : stringArray) {
            if (string2.length() <= 0) continue;
            int n = string2.indexOf(61);
            if (n > 0) {
                String string3 = string2.substring(0, n);
                String string4 = string2.substring(n + 1);
                properties.setProperty(string3, string4);
                continue;
            }
            properties.setProperty(string2, "");
        }
        this.connectionProperties = properties;
    }

    public void setDefaultAutoCommit(Boolean bl) {
        this.defaultAutoCommit = bl;
    }

    public void setDefaultCatalog(String string) {
        this.defaultCatalog = this.isEmpty(string) ? null : string;
    }

    public void setDefaultQueryTimeout(Integer n) {
        this.defaultQueryTimeoutSeconds = n;
    }

    public void setDefaultReadOnly(Boolean bl) {
        this.defaultReadOnly = bl;
    }

    public void setDefaultSchema(String string) {
        this.defaultSchema = this.isEmpty(string) ? null : string;
    }

    public void setDefaultTransactionIsolation(int n) {
        this.defaultTransactionIsolation = n;
    }

    public void setDisconnectionSqlCodes(Collection<String> collection) {
        if (collection != null && collection.size() > 0) {
            HashSet<String> hashSet = null;
            for (String string : collection) {
                if (this.isEmpty(string)) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<String>();
                }
                hashSet.add(string);
            }
            this.disconnectionSqlCodes = hashSet;
        } else {
            this.disconnectionSqlCodes = null;
        }
    }

    public synchronized void setDriver(Driver driver) {
        this.driver = driver;
    }

    public synchronized void setDriverClassLoader(ClassLoader classLoader) {
        this.driverClassLoader = classLoader;
    }

    public synchronized void setDriverClassName(String string) {
        this.driverClassName = this.isEmpty(string) ? null : string;
    }

    @Deprecated
    public void setEnableAutoCommitOnReturn(boolean bl) {
        this.autoCommitOnReturn = bl;
    }

    public synchronized void setEvictionPolicyClassName(String string) {
        if (this.connectionPool != null) {
            this.connectionPool.setEvictionPolicyClassName(string);
        }
        this.evictionPolicyClassName = string;
    }

    public void setFastFailValidation(boolean bl) {
        this.fastFailValidation = bl;
    }

    public synchronized void setInitialSize(int n) {
        this.initialSize = n;
    }

    public void setJmxName(String string) {
        this.jmxName = string;
    }

    public synchronized void setLifo(boolean bl) {
        this.lifo = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setLifo(bl);
        }
    }

    public void setLogAbandoned(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(bl);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setLogExpiredConnections(boolean bl) {
        this.logExpiredConnections = bl;
    }

    @Override
    public void setLoginTimeout(int n) throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.createDataSource().setLogWriter(printWriter);
        this.logWriter = printWriter;
    }

    public void setMaxConnLifetimeMillis(long l) {
        this.maxConnLifetimeMillis = l;
    }

    public synchronized void setMaxIdle(int n) {
        this.maxIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(n);
        }
    }

    public synchronized void setMaxOpenPreparedStatements(int n) {
        this.maxOpenPreparedStatements = n;
    }

    public synchronized void setMaxTotal(int n) {
        this.maxTotal = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxTotal(n);
        }
    }

    public synchronized void setMaxWaitMillis(long l) {
        this.maxWaitMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWaitMillis(l);
        }
    }

    public synchronized void setMinEvictableIdleTimeMillis(long l) {
        this.minEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized void setMinIdle(int n) {
        this.minIdle = n;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(n);
        }
    }

    public synchronized void setNumTestsPerEvictionRun(int n) {
        this.numTestsPerEvictionRun = n;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(n);
        }
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public synchronized void setPoolPreparedStatements(boolean bl) {
        this.poolPreparedStatements = bl;
    }

    public void setRemoveAbandonedOnBorrow(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnBorrow(bl);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRemoveAbandonedOnMaintenance(boolean bl) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(bl);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRemoveAbandonedTimeout(int n) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(n);
        GenericObjectPool<PoolableConnection> genericObjectPool = this.connectionPool;
        if (genericObjectPool != null) {
            genericObjectPool.setAbandonedConfig(this.abandonedConfig);
        }
    }

    public void setRollbackOnReturn(boolean bl) {
        this.rollbackOnReturn = bl;
    }

    public synchronized void setSoftMinEvictableIdleTimeMillis(long l) {
        this.softMinEvictableIdleTimeMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setSoftMinEvictableIdleTimeMillis(l);
        }
    }

    public synchronized void setTestOnBorrow(boolean bl) {
        this.testOnBorrow = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(bl);
        }
    }

    public synchronized void setTestOnCreate(boolean bl) {
        this.testOnCreate = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnCreate(bl);
        }
    }

    public synchronized void setTestOnReturn(boolean bl) {
        this.testOnReturn = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(bl);
        }
    }

    public synchronized void setTestWhileIdle(boolean bl) {
        this.testWhileIdle = bl;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(bl);
        }
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long l) {
        this.timeBetweenEvictionRunsMillis = l;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(l);
        }
    }

    public synchronized void setUrl(String string) {
        this.url = string;
    }

    public void setUsername(String string) {
        this.userName = string;
    }

    public void setValidationQuery(String string) {
        this.validationQuery = this.isEmpty(string) ? null : string;
    }

    public void setValidationQueryTimeout(int n) {
        this.validationQueryTimeoutSeconds = n;
    }

    @Override
    public synchronized void start() throws SQLException {
        this.closed = false;
        this.createDataSource();
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.timeBetweenEvictionRunsMillis > 0L) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        }
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    private void updateJmxName(GenericObjectPoolConfig<?> genericObjectPoolConfig) {
        if (this.registeredJmxObjectName == null) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder(this.registeredJmxObjectName.toString());
        stringBuilder.append(",connectionpool=");
        genericObjectPoolConfig.setJmxNameBase(stringBuilder.toString());
        genericObjectPoolConfig.setJmxNamePrefix("connections");
    }

    static {
        DriverManager.getDrivers();
        try {
            if (Utils.IS_SECURITY_ENABLED) {
                ClassLoader classLoader = BasicDataSource.class.getClassLoader();
                String string = BasicDataSource.class.getPackage().getName();
                classLoader.loadClass(string + ".DelegatingCallableStatement");
                classLoader.loadClass(string + ".DelegatingDatabaseMetaData");
                classLoader.loadClass(string + ".DelegatingPreparedStatement");
                classLoader.loadClass(string + ".DelegatingResultSet");
                classLoader.loadClass(string + ".PoolableCallableStatement");
                classLoader.loadClass(string + ".PoolablePreparedStatement");
                classLoader.loadClass(string + ".PoolingConnection$StatementType");
                classLoader.loadClass(string + ".PStmtKey");
                String string2 = PooledObject.class.getPackage().getName();
                classLoader.loadClass(string2 + ".impl.LinkedBlockingDeque$Node");
                classLoader.loadClass(string2 + ".impl.GenericKeyedObjectPool$ObjectDeque");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalStateException("Unable to pre-load classes", classNotFoundException);
        }
    }
}

